/*
 * Decompiled with CFR 0.152.
 */
package faker.generator;

import com.github.javafaker.Faker;
import faker.generator.FakeNewCollection;
import faker.generator.FakeNewInstance;
import faker.generator.services.FakeServiceName;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FakerGen {
    private static final Logger log = LoggerFactory.getLogger(FakerGen.class);
    private static Faker faker = Faker.instance();

    public static void changeLanguage(Locale locale) {
        faker = Faker.instance((Locale)locale);
    }

    public static <T> Optional<T> create(Class<T> clazz, String ... ignoreProperties) {
        return FakerGen.create(clazz, Arrays.asList(ignoreProperties));
    }

    public static <T> Optional<T> create(Class<T> clazz, List<String> ignoreProperties) {
        try {
            Object data = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Field[] fields = FieldUtils.getAllFields(clazz);
            Arrays.asList(fields).stream().filter(f -> !ignoreProperties.contains(f.getName())).forEach(f -> {
                try {
                    f.setAccessible(true);
                    if (f.isAnnotationPresent(FakeNewInstance.class)) {
                        Optional<?> newInstance = FakerGen.create(f.getType(), ignoreProperties);
                        newInstance.ifPresent(ni -> {
                            FakeNewInstance fnewInstance = f.getAnnotation(FakeNewInstance.class);
                            if (fnewInstance.lookForReference()) {
                                Optional<Field> reference = Arrays.stream(FieldUtils.getAllFields(ni.getClass())).filter(field -> field.getType().isAssignableFrom(clazz)).findFirst();
                                reference.ifPresent(field -> {
                                    try {
                                        field.setAccessible(true);
                                        field.set(ni, data);
                                    }
                                    catch (IllegalAccessException e) {
                                        log.debug("Exception when we tried to do something crazy", (Throwable)e);
                                    }
                                });
                            }
                        });
                        f.set(data, newInstance.orElse(null));
                    } else if (f.isAnnotationPresent(FakeNewCollection.class)) {
                        FakeNewCollection fakeNewCollection = f.getAnnotation(FakeNewCollection.class);
                        int endValue = fakeNewCollection.fixValue() == -1 ? faker.number().numberBetween(1, fakeNewCollection.maxValue()) : fakeNewCollection.fixValue();
                        ArrayList arrayList = new ArrayList(endValue);
                        for (int i = 0; i < endValue; ++i) {
                            Optional<?> d = FakerGen.create(fakeNewCollection.value(), ignoreProperties);
                            d.ifPresent(ni -> {
                                if (fakeNewCollection.lookForReference()) {
                                    Optional<Field> reference = Arrays.stream(ni.getClass().getDeclaredFields()).filter(field -> field.getType().isAssignableFrom(clazz)).findFirst();
                                    reference.ifPresent(field -> {
                                        try {
                                            field.setAccessible(true);
                                            field.set(ni, data);
                                        }
                                        catch (IllegalAccessException e) {
                                            log.debug("Exception when we tried to do something crazy", (Throwable)e);
                                        }
                                    });
                                }
                                arrayList.add(ni);
                            });
                        }
                        f.set(data, arrayList);
                    } else {
                        Optional<Annotation> an = Arrays.stream(f.getDeclaredAnnotations()).filter(a -> a.annotationType().isAnnotationPresent(FakeServiceName.class)).findFirst();
                        an.ifPresent(a -> {
                            FakeServiceName fsn = a.annotationType().getAnnotation(FakeServiceName.class);
                            try {
                                fsn.value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).setValue(a, (Field)f, data, faker);
                            }
                            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                                log.debug("Problem with create a new instance of {}", fsn.value(), (Object)e);
                            }
                        });
                    }
                }
                catch (IllegalAccessException e) {
                    log.debug("Exception when we tried to do something crazy", (Throwable)e);
                }
            });
            return Optional.of(data);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.debug("Exception when we tried to do something crazy", (Throwable)e);
            return Optional.empty();
        }
    }
}

