/*
 * Decompiled with CFR 0.152.
 */
package faker.generator.services;

import com.github.javafaker.Faker;
import faker.generator.FakeNumber;
import faker.generator.services.FakeService;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import lombok.NonNull;

public class FakeNumberService
implements FakeService<FakeNumber> {
    @Override
    public void setValue(FakeNumber annotation, Field target, Object data, Faker faker) throws IllegalAccessException {
        switch (annotation.value()) {
            case DIGIT: {
                if (annotation.count() > 0) {
                    target.set(data, this.chooseCorrectType(target, faker.number().digits(annotation.count())));
                    break;
                }
                target.set(data, this.chooseCorrectType(target, faker.number().digit()));
                break;
            }
            case NUMBER_BETWEEN: {
                if (annotation.minValue() >= 0 && annotation.maxValue() >= 0) {
                    target.set(data, this.chooseCorrectType(target, faker.number().numberBetween(annotation.minValue(), annotation.maxValue())));
                    break;
                }
                throw new IllegalArgumentException("You need set the values min value and max value to use this function");
            }
            case RANDOM_DIGIT: {
                target.set(data, this.chooseCorrectType(target, faker.number().randomDigit()));
                break;
            }
            case RANDOM_DIGIT_NON_ZERO: {
                target.set(data, this.chooseCorrectType(target, faker.number().randomDigitNotZero()));
                break;
            }
            case RANDOM_DOUBLE: {
                if (annotation.maxNumberOfDecimal() > -1 && annotation.minValue() >= 0 && annotation.maxValue() >= 0) {
                    target.set(data, this.chooseCorrectType(target, faker.number().randomDouble(annotation.maxNumberOfDecimal(), annotation.minValue(), annotation.maxValue())));
                    break;
                }
                throw new IllegalArgumentException("You need set the values, maxNumberOfDecimal, minValue and maxValue");
            }
            case RANDOM_NUMBER: {
                if (annotation.count() > 0) {
                    target.set(data, this.chooseCorrectType(target, faker.number().randomNumber(annotation.count(), annotation.strict())));
                    break;
                }
                target.set(data, this.chooseCorrectType(target, faker.number().randomNumber()));
            }
        }
    }

    public Object chooseCorrectType(Field target, @NonNull Object number) {
        if (number == null) {
            throw new NullPointerException("number is marked non-null but is null");
        }
        if (BigDecimal.class.isAssignableFrom(target.getType())) {
            return new BigDecimal(number.toString());
        }
        if (BigInteger.class.isAssignableFrom(target.getType())) {
            String integerNumber = number.toString().split("\\.")[0];
            return new BigInteger(integerNumber);
        }
        return number;
    }
}

