/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.cdi;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.itemis.maven.plugins.cdi.CDIMojoProcessingStep;
import com.itemis.maven.plugins.cdi.annotations.MojoProduces;
import com.itemis.maven.plugins.cdi.annotations.ProcessingStep;
import com.itemis.maven.plugins.cdi.internal.beans.CdiBeanWrapper;
import com.itemis.maven.plugins.cdi.internal.beans.CdiProducerBean;
import com.itemis.maven.plugins.cdi.internal.util.CDIUtil;
import com.itemis.maven.plugins.cdi.internal.util.MavenUtil;
import com.itemis.maven.plugins.cdi.internal.util.workflow.ProcessingWorkflow;
import com.itemis.maven.plugins.cdi.internal.util.workflow.WorkflowExecutor;
import com.itemis.maven.plugins.cdi.internal.util.workflow.WorkflowUtil;
import com.itemis.maven.plugins.cdi.internal.util.workflow.WorkflowValidator;
import com.itemis.maven.plugins.cdi.logging.MavenLogWrapper;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.inject.Named;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;

public class AbstractCDIMojo
extends AbstractMojo
implements Extension {
    private static final String SYSPROP_PRINT_WF = "printWorkflow";
    private static final String SYSPROP_PRINT_STEPS = "printSteps";
    @Component
    private ArtifactResolver _resolver;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings _settings;
    @Parameter(readonly=true, defaultValue="${repositorySystemSession}")
    private RepositorySystemSession _repoSystemSession;
    @Parameter(readonly=true, defaultValue="${project.remotePluginRepositories}")
    private List<RemoteRepository> _pluginRepos;
    @Parameter(property="mojoExecution", readonly=true)
    private MojoExecution _mojoExecution;
    @Parameter(property="session", readonly=true)
    private MavenSession _session;
    @Parameter(property="workflow")
    private File workflowDescriptor;
    @MojoProduces
    @Named(value="enableLogTimestamps")
    @Parameter(defaultValue="true", property="enableLogTimestamps")
    private boolean enableLogTimestamps;
    private ProcessingWorkflow workflow;
    private Map<String, ProcessingStep> allAvailableProcessingSteps = Maps.newHashMap();

    @MojoProduces
    public final MavenLogWrapper createLogWrapper() {
        MavenLogWrapper log = new MavenLogWrapper(this.getLog());
        if (this.enableLogTimestamps) {
            log.enableLogTimestamps();
        }
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (System.getProperty(SYSPROP_PRINT_WF) != null) {
            WorkflowUtil.printWorkflow(this.getGoalName(), this.getPluginDescriptor(), (Optional<File>)Optional.fromNullable((Object)this.workflowDescriptor), this.createLogWrapper());
            return;
        }
        System.setProperty("org.jboss.logging.provider", "slf4j");
        String logLevel = "info";
        if (this.getLog().isDebugEnabled()) {
            logLevel = "debug";
        }
        System.setProperty("org.slf4j.simpleLogger.log.org.jboss.weld", logLevel);
        Weld weld = new Weld();
        weld.addExtension((Extension)this);
        this.addPluginDependencies(weld);
        WeldContainer weldContainer = null;
        try {
            weldContainer = weld.initialize();
            if (System.getProperty(SYSPROP_PRINT_STEPS) != null) {
                WorkflowUtil.printAvailableSteps(this.allAvailableProcessingSteps, this.createLogWrapper());
                return;
            }
            WorkflowUtil.addExecutionContexts(this.getWorkflow());
            Map<String, CDIMojoProcessingStep> processingSteps = this.getAllProcessingSteps(weldContainer);
            PluginParameterExpressionEvaluator expressionEvaluator = new PluginParameterExpressionEvaluator(this._session, this._mojoExecution);
            WorkflowExecutor executor = new WorkflowExecutor(this.getWorkflow(), processingSteps, this.getLog(), expressionEvaluator);
            executor.validate(!this._settings.isOffline());
            executor.execute();
        }
        finally {
            if (weldContainer != null && weldContainer.isRunning()) {
                weldContainer.shutdown();
            }
        }
    }

    private ProcessingWorkflow getWorkflow() throws MojoExecutionException, MojoFailureException {
        if (this.workflow == null) {
            List<String> trimmedWorkflowLines = WorkflowUtil.getTrimmedWorkflowLines(this.getGoalName(), this.getPluginDescriptor(), (Optional<File>)Optional.fromNullable((Object)this.workflowDescriptor), this.createLogWrapper());
            WorkflowValidator.validateSyntactically(trimmedWorkflowLines);
            this.workflow = WorkflowUtil.parseWorkflow(trimmedWorkflowLines, this.getGoalName());
        }
        return this.workflow;
    }

    private void skipUnusedStepsFromBeanDiscovery(@Observes ProcessAnnotatedType<?> event, BeanManager beanManager) throws MojoExecutionException, MojoFailureException {
        Class type = event.getAnnotatedType().getJavaClass();
        ProcessingStep annotation = type.getAnnotation(ProcessingStep.class);
        if (annotation != null) {
            String id = annotation.id();
            Preconditions.checkState((!this.allAvailableProcessingSteps.containsKey(id) ? 1 : 0) != 0, (Object)("The processing step id '" + id + "' is not unique!"));
            this.allAvailableProcessingSteps.put(id, annotation);
            ProcessingWorkflow workflow = this.getWorkflow();
            if (!workflow.containsStep(annotation.id())) {
                event.veto();
            }
        }
    }

    private void processMojoCdiProducerFields(@Observes AfterBeanDiscovery event, BeanManager beanManager) throws MojoExecutionException {
        HashSet fields = Sets.newHashSet();
        for (Class<?> cls = ((Object)((Object)this)).getClass(); cls != AbstractCDIMojo.class; cls = cls.getSuperclass()) {
            fields.addAll(Sets.newHashSet((Object[])cls.getFields()));
            fields.addAll(Sets.newHashSet((Object[])cls.getDeclaredFields()));
        }
        for (Field f : fields) {
            if (!f.isAnnotationPresent(MojoProduces.class)) continue;
            try {
                f.setAccessible(true);
                event.addBean(new CdiBeanWrapper<Object>(f.get((Object)this), f.getGenericType(), f.getType(), CDIUtil.getCdiQualifiers(f)));
            }
            catch (Throwable t) {
                throw new MojoExecutionException("Could not process CDI producer field of the Mojo.", t);
            }
        }
    }

    private void processMojoCdiProducerMethods(@Observes AfterBeanDiscovery event, BeanManager beanManager) throws MojoExecutionException {
        HashSet methods = Sets.newHashSet();
        for (Class<?> cls = ((Object)((Object)this)).getClass(); cls != AbstractCDIMojo.class; cls = cls.getSuperclass()) {
            methods.addAll(Sets.newHashSet((Object[])cls.getMethods()));
            methods.addAll(Sets.newHashSet((Object[])cls.getDeclaredMethods()));
        }
        for (Method m : methods) {
            if (m.getReturnType() == Void.class || !m.isAnnotationPresent(MojoProduces.class)) continue;
            try {
                event.addBean(new CdiProducerBean(m, (Object)this, beanManager, m.getGenericReturnType(), m.getReturnType(), CDIUtil.getCdiQualifiers(m)));
            }
            catch (Throwable t) {
                throw new MojoExecutionException("Could not process CDI producer method of the Mojo.", t);
            }
        }
    }

    private void addPluginDependencies(Weld weld) throws MojoExecutionException {
        PluginDescriptor pluginDescriptor = this.getPluginDescriptor();
        List dependencies = pluginDescriptor.getPlugin().getDependencies();
        for (Dependency d : dependencies) {
            Optional<File> f = MavenUtil.resolvePluginDependency(d, this._pluginRepos, this._resolver, this._repoSystemSession);
            if (f.isPresent()) {
                CDIUtil.addAllClasses(weld, ((Object)((Object)this)).getClass().getClassLoader(), (File)f.get(), this.getLog());
                continue;
            }
            throw new MojoExecutionException("Could not resolve the following plugin dependency: " + d);
        }
    }

    private Map<String, CDIMojoProcessingStep> getAllProcessingSteps(WeldContainer weldContainer) {
        HashMap steps = Maps.newHashMap();
        Collection<CDIMojoProcessingStep> beans = CDIUtil.getAllBeansOfType(weldContainer, CDIMojoProcessingStep.class);
        for (CDIMojoProcessingStep bean : beans) {
            ProcessingStep annotation = bean.getClass().getAnnotation(ProcessingStep.class);
            if (annotation == null) continue;
            String id = annotation.id();
            Preconditions.checkState((!steps.containsKey(id) ? 1 : 0) != 0, (Object)("The processing step id '" + id + "' is not unique!"));
            steps.put(id, bean);
        }
        return steps;
    }

    private String getGoalName() {
        PluginDescriptor pluginDescriptor = this.getPluginDescriptor();
        for (MojoDescriptor mojoDescriptor : pluginDescriptor.getMojos()) {
            if (!mojoDescriptor.getImplementation().equals(((Object)((Object)this)).getClass().getName())) continue;
            return mojoDescriptor.getGoal();
        }
        return null;
    }

    private PluginDescriptor getPluginDescriptor() {
        return (PluginDescriptor)this.getPluginContext().get("pluginDescriptor");
    }

    private MavenProject getProject() {
        return (MavenProject)this.getPluginContext().get("project");
    }
}

