/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.cdi.internal.util.workflow;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.itemis.maven.plugins.cdi.internal.util.workflow.WorkflowStep;

public class SimpleWorkflowStep
implements WorkflowStep {
    private String id;
    private Optional<String> qualifier;
    private Optional<String> defaultExecutionData;
    private Optional<String> defaultRollbackData;

    public SimpleWorkflowStep(String id, Optional<String> qualifier) {
        this.id = id;
        this.qualifier = qualifier;
        this.defaultExecutionData = Optional.absent();
        this.defaultRollbackData = Optional.absent();
    }

    @Override
    public boolean isParallel() {
        return false;
    }

    public String getStepId() {
        return this.id;
    }

    public Optional<String> getQualifier() {
        return this.qualifier;
    }

    public String getCompositeStepId() {
        return this.id + (this.qualifier.isPresent() ? "[" + (String)this.qualifier.get() + "]" : "");
    }

    public void setDefaultExecutionData(String data) {
        this.defaultExecutionData = Optional.fromNullable((Object)data);
    }

    public Optional<String> getDefaultExecutionData() {
        return this.defaultExecutionData;
    }

    public void setDefaultRollbackData(String data) {
        this.defaultRollbackData = Optional.fromNullable((Object)data);
    }

    public Optional<String> getDefaultRollbackData() {
        return this.defaultRollbackData;
    }

    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this);
        toStringHelper.add("id", (Object)this.id);
        toStringHelper.add("qualifier", this.qualifier.or((Object)"---"));
        toStringHelper.add("defaultExecutionData", this.defaultExecutionData.or((Object)"---"));
        toStringHelper.add("defaultRollbackData", this.defaultRollbackData.or((Object)"---"));
        return toStringHelper.toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.qualifier.orNull()});
    }

    public boolean equals(Object other) {
        if (other instanceof SimpleWorkflowStep) {
            SimpleWorkflowStep otherStep = (SimpleWorkflowStep)other;
            return Objects.equal((Object)this.id, (Object)otherStep.getStepId()) && Objects.equal(this.qualifier, otherStep.getQualifier());
        }
        return false;
    }

    @Override
    public boolean containsId(String id) {
        return Objects.equal((Object)id, (Object)this.id);
    }
}

