/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.cdi.internal.util.workflow;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.itemis.maven.plugins.cdi.ExecutionContext;
import com.itemis.maven.plugins.cdi.annotations.ProcessingStep;
import com.itemis.maven.plugins.cdi.internal.util.workflow.ParallelWorkflowStep;
import com.itemis.maven.plugins.cdi.internal.util.workflow.ProcessingWorkflow;
import com.itemis.maven.plugins.cdi.internal.util.workflow.SimpleWorkflowStep;
import com.itemis.maven.plugins.cdi.internal.util.workflow.WorkflowStep;
import com.itemis.maven.plugins.cdi.logging.Logger;
import de.vandermeer.asciitable.AT_Cell;
import de.vandermeer.asciitable.AT_ColumnWidthCalculator;
import de.vandermeer.asciitable.AT_Context;
import de.vandermeer.asciitable.AT_Renderer;
import de.vandermeer.asciitable.AT_Row;
import de.vandermeer.asciitable.AsciiTable;
import de.vandermeer.asciitable.CWC_LongestLine;
import de.vandermeer.asciithemes.u8.U8_Grids;
import de.vandermeer.skb.interfaces.transformers.textformat.TextAlignment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;

public class WorkflowUtil {
    public static final String CONTEXT_DATA_MAP_ASSIGNMENT = "=>";
    public static final String CONTEXT_DATA_SEPARATOR = ",";
    private static final String DEFAULT_WORKFLOW_DIR = "META-INF/workflows";

    public static ProcessingWorkflow parseWorkflow(List<String> trimmedWorkflowLines, String goalName) {
        ProcessingWorkflow workflow = new ProcessingWorkflow(goalName);
        ParallelWorkflowStep.Builder parallelStepBuilder = null;
        SimpleWorkflowStep currentStep = null;
        boolean isTryBlock = false;
        boolean isFinallyBlock = false;
        for (String line : trimmedWorkflowLines) {
            if (line.startsWith("#") || line.isEmpty()) continue;
            if (line.startsWith("try")) {
                isTryBlock = true;
                isFinallyBlock = false;
                continue;
            }
            if (line.startsWith("parallel")) {
                if (isFinallyBlock) {
                    throw new RuntimeException("Parallel block is not supported within finally-block. Processed line was: '" + line + "'");
                }
                parallelStepBuilder = ParallelWorkflowStep.builder();
                continue;
            }
            if (Objects.equal((Object)"}", (Object)line)) {
                if (currentStep != null) {
                    currentStep = null;
                    continue;
                }
                if (parallelStepBuilder != null) {
                    workflow.addProcessingStep(parallelStepBuilder.build());
                    parallelStepBuilder = null;
                    continue;
                }
                if (!isFinallyBlock) continue;
                isFinallyBlock = false;
                continue;
            }
            if (line.startsWith("}")) {
                if (!isTryBlock) continue;
                isTryBlock = false;
                String substring = line.substring(1).trim();
                if (!substring.startsWith("finally") || !substring.endsWith("{")) continue;
                isFinallyBlock = true;
                continue;
            }
            if (currentStep == null) {
                String id = WorkflowUtil.parseId(line);
                Optional<String> qualifier = WorkflowUtil.parseQualifier(line);
                SimpleWorkflowStep step = new SimpleWorkflowStep(id, qualifier);
                if (line.endsWith("{")) {
                    currentStep = step;
                }
                if (isFinallyBlock) {
                    workflow.addFinallyStep(step);
                    continue;
                }
                if (parallelStepBuilder == null) {
                    workflow.addProcessingStep(step);
                    continue;
                }
                parallelStepBuilder.addSteps(step);
                continue;
            }
            WorkflowUtil.setDefaultExecutionData(currentStep, line);
            WorkflowUtil.setDefaultRollbackData(currentStep, line);
        }
        return workflow;
    }

    @Deprecated
    public static ProcessingWorkflow parseWorkflow(InputStream is, String goalName) {
        List<String> trimmedWorkflowLines;
        try {
            trimmedWorkflowLines = WorkflowUtil.getTrimmedWorkflowLines(is);
        }
        catch (MojoExecutionException e) {
            throw new RuntimeException("Unable to read the workflow descriptor from the provided input stream.", e);
        }
        return WorkflowUtil.parseWorkflow(trimmedWorkflowLines, goalName);
    }

    private static String parseId(String line) {
        int qualifierOpen = line.indexOf("[");
        int blockOpen = line.indexOf("{");
        int toIndex = qualifierOpen > -1 ? qualifierOpen : (blockOpen > -1 ? blockOpen : line.length());
        return line.substring(0, toIndex).trim();
    }

    private static Optional<String> parseQualifier(String line) {
        String qualifier = null;
        int qualifierOpen = line.indexOf("[");
        if (qualifierOpen > -1) {
            int qualifierClose = line.indexOf("]", qualifierOpen);
            qualifier = line.substring(qualifierOpen + 1, qualifierClose);
        }
        return Optional.fromNullable(qualifier);
    }

    private static void setDefaultExecutionData(SimpleWorkflowStep step, String line) {
        if (line.startsWith("data")) {
            int startIndex = line.indexOf("=") + 1;
            step.setDefaultExecutionData(line.substring(startIndex).trim());
        }
    }

    private static void setDefaultRollbackData(SimpleWorkflowStep step, String line) {
        if (line.startsWith("rollbackData")) {
            int startIndex = line.indexOf("=") + 1;
            step.setDefaultRollbackData(line.substring(startIndex).trim());
        }
    }

    public static void addExecutionContexts(ProcessingWorkflow workflow) {
        Iterable steps = Iterables.unmodifiableIterable((Iterable)Iterables.concat(workflow.getProcessingSteps(), workflow.getFinallySteps()));
        for (WorkflowStep step : steps) {
            if (step.isParallel()) {
                ParallelWorkflowStep parallelStep = (ParallelWorkflowStep)step;
                for (SimpleWorkflowStep simpleStep : parallelStep.getSteps()) {
                    workflow.addExecutionContext(simpleStep.getCompositeStepId(), WorkflowUtil.createExecutionContext(simpleStep));
                }
                continue;
            }
            SimpleWorkflowStep simpleStep = (SimpleWorkflowStep)step;
            workflow.addExecutionContext(simpleStep.getCompositeStepId(), WorkflowUtil.createExecutionContext(simpleStep));
        }
    }

    private static ExecutionContext createExecutionContext(SimpleWorkflowStep step) {
        String dataRollbackPropertyValue;
        String dataPropertyValue;
        ExecutionContext.Builder builder = ExecutionContext.builder(step.getStepId());
        if (step.getQualifier().isPresent()) {
            builder.setQualifier((String)step.getQualifier().get());
        }
        if ((dataPropertyValue = System.getProperty(step.getCompositeStepId())) == null) {
            dataPropertyValue = (String)step.getDefaultExecutionData().orNull();
        }
        if (dataPropertyValue != null) {
            Iterable split = Splitter.on((String)CONTEXT_DATA_SEPARATOR).split((CharSequence)dataPropertyValue);
            for (String token : split) {
                String date = Strings.emptyToNull((String)token.trim());
                if (date == null) continue;
                List dataSplit = Splitter.on((String)CONTEXT_DATA_MAP_ASSIGNMENT).splitToList((CharSequence)date);
                if (dataSplit.size() == 1) {
                    builder.addData((String)dataSplit.get(0));
                    continue;
                }
                builder.addData((String)dataSplit.get(0), (String)dataSplit.get(1));
            }
        }
        if ((dataRollbackPropertyValue = System.getProperty(step.getCompositeStepId() + "-rollback")) == null) {
            dataRollbackPropertyValue = (String)step.getDefaultRollbackData().orNull();
        }
        if (dataRollbackPropertyValue != null) {
            Iterable split = Splitter.on((String)CONTEXT_DATA_SEPARATOR).split((CharSequence)dataRollbackPropertyValue);
            for (String token : split) {
                String date = Strings.emptyToNull((String)token.trim());
                if (date == null) continue;
                List dataSplit = Splitter.on((String)CONTEXT_DATA_MAP_ASSIGNMENT).splitToList((CharSequence)date);
                if (dataSplit.size() == 1) {
                    builder.addRollbackData((String)dataSplit.get(0));
                    continue;
                }
                builder.addRollbackData((String)dataSplit.get(0), (String)dataSplit.get(1));
            }
        }
        return builder.build();
    }

    private static InputStream getWorkflowInputStream(String goalName, PluginDescriptor pluginDescriptor, Optional<File> customWorkflowDescriptor, Logger log) throws MojoExecutionException {
        log.info("Constructing workflow for processing");
        String goalPrefix = pluginDescriptor.getGoalPrefix();
        if (customWorkflowDescriptor.isPresent()) {
            File customDescriptor = (File)customWorkflowDescriptor.get();
            log.debug("Requested overriding of workflow with file: " + customDescriptor.getAbsolutePath());
            if (customDescriptor.exists() && customDescriptor.isFile()) {
                try {
                    log.info("Default workflow of goal '" + goalPrefix + ':' + goalName + "' will be overridden by file '" + customDescriptor.getAbsolutePath() + "'.");
                    return new FileInputStream(customDescriptor);
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Unable to load custom workflow for goal " + goalName, e);
                }
            }
            throw new MojoExecutionException("Unable to load custom workflow for goal " + goalPrefix + ':' + goalName + ". The workflow file '" + customDescriptor.getAbsolutePath() + "' does not exist!");
        }
        log.info("Goal '" + goalPrefix + ':' + goalName + "' will use default workflow packaged with the plugin.");
        return WorkflowUtil.getResourceStream("META-INF/workflows/" + goalName);
    }

    public static InputStream getResourceStream(String resourcePath) throws MojoExecutionException {
        InputStream ret = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcePath);
        if (ret == null) {
            throw new MojoExecutionException("Resource for path '" + resourcePath + "' does not exist!");
        }
        return ret;
    }

    @Deprecated
    public static InputStream getWorkflowDescriptor(String goalName, PluginDescriptor pluginDescriptor, Optional<File> customWorkflowDescriptor, Logger log) throws MojoExecutionException {
        return WorkflowUtil.getWorkflowInputStream(goalName, pluginDescriptor, customWorkflowDescriptor, log);
    }

    public static List<String> getTrimmedWorkflowLines(InputStream is) throws MojoExecutionException {
        ArrayList ret = Lists.newArrayList();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
            String line;
            while ((line = br.readLine()) != null) {
                ret.add(line.trim());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read the workflow from the input stream provided.", (Exception)e);
        }
        return ret;
    }

    public static List<String> getTrimmedWorkflowLines(String goalName, PluginDescriptor pluginDescriptor, Optional<File> customWorkflowDescriptor, Logger log) throws MojoExecutionException {
        return WorkflowUtil.getTrimmedWorkflowLines(WorkflowUtil.getWorkflowInputStream(goalName, pluginDescriptor, customWorkflowDescriptor, log));
    }

    public static void printWorkflow(String goalName, PluginDescriptor pluginDescriptor, Optional<File> customWorkflowDescriptor, Logger log) throws MojoExecutionException {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)pluginDescriptor.getGoalPrefix())) {
            sb.append(pluginDescriptor.getGoalPrefix());
        } else {
            sb.append(pluginDescriptor.getGroupId()).append(':').append(pluginDescriptor.getArtifactId()).append(':').append(pluginDescriptor.getVersion());
        }
        sb.append(':').append(goalName);
        log.info("Default workflow for '" + sb + "':");
        List<String> trimmedWorkflowLines = WorkflowUtil.getTrimmedWorkflowLines(goalName, pluginDescriptor, customWorkflowDescriptor, log);
        int x = 77 - goalName.length();
        int a = x / 2;
        int b = x % 2 == 1 ? a + 1 : a;
        StringBuilder separator = new StringBuilder();
        separator.append(Strings.repeat((String)"=", (int)a)).append(' ').append(goalName).append(' ').append(Strings.repeat((String)"=", (int)b));
        System.out.println(separator);
        trimmedWorkflowLines.forEach(line -> System.out.println((String)line));
        System.out.println(separator);
    }

    public static void printAvailableSteps(Map<String, ProcessingStep> steps, Logger log) {
        log.info("The following processing steps are available on classpath and can be configured as part of a custom workflow.");
        System.out.println(WorkflowUtil.renderAvailableSteps(steps));
    }

    public static String renderAvailableSteps(Map<String, ProcessingStep> steps) {
        AsciiTable table = new AsciiTable(new AT_Context().setGrid(U8_Grids.borderStrongDoubleLight()));
        table.addRule();
        AT_Row header = table.addRow(new Object[]{"ID", "DESCRIPTION", "REQUIRES ONLINE"});
        header.setTextAlignment(TextAlignment.CENTER);
        table.addStrongRule();
        ArrayList sortedIds = Lists.newArrayList(steps.keySet());
        Collections.sort(sortedIds);
        for (String id : sortedIds) {
            ProcessingStep annotation = steps.get(id);
            AT_Row data = table.addRow(new Object[]{annotation.id(), annotation.description(), annotation.requiresOnline()});
            data.setTextAlignment(TextAlignment.CENTER).setPaddingLeftRight(1);
            ((AT_Cell)data.getCells().get(0)).getContext().setTextAlignment(TextAlignment.LEFT);
            ((AT_Cell)data.getCells().get(1)).getContext().setTextAlignment(TextAlignment.LEFT);
            table.addRule();
        }
        return table.setRenderer(AT_Renderer.create().setCWC((AT_ColumnWidthCalculator)new CWC_LongestLine().add(10, 20).add(20, 50).add(10, 10))).render();
    }
}

