/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.cdi.internal.util.workflow;

import java.util.List;

public class WorkflowValidator {
    public static void validateSyntactically(List<String> trimmedWorkflowLines) {
        boolean isTryBlockOpen = false;
        boolean isFinallyBlockOpen = false;
        int nrOfOpenTryBlocks = 0;
        int lineNumber = 0;
        for (String line : trimmedWorkflowLines) {
            if (line.startsWith("#") || line.isEmpty()) continue;
            if (isTryBlockOpen = WorkflowValidator.validateTryBlockOpening(line, ++lineNumber)) {
                ++nrOfOpenTryBlocks;
            }
            if (!(isFinallyBlockOpen = WorkflowValidator.validateFinallyBlockOpening(line))) continue;
            if (nrOfOpenTryBlocks > 0) {
                --nrOfOpenTryBlocks;
                continue;
            }
            throw new RuntimeException("There is a finally-block opening without a related try-block. Processed line was: '" + line + "'");
        }
        if (nrOfOpenTryBlocks > 0) {
            throw new RuntimeException("There are try-blocks missing a closing finally-block.");
        }
    }

    private static boolean validateTryBlockOpening(String line, int lineNumber) {
        if (line.contains("try")) {
            if (!line.startsWith("try")) {
                throw new RuntimeException("Opening the try-block requires the keyword 'try' to be the first token of the line. Processed line was: '" + line + "'");
            }
            if (lineNumber != 1) {
                throw new RuntimeException("The try-block opening must be the first statement. Only comments are allowed to occur before opening the try-block. Processed line was: '" + line + "'");
            }
            String remainingContent = line.substring("try".length()).trim();
            if (!remainingContent.equals("{")) {
                throw new RuntimeException("The try block opening must end with the block opening character '{'. Processed line was: '" + line + "'");
            }
            return true;
        }
        return false;
    }

    private static boolean validateFinallyBlockOpening(String line) {
        String remainingContent;
        if (line.startsWith("}") && (remainingContent = line.substring(1).trim()).startsWith("finally")) {
            if (!(remainingContent = remainingContent.substring("finally".length()).trim()).equals("{")) {
                throw new RuntimeException("The finally block opening must end with the block opening character '{'. Processed line was: '" + line + "'");
            }
            return true;
        }
        return false;
    }
}

