/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.steps.actions;

import com.google.common.base.Optional;
import com.itemis.maven.plugins.cdi.CDIMojoProcessingStep;
import com.itemis.maven.plugins.cdi.ExecutionContext;
import com.itemis.maven.plugins.cdi.annotations.ProcessingStep;
import com.itemis.maven.plugins.cdi.logging.Logger;
import com.itemis.maven.plugins.unleash.util.ReleaseUtil;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.utils.cli.CommandLineException;

@ProcessingStep(id="buildReleaseArtifacts", description="Triggers the atual release build which produces the release artifacts but does not install or deploy them.")
public class BuildProject
implements CDIMojoProcessingStep {
    @Inject
    private Logger log;
    @Inject
    private MavenProject project;
    @Inject
    @Named(value="profiles")
    private List<String> profiles;
    @Inject
    @Named(value="maven.home")
    private String mavenHome;
    @Inject
    private Settings settings;
    @Inject
    @Named(value="releaseGoals")
    private List<String> goals;
    @Inject
    @Named(value="releaseArgs")
    private Properties releaseArgs;
    @Inject
    @Named(value="unleashOutputFolder")
    private File unleashOutputFolder;
    @Inject
    @Named(value="releaseEnvVariables")
    private Map<String, String> releaseEnvironmentVariables;
    @Inject
    private MavenSession session;

    public void execute(ExecutionContext context) throws MojoExecutionException, MojoFailureException {
        this.log.info((CharSequence)"Starting release build.");
        try {
            InvocationRequest request = this.setupInvocationRequest();
            Invoker invoker = this.setupInvoker();
            InvocationResult result = invoker.execute(request);
            if (result.getExitCode() != 0) {
                CommandLineException executionException = result.getExecutionException();
                if (executionException != null) {
                    throw new MojoFailureException("Error during project build: " + executionException.getMessage(), (Throwable)executionException);
                }
                throw new MojoFailureException("Error during project build: " + result.getExitCode());
            }
        }
        catch (MavenInvocationException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private Invoker setupInvoker() {
        DefaultInvoker invoker = new DefaultInvoker();
        File calculatedMavenHome = ReleaseUtil.getMavenHome((Optional<String>)Optional.fromNullable((Object)this.mavenHome));
        if (calculatedMavenHome != null) {
            this.log.debug((CharSequence)("\tUsing maven home: " + calculatedMavenHome.getAbsolutePath()));
            invoker.setMavenHome(calculatedMavenHome);
        }
        return invoker;
    }

    private InvocationRequest setupInvocationRequest() {
        File toolchainsFile;
        File userSettingsFile;
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setPomFile(this.project.getFile());
        request.setGoals(this.goals);
        if (this.releaseArgs.containsKey("-X") || this.releaseArgs.containsKey("--debug")) {
            this.releaseArgs.remove("-X");
            this.releaseArgs.remove("--debug");
            request.setDebug(true);
        }
        if (this.releaseArgs.containsKey("-e") || this.releaseArgs.containsKey("--errors")) {
            this.releaseArgs.remove("-e");
            this.releaseArgs.remove("--errors");
            request.setShowErrors(true);
        }
        request.setProperties(this.releaseArgs);
        request.setProfiles(this.profiles);
        request.setShellEnvironmentInherited(true);
        for (String key : this.releaseEnvironmentVariables.keySet()) {
            request.addShellEnvironment(key, this.releaseEnvironmentVariables.get(key));
        }
        request.addShellEnvironment("isUnleashBuild", "true");
        request.setOffline(this.settings.isOffline());
        request.setBatchMode(!this.settings.isInteractiveMode());
        MavenExecutionRequest originalRequest = this.session.getRequest();
        File globalSettingsFile = originalRequest.getGlobalSettingsFile();
        if (globalSettingsFile != null && globalSettingsFile.exists() && globalSettingsFile.isFile()) {
            request.setGlobalSettingsFile(globalSettingsFile);
        }
        if ((userSettingsFile = originalRequest.getUserSettingsFile()) != null && userSettingsFile.exists() && userSettingsFile.isFile()) {
            request.setUserSettingsFile(userSettingsFile);
        }
        if ((toolchainsFile = originalRequest.getUserToolchainsFile()).exists() && toolchainsFile.isFile()) {
            request.setToolchainsFile(toolchainsFile);
        }
        return request;
    }
}

