/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.steps.actions;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.itemis.maven.aether.ArtifactInstaller;
import com.itemis.maven.plugins.cdi.CDIMojoProcessingStep;
import com.itemis.maven.plugins.cdi.ExecutionContext;
import com.itemis.maven.plugins.cdi.annotations.ProcessingStep;
import com.itemis.maven.plugins.cdi.annotations.RollbackOnError;
import com.itemis.maven.plugins.cdi.logging.Logger;
import com.itemis.maven.plugins.unleash.ReleaseMetadata;
import com.itemis.maven.plugins.unleash.util.functions.AetherToMavenArtifact;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.installation.InstallationException;

@ProcessingStep(id="installArtifacts", description="Installs the release artifacts into the local repository.", requiresOnline=false)
public class InstallArtifacts
implements CDIMojoProcessingStep {
    @Inject
    private Logger log;
    @Inject
    @Named(value="reactorProjects")
    private List<MavenProject> reactorProjects;
    @Inject
    @Named(value="local")
    private ArtifactRepository LocalRepository;
    @Inject
    private ArtifactInstaller installer;
    @Inject
    private ReleaseMetadata metadata;
    private Collection<Artifact> installedArtifacts;

    public void execute(ExecutionContext context) throws MojoExecutionException, MojoFailureException {
        this.log.info((CharSequence)"Installing the release artifacts into the local repository.");
        try {
            this.installedArtifacts = this.installer.installArtifacts(this.metadata.getReleaseArtifacts());
            if (!this.installedArtifacts.isEmpty()) {
                this.log.debug((CharSequence)"\tInstalled the following release artifacts into local repository:");
                for (Artifact a : this.installedArtifacts) {
                    this.log.debug((CharSequence)("\t\t" + a));
                }
            }
        }
        catch (InstallationException e) {
            throw new MojoFailureException("Unable to install artifacts into local repository.", (Throwable)e);
        }
    }

    @RollbackOnError
    public void rollback() {
        this.log.info((CharSequence)"Rolling back local artifact installation due to a processing exception.");
        Collection artifacts = Collections2.transform(this.installedArtifacts, (Function)AetherToMavenArtifact.INSTANCE);
        for (org.apache.maven.artifact.Artifact artifact : artifacts) {
            File localArtifact = new File(this.LocalRepository.getBasedir(), this.LocalRepository.pathOf(artifact));
            File localArtifactDirectory = localArtifact.getParentFile();
            try {
                this.log.debug((CharSequence)("\tDeleting locally installed artifact (parent directory): " + artifact));
                FileUtils.deleteDirectory((File)localArtifactDirectory);
            }
            catch (IOException e) {
                this.log.error((CharSequence)("Error rolling back artifact installation. Could not delete locally installed artifact: " + artifact), (Throwable)e);
            }
        }
    }
}

