/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.steps.actions;

import com.google.common.base.Optional;
import com.itemis.maven.plugins.cdi.CDIMojoProcessingStep;
import com.itemis.maven.plugins.cdi.ExecutionContext;
import com.itemis.maven.plugins.cdi.annotations.ProcessingStep;
import com.itemis.maven.plugins.cdi.logging.Logger;
import com.itemis.maven.plugins.unleash.util.scm.MavenScmUtil;
import com.itemis.maven.plugins.unleash.util.scm.ScmProviderRegistry;
import jakarta.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

@ProcessingStep(id="logScmProviderName", description="Log SCM provider name for unleash plugin.", requiresOnline=false)
public class LogScmProviderName
implements CDIMojoProcessingStep {
    @Inject
    private Logger log;
    @Inject
    private ScmProviderRegistry scmProviderRegistry;
    @Inject
    private MavenProject project;

    public void execute(ExecutionContext context) throws MojoExecutionException, MojoFailureException {
        Optional<String> providerName = MavenScmUtil.calcProviderName(this.project);
        if (!providerName.isPresent()) {
            this.log.error((CharSequence)"Could not determine SCM provider name from your POM configuration! Please check the SCM section of your POM and provide connections in the correct format (see also: https://maven.apache.org/scm/scm-url-format.html).");
        } else {
            this.log.info((CharSequence)("Resolved required SCM provider implementation to '" + (String)providerName.get() + "'"));
            this.scmProviderRegistry.getProvider();
        }
    }
}

