/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.steps.checks;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.itemis.maven.aether.ArtifactCoordinates;
import com.itemis.maven.plugins.cdi.CDIMojoProcessingStep;
import com.itemis.maven.plugins.cdi.ExecutionContext;
import com.itemis.maven.plugins.cdi.annotations.ProcessingStep;
import com.itemis.maven.plugins.cdi.logging.Logger;
import com.itemis.maven.plugins.unleash.util.PomPropertyResolver;
import com.itemis.maven.plugins.unleash.util.ReleaseUtil;
import com.itemis.maven.plugins.unleash.util.functions.PluginToCoordinates;
import com.itemis.maven.plugins.unleash.util.functions.ProjectToCoordinates;
import com.itemis.maven.plugins.unleash.util.functions.ProjectToString;
import com.itemis.maven.plugins.unleash.util.predicates.IsSnapshotPlugin;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;

@ProcessingStep(id="checkPlugins", description="Checks that the projects do not use SNAPSHOT plugins to avoid unreproducible release aritfacts.", requiresOnline=false)
public class CheckPluginVersions
implements CDIMojoProcessingStep {
    @Inject
    private Logger log;
    @Inject
    @Named(value="reactorProjects")
    private List<MavenProject> reactorProjects;
    @Inject
    private PluginDescriptor pluginDescriptor;
    @Inject
    @Named(value="profiles")
    private List<String> profiles;
    @Inject
    @Named(value="releaseArgs")
    private Properties releaseArgs;
    @Inject
    private Settings settings;

    public void execute(ExecutionContext context) throws MojoExecutionException, MojoFailureException {
        this.log.info((CharSequence)"Checking that none of the reactor projects contains SNAPSHOT plugins.");
        HashMap propertyResolvers = Maps.newHashMapWithExpectedSize((int)this.reactorProjects.size());
        HashMultimap snapshotsByProject = HashMultimap.create();
        for (MavenProject project : this.reactorProjects) {
            this.log.debug((CharSequence)("\tChecking plugins of reactor project '" + ProjectToString.INSTANCE.apply(project) + "':"));
            PomPropertyResolver propertyResolver = new PomPropertyResolver(project, this.settings, this.profiles, this.releaseArgs);
            propertyResolvers.put(project, propertyResolver);
            snapshotsByProject.putAll((Object)project, this.getSnapshotsFromManagement(project, propertyResolver));
            snapshotsByProject.putAll((Object)project, this.getSnapshots(project, propertyResolver));
            snapshotsByProject.putAll((Object)project, this.getSnapshotsFromAllProfiles(project, propertyResolver));
            this.removePluginForIntegrationTests((Multimap<MavenProject, ArtifactCoordinates>)snapshotsByProject);
            this.removeReactorProjectsOwnSnapshotPlugins((Multimap<MavenProject, ArtifactCoordinates>)snapshotsByProject);
        }
        this.failIfSnapshotsAreReferenced((Multimap<MavenProject, ArtifactCoordinates>)snapshotsByProject, propertyResolvers);
    }

    private void failIfSnapshotsAreReferenced(Multimap<MavenProject, ArtifactCoordinates> snapshotsByProject, Map<MavenProject, PomPropertyResolver> propertyResolvers) throws MojoFailureException {
        if (!snapshotsByProject.values().isEmpty()) {
            this.log.error((CharSequence)"\tThere are references to SNAPSHOT plugins! The following list contains all SNAPSHOT plugins grouped by module:");
            for (MavenProject project : snapshotsByProject.keySet()) {
                PomPropertyResolver propertyResolver = propertyResolvers.get(project);
                Collection snapshots = snapshotsByProject.get((Object)project);
                if (snapshots.isEmpty()) continue;
                this.log.error((CharSequence)("\t\t[PROJECT] " + ProjectToString.INSTANCE.apply(project)));
                for (ArtifactCoordinates plugin : snapshots) {
                    String resolvedVersion = propertyResolver.expandPropertyReferences(plugin.getVersion());
                    String coordinates = plugin.toString();
                    if (!Objects.equal((Object)resolvedVersion, (Object)plugin.getVersion())) {
                        coordinates = coordinates + " (resolves to " + resolvedVersion + ")";
                    }
                    this.log.error((CharSequence)("\t\t\t[PLUGIN] " + coordinates));
                }
            }
            throw new MojoFailureException("The project cannot be released due to one or more SNAPSHOT plugins!");
        }
    }

    private Set<ArtifactCoordinates> getSnapshotsFromManagement(MavenProject project, PomPropertyResolver propertyResolver) {
        PluginManagement pluginManagement;
        this.log.debug((CharSequence)"\t\tChecking managed plugins");
        Build build = project.getBuild();
        if (build != null && (pluginManagement = build.getPluginManagement()) != null) {
            Collection snapshots = Collections2.filter((Collection)pluginManagement.getPlugins(), (Predicate)new IsSnapshotPlugin(propertyResolver));
            return Sets.newHashSet((Iterable)Collections2.transform((Collection)snapshots, (Function)PluginToCoordinates.INSTANCE));
        }
        return Collections.emptySet();
    }

    private Set<ArtifactCoordinates> getSnapshots(MavenProject project, PomPropertyResolver propertyResolver) {
        this.log.debug((CharSequence)"\t\tChecking direct plugin references");
        Build build = project.getBuild();
        if (build != null) {
            Collection snapshots = Collections2.filter((Collection)build.getPlugins(), (Predicate)new IsSnapshotPlugin(propertyResolver));
            return Sets.newHashSet((Iterable)Collections2.transform((Collection)snapshots, (Function)PluginToCoordinates.INSTANCE));
        }
        return Collections.emptySet();
    }

    private Set<ArtifactCoordinates> getSnapshotsFromAllProfiles(MavenProject project, PomPropertyResolver propertyResolver) {
        HashSet snapshots = Sets.newHashSet();
        List profiles = project.getModel().getProfiles();
        if (profiles != null) {
            for (Profile profile : profiles) {
                snapshots.addAll(this.getSnapshotsFromManagement(profile, propertyResolver));
                snapshots.addAll(this.getSnapshots(profile, propertyResolver));
            }
        }
        return snapshots;
    }

    private Set<ArtifactCoordinates> getSnapshotsFromManagement(Profile profile, PomPropertyResolver propertyResolver) {
        PluginManagement pluginManagement;
        this.log.debug((CharSequence)("\t\tChecking managed plugins of profile '" + profile.getId() + "'"));
        BuildBase build = profile.getBuild();
        if (build != null && (pluginManagement = build.getPluginManagement()) != null) {
            Collection snapshots = Collections2.filter((Collection)pluginManagement.getPlugins(), (Predicate)new IsSnapshotPlugin(propertyResolver));
            return Sets.newHashSet((Iterable)Collections2.transform((Collection)snapshots, (Function)PluginToCoordinates.INSTANCE));
        }
        return Collections.emptySet();
    }

    private Set<ArtifactCoordinates> getSnapshots(Profile profile, PomPropertyResolver propertyResolver) {
        this.log.debug((CharSequence)("\t\tChecking direct plugin references of profile '" + profile.getId() + "'"));
        BuildBase build = profile.getBuild();
        if (build != null) {
            Collection snapshots = Collections2.filter((Collection)build.getPlugins(), (Predicate)new IsSnapshotPlugin(propertyResolver));
            return Sets.newHashSet((Iterable)Collections2.transform((Collection)snapshots, (Function)PluginToCoordinates.INSTANCE));
        }
        return Collections.emptySet();
    }

    private void removePluginForIntegrationTests(Multimap<MavenProject, ArtifactCoordinates> snapshotsByProject) {
        if (ReleaseUtil.isIntegrationtest()) {
            Iterator i = snapshotsByProject.entries().iterator();
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                if (!Objects.equal(entry.getValue(), (Object)PluginToCoordinates.INSTANCE.apply(this.pluginDescriptor.getPlugin()))) continue;
                i.remove();
            }
        }
    }

    private void removeReactorProjectsOwnSnapshotPlugins(Multimap<MavenProject, ArtifactCoordinates> snapshotsByProject) {
        Collection projectCoordinates = Collections2.transform(this.reactorProjects, (Function)ProjectToCoordinates.INSTANCE);
        Iterator i = snapshotsByProject.entries().iterator();
        block0: while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            for (ArtifactCoordinates projectCoordinate : projectCoordinates) {
                if (!projectCoordinate.equalsGAV(entry.getValue())) continue;
                this.log.info((CharSequence)("\tThis reactor project's SNAPSHOT plugin is scheduled for release: " + entry.getValue()));
                i.remove();
                continue block0;
            }
        }
    }
}

