/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.util.scm;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.itemis.maven.plugins.unleash.scm.ScmProvider;
import com.itemis.maven.plugins.unleash.scm.ScmProviderInitialization;
import com.itemis.maven.plugins.unleash.scm.annotations.ScmProviderTypeLiteral;
import com.itemis.maven.plugins.unleash.scm.impl.DefaultScmProviderInitialization;
import com.itemis.maven.plugins.unleash.util.logging.JavaLoggerAdapter;
import com.itemis.maven.plugins.unleash.util.scm.MavenScmUtil;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.project.MavenProject;

@Singleton
public class ScmProviderRegistry {
    @Inject
    private com.itemis.maven.plugins.cdi.logging.Logger log;
    @Inject
    @Any
    private Instance<ScmProvider> providers;
    @Inject
    private MavenProject project;
    @Inject
    @Named(value="scmUsername")
    private String scmUsername;
    @Inject
    @Named(value="scmPassword")
    private String scmPassword;
    @Inject
    @Named(value="scmSshPassphrase")
    private String scmSshPassphrase;
    @Inject
    @Named(value="scmUsernameEnvVar")
    private String scmUsernameEnvVar;
    @Inject
    @Named(value="scmPasswordEnvVar")
    private String scmPasswordEnvVar;
    @Inject
    @Named(value="scmSshPassphraseEnvVar")
    private String scmSshPassphraseEnvVar;
    @Inject
    @Named(value="scmSshPrivateKeyEnvVar")
    private String scmSshPrivateKeyEnvVar;
    private String scmProviderName;
    private ScmProvider provider;

    private ScmProviderRegistry() {
    }

    @PostConstruct
    private void init() {
        Optional<String> providerName = MavenScmUtil.calcProviderName(this.project);
        if (!providerName.isPresent()) {
            this.log.error((CharSequence)"Could not determine SCM provider name from your POM configuration! Please check the SCM section of your POM and provide connections in the correct format (see also: https://maven.apache.org/scm/scm-url-format.html).");
        } else {
            this.log.debug((CharSequence)("Resolved required SCM provider implementation to '" + (String)providerName.get() + "'"));
        }
        this.scmProviderName = (String)providerName.orNull();
    }

    public ScmProvider getProvider() throws IllegalStateException {
        if (this.provider == null) {
            try {
                this.provider = (ScmProvider)this.providers.select(new Annotation[]{new ScmProviderTypeLiteral(this.scmProviderName)}).get();
                this.checkProviderAPI();
                DefaultScmProviderInitialization initialization = new DefaultScmProviderInitialization(this.project.getBasedir());
                initialization.setLogger((Logger)new JavaLoggerAdapter(this.provider.getClass().getName(), this.log));
                initialization.setUsername(this.getScmUsername());
                initialization.setUsername(this.getScmUsername());
                initialization.setPassword(this.getScmPassword());
                initialization.setSshPrivateKey(this.getPrivateKey());
                initialization.setSshPrivateKeyPassphrase(this.getScmSshPassphrase());
                this.provider.initialize((ScmProviderInitialization)initialization);
            }
            catch (IllegalStateException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new IllegalStateException("No SCM provider found for SCM with name " + this.scmProviderName + ". Maybe you need to add an appropriate provider implementation as a dependency to the plugin.", t);
            }
        }
        return this.provider;
    }

    private void checkProviderAPI() throws IllegalStateException {
        boolean isIncompatible = false;
        Throwable cause = null;
        for (Method apiMethod : ScmProvider.class.getDeclaredMethods()) {
            try {
                Method implMethod = this.provider.getClass().getDeclaredMethod(apiMethod.getName(), apiMethod.getParameterTypes());
                if (Objects.equal(implMethod.getReturnType(), apiMethod.getReturnType())) continue;
                isIncompatible = true;
            }
            catch (Throwable e) {
                isIncompatible = true;
                cause = e;
            }
            break;
        }
        if (isIncompatible) {
            this.log.error((CharSequence)("The SCM provider API and the configured implementation for SCMs with identifier '" + this.scmProviderName + "' are incompatible. Please check the compatibility notes of the chosen provider implementation."));
            if (cause != null) {
                throw new IllegalStateException("Invalid SCM provider API version of provider implementation '" + this.scmProviderName + "'.", cause);
            }
            throw new IllegalStateException("Invalid SCM provider API version of provider implementation '" + this.scmProviderName + "'.");
        }
    }

    private String getScmUsername() {
        String username = Strings.emptyToNull((String)this.scmUsername);
        if (username == null && StringUtils.isNotBlank((CharSequence)this.scmUsernameEnvVar)) {
            username = Strings.emptyToNull((String)System.getenv(this.scmUsernameEnvVar));
        }
        return username;
    }

    private String getScmPassword() {
        String password = Strings.emptyToNull((String)this.scmPassword);
        if (password == null && StringUtils.isNotBlank((CharSequence)this.scmPasswordEnvVar)) {
            password = Strings.emptyToNull((String)System.getenv(this.scmPasswordEnvVar));
        }
        return password;
    }

    private String getScmSshPassphrase() {
        String passphrase = Strings.emptyToNull((String)this.scmSshPassphrase);
        if (passphrase == null && StringUtils.isNotBlank((CharSequence)this.scmSshPassphraseEnvVar)) {
            passphrase = Strings.emptyToNull((String)System.getenv(this.scmSshPassphraseEnvVar));
        }
        return passphrase;
    }

    private String getPrivateKey() {
        if (StringUtils.isNotBlank((CharSequence)this.scmSshPrivateKeyEnvVar)) {
            return Strings.emptyToNull((String)System.getenv(this.scmSshPrivateKeyEnvVar));
        }
        return null;
    }

    @PreDestroy
    private void disposeProvider() {
        if (this.provider != null) {
            this.provider.close();
            this.provider = null;
        }
    }
}

