/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.aether;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.itemis.maven.aether.ArtifactCacheLoader;
import com.itemis.maven.aether.ArtifactCoordinates;
import com.itemis.maven.plugins.cdi.logging.Logger;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.io.File;
import java.util.List;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;

@Singleton
public class ArtifactResolver {
    private RepositorySystemSession repoSession;
    private LoadingCache<ArtifactCoordinates, Optional<ArtifactResult>> cache;

    @Inject
    public ArtifactResolver(RepositorySystem repoSystem, RepositorySystemSession repoSession, @Named(value="projectRepositories") List<RemoteRepository> remoteProjectRepos, Logger log) {
        this.repoSession = repoSession;
        this.cache = CacheBuilder.newBuilder().build((CacheLoader)new ArtifactCacheLoader(repoSystem, repoSession, remoteProjectRepos, log));
    }

    public Optional<ResolutionResult> resolve(ArtifactCoordinates coordinates, boolean remoteOnly) {
        ResolutionResult r = null;
        try {
            Optional result = (Optional)this.cache.get((Object)new ArtifactCoordinates(coordinates.getGroupId(), coordinates.getArtifactId(), coordinates.getVersion(), (String)MoreObjects.firstNonNull((Object)coordinates.getType(), (Object)"jar"), coordinates.getClassifier()));
            if (result.isPresent()) {
                r = this.getResolutionResult((ArtifactResult)result.get(), remoteOnly);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage(), t);
        }
        return Optional.fromNullable(r);
    }

    private ResolutionResult getResolutionResult(ArtifactResult artifactResult, boolean remoteOnly) {
        ResolutionResult result = null;
        Artifact artifact = artifactResult.getArtifact();
        if (artifact != null) {
            String repositoryId = artifactResult.getRepository().getId();
            if (remoteOnly) {
                if (!Objects.equal((Object)repositoryId, (Object)this.repoSession.getLocalRepository().getId())) {
                    result = new ResolutionResult(artifact.getFile(), repositoryId);
                }
            } else {
                result = new ResolutionResult(artifact.getFile(), repositoryId);
            }
        }
        return result;
    }

    public static class ResolutionResult {
        private File file;
        private String repositoryId;

        public ResolutionResult(File f, String repositoryId) {
            this.file = f;
            this.repositoryId = repositoryId;
        }

        public File getFile() {
            return this.file;
        }

        public String getRepositoryId() {
            return this.repositoryId;
        }
    }
}

