/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.itemis.maven.aether.ArtifactCoordinates;
import com.itemis.maven.plugins.cdi.AbstractCDIMojo;
import com.itemis.maven.plugins.cdi.annotations.MojoInject;
import com.itemis.maven.plugins.cdi.annotations.MojoProduces;
import com.itemis.maven.plugins.unleash.util.PomPropertyResolver;
import com.itemis.maven.plugins.unleash.util.ReleaseUtil;
import com.itemis.maven.plugins.unleash.util.Repository;
import com.itemis.maven.plugins.unleash.util.ScmMessagePrefixUtil;
import com.itemis.maven.plugins.unleash.util.VersionUpgradeStrategy;
import jakarta.inject.Named;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.Deployer;
import org.eclipse.aether.impl.Installer;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;

public class AbstractUnleashMojo
extends AbstractCDIMojo {
    public static final String PROPERTY_REPO_BASE = "multiDeploy.repo";
    @MojoProduces
    @Component
    private PlexusContainer plexus;
    @MojoProduces
    @Component
    private RepositorySystem repoSystem;
    @MojoProduces
    @Component
    private RemoteRepositoryManager remoteRepositoryManager;
    @MojoProduces
    @Component
    private Deployer deployer;
    @MojoProduces
    @Component
    private Installer installer;
    @MojoProduces
    @Component
    private Prompter prompter;
    @MojoProduces
    @Parameter(property="session", readonly=true)
    private MavenSession session;
    @MojoProduces
    @Parameter(property="mojoExecution", readonly=true)
    private MojoExecution mojoExecution;
    @MojoProduces
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession repoSession;
    @MojoProduces
    @Named(value="pluginRepositories")
    @Parameter(defaultValue="${project.remotePluginRepositories}", readonly=true, required=true)
    private List<RemoteRepository> remotePluginRepos;
    @MojoProduces
    @Named(value="projectRepositories")
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> remoteProjectRepos;
    @MojoProduces
    @Named(value="local")
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository LocalRepository;
    @MojoProduces
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @MojoProduces
    @Named(value="reactorProjects")
    @Parameter(defaultValue="${reactorProjects}", readonly=true, required=true)
    private List<MavenProject> reactorProjects;
    @MojoProduces
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    @MojoProduces
    @Named(value="allowLocalReleaseArtifacts")
    @Parameter(defaultValue="true", property="unleash.allowLocalReleaseArtifacts", required=true)
    private boolean allowLocalReleaseArtifacts;
    @MojoProduces
    @Named(value="commitBeforeTagging")
    @Parameter(defaultValue="false", property="unleash.commitBeforeTagging", required=true)
    private boolean commitBeforeTagging;
    @MojoProduces
    @Named(value="maven.home")
    @Parameter(defaultValue="${maven.home}", property="unleash.mavenHome", required=true)
    private String mavenHome;
    @MojoProduces
    @Named(value="tagNamePattern")
    @Parameter(defaultValue="@{project.version}", property="unleash.tagNamePattern", required=true)
    private String tagNamePattern;
    @MojoProduces
    @Named(value="updateReactorDependencyVersion")
    @Parameter(defaultValue="true", property="unleash.updateReactorDependencyVersion", required=true)
    private boolean updateReactorDependencyVersion;
    @MojoProduces
    @Named(value="developmentVersion")
    @Parameter(property="unleash.developmentVersion", required=false)
    private String developmentVersion;
    @MojoProduces
    @Named(value="releaseGoals")
    @Parameter(defaultValue="clean,verify", property="unleash.goals", required=false)
    private List<String> goals;
    @MojoProduces
    @Named(value="profiles")
    @Parameter(property="unleash.profiles", required=false)
    private List<String> profiles;
    @Parameter(defaultValue="", property="unleash.releaseArgs", required=false)
    private List<String> releaseArgs;
    @MojoProduces
    @Named(value="releaseVersion")
    @Parameter(property="unleash.releaseVersion", required=false)
    private String releaseVersion;
    @Parameter(name="scmMessagePrefix", defaultValue="[unleash-maven-plugin]", property="unleash.scmMessagePrefix", required=false)
    private String scmMessagePrefixConfigured;
    @MojoProduces
    @Named(value="scmPassword")
    @Parameter(property="unleash.scmPassword", required=false)
    private String scmPassword;
    @MojoProduces
    @Named(value="scmUsername")
    @Parameter(property="unleash.scmUsername", required=false)
    private String scmUsername;
    @MojoProduces
    @Named(value="scmSshPassphrase")
    @Parameter(property="unleash.scmSshPassphrase", required=false)
    private String scmSshPassphrase;
    @MojoProduces
    @Named(value="scmPasswordEnvVar")
    @Parameter(property="unleash.scmPasswordEnvVar", required=false)
    private String scmPasswordEnvVar;
    @MojoProduces
    @Named(value="scmUsernameEnvVar")
    @Parameter(property="unleash.scmUsernameEnvVar", required=false)
    private String scmUsernameEnvVar;
    @MojoProduces
    @Named(value="scmSshPassphraseEnvVar")
    @Parameter(property="unleash.scmSshPassphraseEnvVar", required=false)
    private String scmSshPassphraseEnvVar;
    @MojoProduces
    @Named(value="scmSshPrivateKeyEnvVar")
    @Parameter(property="unleash.scmSshPrivateKeyEnvVar", required=false)
    private String scmSshPrivateKeyEnvVar;
    @Parameter(property="unleash.releaseEnvironment", required=false)
    private String releaseEnvironmentVariables;
    @MojoProduces
    @Parameter(property="unleash.versionUpgradeStrategy", required=true, defaultValue="DEFAULT")
    private VersionUpgradeStrategy versionUpgradeStrategy;
    @MojoProduces
    @Named(value="preserveFixedModuleVersions")
    @Parameter(property="unleash.preserveFixedModuleVersions", required=false, defaultValue="false")
    private boolean preserveFixedModuleVersions;
    @Parameter
    private Set<Repository> additionalDeploymentRepositories;
    @MojoProduces
    @Named(value="isDeployDryRun")
    @Parameter(defaultValue="false", property="unleash.isDeployDryRun", required=true)
    private boolean isDeployDryRun;
    @MojoProduces
    @Named(value="altDeploymentRepository")
    @Parameter(property="altDeploymentRepository", required=false)
    private String altDeploymentRepository;
    @MojoProduces
    @Named(value="altSnapshotDeploymentRepository")
    @Parameter(property="altSnapshotDeploymentRepository", required=false)
    private String altSnapshotDeploymentRepository;
    @MojoProduces
    @Named(value="altReleaseDeploymentRepository")
    @Parameter(property="altReleaseDeploymentRepository", required=false)
    private String altReleaseDeploymentRepository;
    @MojoProduces
    @Parameter(property="unleash.artifactSpyPluginGroupId", required=true, defaultValue="io.github.mavenplugins")
    private String artifactSpyPluginGroupId;
    @MojoProduces
    @Parameter(property="unleash.artifactSpyPluginArtifactId", required=true, defaultValue="artifact-spy-plugin")
    private String artifactSpyPluginArtifactId;
    @MojoProduces
    @Parameter(property="unleash.artifactSpyPluginVersion", required=true, defaultValue="1.1.0")
    private String artifactSpyPluginVersion;

    @MojoProduces
    @Named(value="artifactSpyPlugin")
    private ArtifactCoordinates getArtifactSpyPluginCoordinates() {
        return new ArtifactCoordinates(this.artifactSpyPluginGroupId, this.artifactSpyPluginArtifactId, this.artifactSpyPluginVersion, "maven-plugin");
    }

    @MojoProduces
    private PluginParameterExpressionEvaluator getExpressionEvaluator() {
        return new PluginParameterExpressionEvaluator(this.session, this.mojoExecution);
    }

    @MojoProduces
    private PluginDescriptor getPluginDescriptor() {
        return (PluginDescriptor)this.getPluginContext().get("pluginDescriptor");
    }

    public void setScmMessagePrefix(String scmMessagePrefixConfigured) {
        this.scmMessagePrefixConfigured = scmMessagePrefixConfigured;
    }

    @MojoProduces
    @Named(value="scmMessagePrefix")
    private String getScmMessagePrefix() {
        String scmMessagePrefix = ScmMessagePrefixUtil.unescapeScmMessagePrefix(this.scmMessagePrefixConfigured);
        if (!scmMessagePrefix.matches(".*\\s+$")) {
            scmMessagePrefix = scmMessagePrefix + " ";
        }
        return ReleaseUtil.getScmPatternResolved(Strings.nullToEmpty((String)scmMessagePrefix), this.project, this.getExpressionEvaluator());
    }

    @MojoProduces
    @Named(value="unleashOutputFolder")
    private File getUnleashOutputFolder() {
        File folder = new File(this.project.getBuild().getDirectory(), "unleash");
        folder.mkdirs();
        return folder;
    }

    @MojoProduces
    @Named(value="releaseArgs")
    @MojoInject
    private Properties getReleaseArgs() {
        Properties args = new Properties();
        Splitter splitter = Splitter.on((char)'=');
        if (this.releaseArgs != null) {
            for (String arg : this.releaseArgs) {
                List split = splitter.splitToList((CharSequence)arg);
                if (split.size() == 2) {
                    args.put(split.get(0), split.get(1));
                    continue;
                }
                args.put(split.get(0), "true");
                this.getLog().info((CharSequence)("Detected release argument without an explicit value. Assuming '" + (String)split.get(0) + "' to be a boolean property and setting it to true."));
            }
        }
        args.put("isUnleashBuild", "true");
        return args;
    }

    @MojoProduces
    @Named(value="releaseEnvVariables")
    private Map<String, String> getReleaseEnvironmentVariables() {
        HashMap env = Maps.newHashMap();
        if (!Strings.isNullOrEmpty((String)this.releaseEnvironmentVariables)) {
            Iterable split = Splitter.on((char)',').split((CharSequence)this.releaseEnvironmentVariables);
            for (String token : split) {
                String date = Strings.emptyToNull((String)token.trim());
                if (date == null) continue;
                List dataSplit = Splitter.on((String)"=>").splitToList((CharSequence)date);
                String key = (String)dataSplit.get(0);
                String value = (String)dataSplit.get(1);
                env.put(key, value);
            }
        }
        return env;
    }

    @MojoProduces
    @Named(value="additionalDeployemntRepositories")
    private Set<RemoteRepository> getAdditionalDeploymentRepositories() {
        HashSet<Repository> repos = new HashSet<Repository>();
        if (this.additionalDeploymentRepositories != null) {
            repos.addAll(this.additionalDeploymentRepositories);
        }
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (key.toString().startsWith(PROPERTY_REPO_BASE)) {
                Repository.parseFromProperty(value.toString()).ifPresent(repo -> repos.add((Repository)repo));
            }
        }));
        return repos.stream().map(repo -> repo.buildRemoteRepository(this.session, new PomPropertyResolver(this.project, this.settings, this.profiles, this.getReleaseArgs()))).collect(Collectors.toSet());
    }
}

