/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractVersionMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${reactorProjects}", readonly=true, required=true)
    private List<MavenProject> reactorProjects;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(property="output")
    protected File output;
    @Parameter(property="forceStdout", defaultValue="false")
    private boolean forceStdout;
    @Parameter(property="allowRecursiveReactorOutput", defaultValue="false")
    private boolean allowRecursiveReactorOutput;
    @Parameter(property="currentVersion", defaultValue="${project.version}")
    private String currentVersion;

    protected static void writeFile(File output, StringBuilder content) throws IOException {
        AbstractVersionMojo.writeFile(output, content.toString());
    }

    protected static void writeFile(File output, String content) throws IOException {
        if (output == null) {
            return;
        }
        output.getParentFile().mkdirs();
        try (BufferedWriter out = Files.newBufferedWriter(output.toPath(), new OpenOption[0]);){
            out.write(content);
        }
    }

    protected void handleResultOutput(String result, int projectIndex) throws MojoExecutionException, MojoFailureException {
        if (this.output != null) {
            StringBuilder sb = new StringBuilder();
            if (projectIndex > 0) {
                sb.append(System.lineSeparator());
            }
            sb.append(result);
            try {
                AbstractVersionMojo.writeFile(this.output, sb);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot write result to output: " + this.output, (Exception)e);
            }
            this.getLog().info((CharSequence)("Result written to: " + this.output));
        } else if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)(System.lineSeparator() + result));
        } else if (this.forceStdout) {
            if (projectIndex > 0) {
                System.out.print(System.lineSeparator());
            }
            System.out.print(result);
            System.out.flush();
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        int projectIndex = this.reactorProjects.indexOf(this.project);
        if (projectIndex == 0 || this.allowRecursiveReactorOutput) {
            String result = this.calculateVersion(this.currentVersion);
            this.handleResultOutput(result, projectIndex);
        }
    }

    protected abstract String calculateVersion(String var1);
}

