/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.steps.actions;

import com.google.common.base.Optional;
import com.itemis.maven.aether.ArtifactCoordinates;
import com.itemis.maven.plugins.cdi.CDIMojoProcessingStep;
import com.itemis.maven.plugins.cdi.ExecutionContext;
import com.itemis.maven.plugins.cdi.annotations.ProcessingStep;
import com.itemis.maven.plugins.cdi.logging.Logger;
import com.itemis.maven.plugins.unleash.ReleaseMetadata;
import com.itemis.maven.plugins.unleash.ReleasePhase;
import com.itemis.maven.plugins.unleash.util.MavenVersionUtil;
import com.itemis.maven.plugins.unleash.util.ReleaseUtil;
import com.itemis.maven.plugins.unleash.util.VersionUpgradeStrategy;
import com.itemis.maven.plugins.unleash.util.functions.ProjectToString;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.components.interactivity.Prompter;

@ProcessingStep(id="prepareVersions", description="Calculates all required versions for each module of the project such as release and development version (applies several strategies for version calculation such as user prompting).", requiresOnline=false)
public class CalculateVersions
implements CDIMojoProcessingStep {
    @Inject
    private Logger log;
    @Inject
    @Named(value="reactorProjects")
    private List<MavenProject> reactorProjects;
    @Inject
    private ReleaseMetadata metadata;
    @Inject
    @Named(value="releaseVersion")
    private String defaultReleaseVersion;
    @Inject
    @Named(value="developmentVersion")
    private String defaultDevelopmentVersion;
    @Inject
    private Settings settings;
    @Inject
    private Prompter prompter;
    @Inject
    private VersionUpgradeStrategy upgradeStrategy;
    @Inject
    @Named(value="preserveFixedModuleVersions")
    private boolean preserveFixedModuleVersions;

    public void execute(ExecutionContext context) throws MojoExecutionException, MojoFailureException {
        this.log.info((CharSequence)"Calculating required versions for all modules.");
        for (MavenProject project : this.reactorProjects) {
            this.log.info((CharSequence)("\tVersions of module " + ProjectToString.EXCLUDE_VERSION.apply(project) + ":"));
            ArtifactCoordinates preReleaseCoordinates = this.metadata.getArtifactCoordinatesByPhase(project.getGroupId(), project.getArtifactId()).get((Object)ReleasePhase.PRE_RELEASE);
            this.log.info((CharSequence)("\t\t" + (Object)((Object)ReleasePhase.PRE_RELEASE) + " = " + preReleaseCoordinates.getVersion()));
            Optional prompterToUse = this.settings.isInteractiveMode() ? Optional.of((Object)this.prompter) : Optional.absent();
            String releaseVersion = this.calculateReleaseVersion(project.getVersion(), (Optional<Prompter>)prompterToUse);
            ArtifactCoordinates releaseCoordinates = new ArtifactCoordinates(project.getGroupId(), project.getArtifactId(), releaseVersion, "pom");
            this.metadata.addArtifactCoordinates(releaseCoordinates, ReleasePhase.RELEASE);
            this.log.info((CharSequence)("\t\t" + (Object)((Object)ReleasePhase.RELEASE) + " = " + releaseVersion));
            String nextDevVersion = this.calculateDevelopmentVersion(project.getVersion(), (Optional<Prompter>)prompterToUse);
            ArtifactCoordinates postReleaseCoordinates = new ArtifactCoordinates(project.getGroupId(), project.getArtifactId(), nextDevVersion, "pom");
            this.metadata.addArtifactCoordinates(postReleaseCoordinates, ReleasePhase.POST_RELEASE);
            this.log.info((CharSequence)("\t\t" + (Object)((Object)ReleasePhase.POST_RELEASE) + " = " + nextDevVersion));
        }
    }

    private String calculateReleaseVersion(String version, Optional<Prompter> prompter) {
        if (!MavenVersionUtil.isSnapshot((String)version) && this.preserveFixedModuleVersions) {
            return version;
        }
        return ReleaseUtil.getReleaseVersion(version, (Optional<String>)Optional.fromNullable((Object)this.defaultReleaseVersion), prompter);
    }

    private String calculateDevelopmentVersion(String version, Optional<Prompter> prompter) {
        if (!MavenVersionUtil.isSnapshot((String)version) && this.preserveFixedModuleVersions) {
            return version;
        }
        return ReleaseUtil.getNextDevelopmentVersion(version, (Optional<String>)Optional.fromNullable((Object)this.defaultDevelopmentVersion), prompter, this.upgradeStrategy);
    }
}

