/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.steps.checks;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.itemis.maven.aether.ArtifactCoordinates;
import com.itemis.maven.aether.ArtifactResolver;
import com.itemis.maven.plugins.cdi.CDIMojoProcessingStep;
import com.itemis.maven.plugins.cdi.ExecutionContext;
import com.itemis.maven.plugins.cdi.annotations.ProcessingStep;
import com.itemis.maven.plugins.cdi.logging.Logger;
import com.itemis.maven.plugins.unleash.ReleaseMetadata;
import com.itemis.maven.plugins.unleash.ReleasePhase;
import com.itemis.maven.plugins.unleash.util.functions.ProjectToString;
import com.itemis.maven.plugins.unleash.util.predicates.IsSnapshotProject;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

@ProcessingStep(id="checkAether", description="Checks the aether for already released artifacts. The goal is to ensure that the artifacts produced by this release build can be deployed safely to the aether.", requiresOnline=true)
public class CheckAether
implements CDIMojoProcessingStep {
    @Inject
    private Logger log;
    @Inject
    private ReleaseMetadata metadata;
    @Inject
    @Named(value="reactorProjects")
    private List<MavenProject> reactorProjects;
    @Inject
    private ArtifactResolver artifactResolver;
    @Inject
    @Named(value="allowLocalReleaseArtifacts")
    private boolean allowLocalReleaseArtifacts;

    public void execute(ExecutionContext context) throws MojoExecutionException, MojoFailureException {
        this.log.info((CharSequence)"Checking aether for already released artifacts of modules that are scheduled for release.");
        this.log.debug((CharSequence)"\t=> If any of the modules had already been released with the corresponding release version, the release build will fail fast at this point.");
        Collection snapshotProjects = Collections2.filter(this.reactorProjects, (Predicate)IsSnapshotProject.INSTANCE);
        HashMap remotelyReleasedProjects = Maps.newHashMap();
        ArrayList locallyReleasedProjects = Lists.newArrayList();
        for (MavenProject p : snapshotProjects) {
            this.log.debug((CharSequence)("\tChecking module '" + ProjectToString.INSTANCE.apply(p) + "'"));
            ArtifactCoordinates calculatedCoordinates = this.metadata.getArtifactCoordinatesByPhase(p.getGroupId(), p.getArtifactId()).get((Object)ReleasePhase.RELEASE);
            Optional<ArtifactResolver.ResolutionResult> remoteResolvedArtifact = this.resolve(calculatedCoordinates.getGroupId(), calculatedCoordinates.getArtifactId(), calculatedCoordinates.getVersion(), true);
            if (remoteResolvedArtifact.isPresent()) {
                remotelyReleasedProjects.put(calculatedCoordinates, ((ArtifactResolver.ResolutionResult)remoteResolvedArtifact.get()).getRepositoryId());
                continue;
            }
            if (!this.resolve(calculatedCoordinates.getGroupId(), calculatedCoordinates.getArtifactId(), calculatedCoordinates.getVersion(), false).isPresent()) continue;
            locallyReleasedProjects.add(calculatedCoordinates);
        }
        this.handleRemoteReleases(remotelyReleasedProjects);
        this.handleLocalReleases(locallyReleasedProjects);
    }

    private void handleRemoteReleases(Map<ArtifactCoordinates, String> remotelyReleasedProjects) throws MojoFailureException {
        if (!remotelyReleasedProjects.isEmpty()) {
            this.log.error((CharSequence)"\tThe following artifacts are already present in one of your remote repositories:");
            for (ArtifactCoordinates c : remotelyReleasedProjects.keySet()) {
                this.log.error((CharSequence)("\t\t" + c + " (RepositoryId: " + remotelyReleasedProjects.get(c) + ")"));
            }
            throw new MojoFailureException("Some of the reactor projects have already been released. Please check your remote repositories!");
        }
    }

    private void handleLocalReleases(List<ArtifactCoordinates> locallyReleasedProjects) throws MojoFailureException {
        if (!locallyReleasedProjects.isEmpty()) {
            if (this.allowLocalReleaseArtifacts) {
                this.log.warn((CharSequence)"\tLocal release artifacts are allowed but just for information, the following artifacts are already present in your local repository:");
                for (ArtifactCoordinates c : locallyReleasedProjects) {
                    this.log.warn((CharSequence)("\t\t" + c));
                }
            } else {
                this.log.error((CharSequence)"\tThe following artifacts are already present in your local repository:");
                for (ArtifactCoordinates c : locallyReleasedProjects) {
                    this.log.error((CharSequence)("\t\t" + c));
                }
                throw new MojoFailureException("Some of the reactor projects have already been released locally. Please check your local repository!");
            }
        }
    }

    private Optional<ArtifactResolver.ResolutionResult> resolve(String groupId, String artifactId, String version, boolean remoteOnly) {
        ArtifactCoordinates coordinates = new ArtifactCoordinates(groupId, artifactId, version, "pom");
        Optional<ArtifactResolver.ResolutionResult> result = this.artifactResolver.resolve(coordinates, remoteOnly);
        return result;
    }
}

