/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.steps.checks;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.itemis.maven.aether.ArtifactCoordinates;
import com.itemis.maven.plugins.cdi.CDIMojoProcessingStep;
import com.itemis.maven.plugins.cdi.ExecutionContext;
import com.itemis.maven.plugins.cdi.annotations.ProcessingStep;
import com.itemis.maven.plugins.cdi.logging.Logger;
import com.itemis.maven.plugins.unleash.util.PomPropertyResolver;
import com.itemis.maven.plugins.unleash.util.functions.DependencyToCoordinates;
import com.itemis.maven.plugins.unleash.util.functions.ProjectToCoordinates;
import com.itemis.maven.plugins.unleash.util.functions.ProjectToString;
import com.itemis.maven.plugins.unleash.util.predicates.IsSnapshotDependency;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;

@ProcessingStep(id="checkDependencies", description="Checks that the project modules do not reference SNAPSHOT dependencies to avoid unreproducible release aritfacts.", requiresOnline=false)
public class CheckDependencyVersions
implements CDIMojoProcessingStep {
    @Inject
    private Logger log;
    @Inject
    @Named(value="reactorProjects")
    private List<MavenProject> reactorProjects;
    @Inject
    @Named(value="profiles")
    private List<String> profiles;
    @Inject
    @Named(value="releaseArgs")
    private Properties releaseArgs;
    @Inject
    private Settings settings;

    public void execute(ExecutionContext context) throws MojoExecutionException, MojoFailureException {
        this.log.info((CharSequence)"Checking that none of the reactor projects contains SNAPSHOT dependencies.");
        HashMap propertyResolvers = Maps.newHashMapWithExpectedSize((int)this.reactorProjects.size());
        HashMultimap snapshotsByProject = HashMultimap.create();
        for (MavenProject project : this.reactorProjects) {
            this.log.debug((CharSequence)("\tChecking dependencies of reactor project '" + ProjectToString.INSTANCE.apply(project) + "':"));
            PomPropertyResolver propertyResolver = new PomPropertyResolver(project, this.settings, this.profiles, this.releaseArgs);
            propertyResolvers.put(project, propertyResolver);
            snapshotsByProject.putAll((Object)project, this.getSnapshotsFromManagement(project, propertyResolver));
            snapshotsByProject.putAll((Object)project, this.getSnapshots(project, propertyResolver));
            snapshotsByProject.putAll((Object)project, this.getSnapshotsFromAllProfiles(project, propertyResolver));
        }
        this.failIfSnapshotsAreReferenced((Multimap<MavenProject, ArtifactCoordinates>)snapshotsByProject, propertyResolvers);
    }

    private void failIfSnapshotsAreReferenced(Multimap<MavenProject, ArtifactCoordinates> snapshotsByProject, Map<MavenProject, PomPropertyResolver> propertyResolvers) throws MojoFailureException {
        if (!snapshotsByProject.values().isEmpty()) {
            this.log.error((CharSequence)"\tThere are SNAPSHOT dependency references! The following list contains all SNAPSHOT dependencies grouped by module:");
            for (MavenProject p : snapshotsByProject.keySet()) {
                PomPropertyResolver propertyResolver = propertyResolvers.get(p);
                Collection snapshots = snapshotsByProject.get((Object)p);
                if (snapshots.isEmpty()) continue;
                this.log.error((CharSequence)("\t\t[PROJECT] " + ProjectToString.INSTANCE.apply(p)));
                for (ArtifactCoordinates dependency : snapshots) {
                    String resolvedVersion = propertyResolver.expandPropertyReferences(dependency.getVersion());
                    String coordinates = dependency.toString();
                    if (!Objects.equal((Object)resolvedVersion, (Object)dependency.getVersion())) {
                        coordinates = coordinates + " (resolves to " + resolvedVersion + ")";
                    }
                    this.log.error((CharSequence)("\t\t\t[DEPENDENCY] " + coordinates));
                }
            }
            throw new MojoFailureException("The project cannot be released due to one or more SNAPSHOT dependencies!");
        }
    }

    private Set<ArtifactCoordinates> getSnapshotsFromManagement(MavenProject project, PomPropertyResolver propertyResolver) {
        this.log.debug((CharSequence)"\t\tChecking managed dependencies");
        DependencyManagement dependencyManagement = project.getDependencyManagement();
        if (dependencyManagement != null) {
            Collection snapshots = Collections2.filter((Collection)dependencyManagement.getDependencies(), (Predicate)new IsSnapshotDependency(propertyResolver));
            HashSet snapshotDependencies = Sets.newHashSet((Iterable)Collections2.transform((Collection)snapshots, (Function)DependencyToCoordinates.INSTANCE));
            this.filterMultiModuleDependencies(snapshotDependencies);
            return snapshotDependencies;
        }
        return Collections.emptySet();
    }

    private Set<ArtifactCoordinates> getSnapshots(MavenProject project, PomPropertyResolver propertyResolver) {
        this.log.debug((CharSequence)"\t\tChecking direct dependencies");
        Collection snapshots = Collections2.filter((Collection)project.getDependencies(), (Predicate)new IsSnapshotDependency(propertyResolver));
        HashSet snapshotDependencies = Sets.newHashSet((Iterable)Collections2.transform((Collection)snapshots, (Function)DependencyToCoordinates.INSTANCE));
        this.filterMultiModuleDependencies(snapshotDependencies);
        return snapshotDependencies;
    }

    private Set<ArtifactCoordinates> getSnapshotsFromAllProfiles(MavenProject project, PomPropertyResolver propertyResolver) {
        HashSet snapshots = Sets.newHashSet();
        List profiles = project.getModel().getProfiles();
        if (profiles != null) {
            for (Profile profile : profiles) {
                snapshots.addAll(this.getSnapshotsFromManagement(profile, propertyResolver));
                snapshots.addAll(this.getSnapshots(profile, propertyResolver));
            }
        }
        this.filterMultiModuleDependencies(snapshots);
        return snapshots;
    }

    private Set<ArtifactCoordinates> getSnapshotsFromManagement(Profile profile, PomPropertyResolver propertyResolver) {
        this.log.debug((CharSequence)("\t\tChecking managed dependencies of profile '" + profile.getId() + "'"));
        DependencyManagement dependencyManagement = profile.getDependencyManagement();
        if (dependencyManagement != null) {
            Collection snapshots = Collections2.filter((Collection)dependencyManagement.getDependencies(), (Predicate)new IsSnapshotDependency(propertyResolver));
            return Sets.newHashSet((Iterable)Collections2.transform((Collection)snapshots, (Function)DependencyToCoordinates.INSTANCE));
        }
        return Collections.emptySet();
    }

    private Set<ArtifactCoordinates> getSnapshots(Profile profile, PomPropertyResolver propertyResolver) {
        this.log.debug((CharSequence)("\t\tChecking direct dependencies of profile '" + profile.getId() + "'"));
        Collection snapshots = Collections2.filter((Collection)profile.getDependencies(), (Predicate)new IsSnapshotDependency(propertyResolver));
        return Sets.newHashSet((Iterable)Collections2.transform((Collection)snapshots, (Function)DependencyToCoordinates.INSTANCE));
    }

    private void filterMultiModuleDependencies(Set<ArtifactCoordinates> snapshotDependencies) {
        Collection projectCoordinates = Collections2.transform(this.reactorProjects, (Function)ProjectToCoordinates.INSTANCE);
        Iterator<ArtifactCoordinates> i = snapshotDependencies.iterator();
        block0: while (i.hasNext()) {
            ArtifactCoordinates dep = i.next();
            for (ArtifactCoordinates projectCoordinate : projectCoordinates) {
                if (!projectCoordinate.equalsGAV(dep)) continue;
                i.remove();
                continue block0;
            }
        }
    }
}

