/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.steps.checks;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.itemis.maven.aether.ArtifactCoordinates;
import com.itemis.maven.plugins.cdi.CDIMojoProcessingStep;
import com.itemis.maven.plugins.cdi.ExecutionContext;
import com.itemis.maven.plugins.cdi.annotations.ProcessingStep;
import com.itemis.maven.plugins.cdi.logging.Logger;
import com.itemis.maven.plugins.unleash.ReleaseMetadata;
import com.itemis.maven.plugins.unleash.ReleasePhase;
import com.itemis.maven.plugins.unleash.util.functions.ProjectToString;
import com.itemis.maven.plugins.unleash.util.predicates.IsSnapshotProject;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

@ProcessingStep(id="checkParentVersions", description="Checks that none of the project modules references a SNAPSHOT parent that is not scheduled for release.", requiresOnline=false)
public class CheckParentVersions
implements CDIMojoProcessingStep {
    @Inject
    private Logger log;
    @Inject
    private ReleaseMetadata metadata;
    @Inject
    @Named(value="reactorProjects")
    private List<MavenProject> reactorProjects;

    public void execute(ExecutionContext context) throws MojoExecutionException, MojoFailureException {
        this.log.info((CharSequence)"Checking that the project modules do not reference SNAPSHOT parents that are not scheduled for release.");
        HashMap snapshotParentReferences = Maps.newHashMap();
        for (MavenProject p : this.reactorProjects) {
            MavenProject parent = p.getParent();
            if (parent == null || !IsSnapshotProject.INSTANCE.apply(parent)) continue;
            Map<ReleasePhase, ArtifactCoordinates> coordinatesByPhase = this.metadata.getArtifactCoordinatesByPhase(parent.getGroupId(), parent.getArtifactId());
            ArtifactCoordinates coordinates = coordinatesByPhase.get((Object)ReleasePhase.PRE_RELEASE);
            if (coordinates != null && Objects.equal((Object)parent.getVersion(), (Object)coordinates.getVersion())) {
                this.log.debug((CharSequence)("\tModule '" + ProjectToString.INSTANCE.apply(p) + "' references SNAPSHOT parent '" + ProjectToString.INSTANCE.apply(parent) + "' which is also scheduled for release."));
                continue;
            }
            snapshotParentReferences.put(ProjectToString.INSTANCE.apply(p), ProjectToString.INSTANCE.apply(parent));
        }
        if (!snapshotParentReferences.isEmpty()) {
            this.log.error((CharSequence)"\tThe following modules have references to SNAPSHOT parents that are not scheduled for release:");
            for (String projectCoordinates : snapshotParentReferences.keySet()) {
                this.log.error((CharSequence)("\t\t" + projectCoordinates + " => " + (String)snapshotParentReferences.get(projectCoordinates)));
            }
            throw new MojoFailureException("There are modules that reference SNAPSHOT parents which are not scheduled for release!");
        }
    }
}

