/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.steps.checks;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.itemis.maven.plugins.cdi.CDIMojoProcessingStep;
import com.itemis.maven.plugins.cdi.ExecutionContext;
import com.itemis.maven.plugins.cdi.annotations.ProcessingStep;
import com.itemis.maven.plugins.cdi.logging.Logger;
import com.itemis.maven.plugins.unleash.util.functions.ProjectToString;
import com.itemis.maven.plugins.unleash.util.predicates.IsSnapshotProject;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

@ProcessingStep(id="checkProjectVersions", description="Checks that at least one of the projects as a SNAPSHOT version assigned and is thus releasable.", requiresOnline=false)
public class CheckProjectVersions
implements CDIMojoProcessingStep {
    @Inject
    private Logger log;
    @Inject
    @Named(value="reactorProjects")
    private List<MavenProject> reactorProjects;

    public void execute(ExecutionContext context) throws MojoExecutionException, MojoFailureException {
        boolean hasSnapshotProjects;
        this.log.debug((CharSequence)"Checking that at least one of the reactor projects has a SNAPSHOT version assigned.");
        boolean bl = hasSnapshotProjects = !Collections2.filter(this.reactorProjects, (Predicate)IsSnapshotProject.INSTANCE).isEmpty();
        if (!hasSnapshotProjects) {
            String errorTitle = "There are no snapshot projects that could be released!";
            this.log.error((CharSequence)errorTitle);
            this.log.error((CharSequence)"\tThe reactor project list must contain at least one project with a SNAPSHOT version assigned.");
            for (MavenProject p : this.reactorProjects) {
                this.log.error((CharSequence)("\t" + ProjectToString.INSTANCE.apply(p)));
            }
            throw new IllegalStateException(errorTitle);
        }
    }
}

