/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.aether;

import com.itemis.maven.plugins.cdi.logging.Logger;
import com.itemis.maven.plugins.unleash.ReleaseMetadata;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.Set;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeployResult;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.impl.Deployer;
import org.eclipse.aether.repository.RemoteRepository;

@Singleton
public class ArtifactDeployer {
    @Inject
    private Logger log;
    @Inject
    private Deployer deployer;
    @Inject
    private RepositorySystemSession repoSession;
    @Inject
    private ReleaseMetadata metadata;
    @Inject
    @Named(value="additionalDeployemntRepositories")
    private Set<RemoteRepository> additonalDeploymentRepositories;
    @Inject
    @Named(value="isDeployDryRun")
    private boolean isDeployDryRun;

    public Collection<Artifact> deployArtifacts(Collection<Artifact> artifacts) throws DeploymentException {
        Collection<Artifact> result = this.deploy(artifacts, this.metadata.getDeploymentRepository());
        for (RemoteRepository repo : this.additonalDeploymentRepositories) {
            this.deploy(artifacts, repo);
        }
        return result;
    }

    private Collection<Artifact> deploy(Collection<Artifact> artifacts, RemoteRepository repo) throws DeploymentException {
        Collection ret;
        DeployRequest request = new DeployRequest();
        request.setArtifacts(artifacts);
        request.setRepository(repo);
        if (this.isDeployDryRun) {
            request.getArtifacts().forEach(artifact -> this.log.warn((CharSequence)("Deploy DRYRUN: SKIP deploying " + artifact + " to " + request.getRepository().getUrl())));
            ret = request.getArtifacts();
        } else {
            DeployResult result = this.deployer.deploy(this.repoSession, request);
            ret = result.getArtifacts();
        }
        return ret;
    }
}

