/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.steps.actions;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.itemis.maven.aether.ArtifactCoordinates;
import com.itemis.maven.plugins.cdi.CDIMojoProcessingStep;
import com.itemis.maven.plugins.cdi.ExecutionContext;
import com.itemis.maven.plugins.cdi.annotations.ProcessingStep;
import com.itemis.maven.plugins.cdi.annotations.RollbackOnError;
import com.itemis.maven.plugins.cdi.logging.Logger;
import com.itemis.maven.plugins.unleash.util.PomUtil;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@ProcessingStep(id="addSpyPlugin", description="Adds the artifact-spy-plugin to the build configuration. This plugin detects all artifacts that are produced during the release build for later installation and deployment.", requiresOnline=false)
public class AddSpyPlugin
implements CDIMojoProcessingStep {
    @Inject
    private Logger log;
    @Inject
    @Named(value="reactorProjects")
    private List<MavenProject> reactorProjects;
    @Inject
    @Named(value="artifactSpyPlugin")
    private ArtifactCoordinates artifactSpyPluginCoordinates;
    private Map<MavenProject, Document> cachedPOMs;

    public void execute(ExecutionContext context) throws MojoExecutionException, MojoFailureException {
        this.log.info((CharSequence)("Adding " + this.artifactSpyPluginCoordinates + " to the build configuration - required to detect all artifacts that are produced by the release build for installation and deployment."));
        this.cachedPOMs = Maps.newHashMap();
        for (MavenProject p : this.reactorProjects) {
            Optional<Document> parsedPOM = PomUtil.parsePOM(p);
            if (!parsedPOM.isPresent()) continue;
            this.cachedPOMs.put(p, (Document)parsedPOM.get());
        }
        try {
            for (MavenProject p : this.reactorProjects) {
                Optional<Document> document = PomUtil.parsePOM(p);
                if (!document.isPresent()) continue;
                Node plugin = PomUtil.createPlugin((Document)document.get(), this.artifactSpyPluginCoordinates.getGroupId(), this.artifactSpyPluginCoordinates.getArtifactId(), this.artifactSpyPluginCoordinates.getVersion());
                PomUtil.createPluginExecution(plugin, "spy", (Optional<String>)Optional.of((Object)"verify"), "spy");
                PomUtil.writePOM((Document)document.get(), p);
            }
        }
        catch (Throwable t) {
            throw new MojoFailureException("Could not add the artifact-spy-plugin to the POM. This plugin is required to determine the artifacts that are produced by the build for later installation and deployment.", t);
        }
    }

    @RollbackOnError
    public void rollback() throws MojoExecutionException {
        this.log.info((CharSequence)"Rollback of artifact-spy-plugin addition to the build configuration.");
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        for (Map.Entry<MavenProject, Document> entry : this.cachedPOMs.entrySet()) {
            try {
                PomUtil.writePOM(entry.getValue(), entry.getKey());
            }
            catch (Throwable t) {
                errors.add(t);
            }
        }
        if (!errors.isEmpty()) {
            throw new MojoExecutionException("Could not remove artifact-spy-plugin from the POM.", (Throwable)errors.get(0));
        }
    }
}

