/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.steps.actions;

import com.google.common.base.Objects;
import com.google.common.io.Files;
import com.itemis.maven.aether.ArtifactCoordinates;
import com.itemis.maven.plugins.cdi.CDIMojoProcessingStep;
import com.itemis.maven.plugins.cdi.ExecutionContext;
import com.itemis.maven.plugins.cdi.annotations.ProcessingStep;
import com.itemis.maven.plugins.cdi.logging.Logger;
import com.itemis.maven.plugins.unleash.ReleaseMetadata;
import com.itemis.maven.plugins.unleash.ReleasePhase;
import com.itemis.maven.plugins.unleash.scm.utils.FileToRelativePath;
import com.itemis.maven.plugins.unleash.util.functions.ProjectToString;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

@ProcessingStep(id="detectReleaseArtifacts", description="Detects all release artifacts based on the output of the artifact-spy-plugin and stores the data in the release metadata for later installation and deployment.", requiresOnline=false)
public class DetectReleaseArtifacts
implements CDIMojoProcessingStep {
    @Inject
    private Logger log;
    @Inject
    @Named(value="reactorProjects")
    private List<MavenProject> reactorProjects;
    @Inject
    private ReleaseMetadata metadata;
    @Inject
    @Named(value="unleashOutputFolder")
    private File unleashOutputFolder;
    @Inject
    @Named(value="allReactorsBasedir")
    private File allReactorsBasedir;

    public void execute(ExecutionContext context) throws MojoExecutionException, MojoFailureException {
        this.log.info((CharSequence)"Detecting all release artifacts that have been produced during the release build for later installation and deployment.");
        for (MavenProject p : this.reactorProjects) {
            if (this.wasFixedVersion(p)) continue;
            try {
                Properties props = this.loadModuleArtifacts(p);
                for (String name : props.stringPropertyNames()) {
                    DefaultArtifact a = new DefaultArtifact(name);
                    String relativePath = props.getProperty(name);
                    File artifactFile = new File(p.getBasedir(), relativePath);
                    if (Objects.equal((Object)p.getFile().getName(), (Object)relativePath)) {
                        relativePath = new FileToRelativePath(this.allReactorsBasedir).apply(p.getFile());
                        artifactFile = new File(this.unleashOutputFolder, relativePath);
                        artifactFile.getParentFile().mkdirs();
                        if (p.getFile().exists()) {
                            Files.copy((File)p.getFile(), (File)artifactFile);
                        }
                    }
                    a = a.setFile(artifactFile);
                    this.metadata.addReleaseArtifact((Artifact)a);
                    this.log.debug((CharSequence)("\t\tThe following artifact will be installed and deployed later: " + a));
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not determine project release artifacts. Project: " + ProjectToString.INSTANCE.apply(p), (Exception)e);
            }
        }
    }

    private Properties loadModuleArtifacts(MavenProject p) throws MojoExecutionException, MojoFailureException {
        Properties props = new Properties();
        File artifactsSpyProperties = new File(p.getBuild().getDirectory(), "artifact-spy/artifacts.properties");
        if (artifactsSpyProperties.exists() && artifactsSpyProperties.isFile()) {
            try {
                this.log.debug((CharSequence)("\tLoading artifact-spy output of module '" + ProjectToString.INSTANCE.apply(p) + "' from " + artifactsSpyProperties.getAbsolutePath()));
                props.load(new FileInputStream(artifactsSpyProperties));
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to load artifact-spy output file from " + artifactsSpyProperties.getAbsolutePath(), e);
            }
        } else {
            throw new MojoFailureException("Could not find artifact-spy output file containing all project artifacts. File was expected at " + artifactsSpyProperties.getAbsolutePath());
        }
        return props;
    }

    private boolean wasFixedVersion(MavenProject p) {
        String releaseVersion;
        Map<ReleasePhase, ArtifactCoordinates> coordinatesByPhase = this.metadata.getArtifactCoordinatesByPhase(p.getGroupId(), p.getArtifactId());
        String preReleaseVersion = coordinatesByPhase.get((Object)ReleasePhase.PRE_RELEASE).getVersion();
        return Objects.equal((Object)preReleaseVersion, (Object)(releaseVersion = coordinatesByPhase.get((Object)ReleasePhase.RELEASE).getVersion()));
    }
}

