/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.steps.actions;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.itemis.maven.plugins.cdi.ExecutionContext;
import com.itemis.maven.plugins.cdi.annotations.ProcessingStep;
import com.itemis.maven.plugins.cdi.annotations.RollbackOnError;
import com.itemis.maven.plugins.unleash.ReleasePhase;
import com.itemis.maven.plugins.unleash.steps.actions.AbstractVersionsStep;
import com.itemis.maven.plugins.unleash.util.PomUtil;
import com.itemis.maven.plugins.unleash.util.functions.ProjectToCoordinates;
import com.itemis.maven.plugins.unleash.util.functions.ProjectToString;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Document;

@ProcessingStep(id="setReleaseVersions", description="Updates the POMs of all project modules with their release versions calculated previously.", requiresOnline=false)
public class SetReleaseVersions
extends AbstractVersionsStep {
    public void execute(ExecutionContext context) throws MojoExecutionException, MojoFailureException {
        this.log.info((CharSequence)"Updating project modules with release versions");
        this.cachedPOMs = Maps.newHashMap();
        for (MavenProject project : this.reactorProjects) {
            Optional<Document> parsedPOM = PomUtil.parsePOM(project);
            if (!parsedPOM.isPresent()) continue;
            this.cachedPOMs.put(ProjectToCoordinates.EMPTY_VERSION.apply(project), parsedPOM.get());
            try {
                Document document = this.loadAndProcess(project);
                PomUtil.writePOM(document, project);
            }
            catch (Throwable t) {
                throw new MojoFailureException("Could not update versions for release.", t);
            }
        }
    }

    @Override
    protected ReleasePhase previousReleasePhase() {
        return ReleasePhase.PRE_RELEASE;
    }

    @Override
    protected ReleasePhase currentReleasePhase() {
        return ReleasePhase.RELEASE;
    }

    @RollbackOnError
    public void rollback() throws MojoExecutionException {
        this.log.info((CharSequence)"Rollback of release version updating for all project modules");
        for (MavenProject project : this.reactorProjects) {
            this.log.debug((CharSequence)("\tRolling back modifications on POM of module '" + ProjectToString.INSTANCE.apply(project) + "'"));
            Document document = (Document)this.cachedPOMs.get(ProjectToCoordinates.EMPTY_VERSION.apply(project));
            if (document == null) continue;
            try {
                PomUtil.writePOM(document, project);
            }
            catch (Throwable t) {
                throw new MojoExecutionException("Could not revert the setting of release versions after a failed release build.", t);
            }
        }
    }
}

