/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.steps.actions.tycho;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.itemis.maven.aether.ArtifactCoordinates;
import com.itemis.maven.plugins.cdi.CDIMojoProcessingStep;
import com.itemis.maven.plugins.cdi.ExecutionContext;
import com.itemis.maven.plugins.cdi.annotations.RollbackOnError;
import com.itemis.maven.plugins.cdi.logging.Logger;
import com.itemis.maven.plugins.unleash.ReleaseMetadata;
import com.itemis.maven.plugins.unleash.ReleasePhase;
import com.itemis.maven.plugins.unleash.util.PomUtil;
import com.itemis.maven.plugins.unleash.util.functions.ProjectToCoordinates;
import com.itemis.maven.plugins.unleash.util.functions.ProjectToString;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.eclipse.tycho.versions.engine.ProjectMetadataReader;
import org.eclipse.tycho.versions.engine.VersionsEngine;
import org.eclipse.tycho.versions.pom.PomFile;
import org.w3c.dom.Document;

public abstract class AbstractTychoVersionsStep
implements CDIMojoProcessingStep {
    @Inject
    private Logger log;
    @Inject
    private ReleaseMetadata metadata;
    @Inject
    private MavenProject project;
    @Inject
    private PlexusContainer plexus;
    @Inject
    @Named(value="reactorProjects")
    private List<MavenProject> reactorProjects;
    @Inject
    @Named(value="allReactorsBasedir")
    private File allReactorsBasedir;
    private Map<ArtifactCoordinates, Document> cachedPOMs;
    private Map<ArtifactCoordinates, String> cachedModuleVersions;
    private ProjectMetadataReader metadataReader;

    public void execute(ExecutionContext context) throws MojoExecutionException, MojoFailureException {
        this.cachedPOMs = Maps.newHashMap();
        this.cachedModuleVersions = Maps.newHashMap();
        VersionsEngine versionsEngine = this.initializeVersionsEngine();
        try {
            for (MavenProject module : this.reactorProjects) {
                ArtifactCoordinates coordinates = ProjectToCoordinates.EMPTY_VERSION.apply(module);
                Optional<Document> parsedPOM = PomUtil.parsePOM(this.project);
                if (parsedPOM.isPresent()) {
                    this.cachedPOMs.put(coordinates, (Document)parsedPOM.get());
                }
                this.cachedModuleVersions.put(coordinates, module.getVersion());
                Map<ReleasePhase, ArtifactCoordinates> coordinatesByPhase = this.metadata.getArtifactCoordinatesByPhase(module.getGroupId(), module.getArtifactId());
                String version = coordinatesByPhase.get((Object)this.currentReleasePhase()).getVersion();
                versionsEngine.addVersionChange(module.getArtifactId(), version);
                if (module.getModel().getVersion() == null) continue;
                module.getModel().setVersion(version);
            }
            versionsEngine.apply();
            this.adaptProjectMetadataWithNewVersions();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error during tycho version upgrade.", (Exception)e);
        }
    }

    private void adaptProjectMetadataWithNewVersions() {
        this.metadataReader.getProjects().forEach(data -> {
            PomFile pom = (PomFile)data.getMetadata(PomFile.class);
            Map<ReleasePhase, ArtifactCoordinates> coordinatesByPhase = this.metadata.getArtifactCoordinatesByPhase(pom.getGroupId(), pom.getArtifactId());
            String version = coordinatesByPhase.get((Object)this.currentReleasePhase()).getVersion();
            pom.setVersion(version);
        });
    }

    protected abstract ReleasePhase currentReleasePhase();

    private <T> T lookup(Class<T> clazz) throws MojoFailureException {
        try {
            return (T)this.plexus.lookup(clazz);
        }
        catch (ComponentLookupException e) {
            throw new MojoFailureException("Could not lookup required component", (Throwable)e);
        }
    }

    @RollbackOnError
    public void rollback() throws MojoExecutionException, MojoFailureException {
        VersionsEngine versionsEngine = this.initializeVersionsEngine();
        try {
            for (MavenProject module : this.reactorProjects) {
                String version = this.cachedModuleVersions.get(ProjectToCoordinates.EMPTY_VERSION.apply(module));
                versionsEngine.addVersionChange(module.getArtifactId(), version);
            }
            versionsEngine.apply();
            for (MavenProject module : this.reactorProjects) {
                this.log.debug((CharSequence)("\tRolling back modifications on POM of module '" + ProjectToString.INSTANCE.apply(this.project) + "'"));
                ArtifactCoordinates coordinates = ProjectToCoordinates.EMPTY_VERSION.apply(module);
                Document document = this.cachedPOMs.get(coordinates);
                if (document != null) {
                    try {
                        PomUtil.writePOM(document, this.project);
                    }
                    catch (Throwable t) {
                        throw new MojoExecutionException("Could not revert the version update after a failed release build.", t);
                    }
                }
                String version = this.cachedModuleVersions.get(coordinates);
                if (module.getModel().getVersion() == null) continue;
                module.getModel().setVersion(version);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not revert the version update after a failed release build.", (Exception)e);
        }
    }

    private VersionsEngine initializeVersionsEngine() throws MojoExecutionException, MojoFailureException {
        if (this.metadataReader == null) {
            this.metadataReader = this.lookup(ProjectMetadataReader.class);
            try {
                this.metadataReader.addBasedir(this.allReactorsBasedir);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Tycho was unable to read the project structure!", (Exception)e);
            }
        }
        VersionsEngine versionsEngine = this.lookup(VersionsEngine.class);
        versionsEngine.setUpdateVersionRangeMatchingBounds(false);
        versionsEngine.setProjects(this.metadataReader.getProjects());
        return versionsEngine;
    }
}

