/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.steps.checks;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.itemis.maven.aether.ArtifactCoordinates;
import com.itemis.maven.plugins.cdi.CDIMojoProcessingStep;
import com.itemis.maven.plugins.cdi.ExecutionContext;
import com.itemis.maven.plugins.cdi.annotations.ProcessingStep;
import com.itemis.maven.plugins.cdi.logging.Logger;
import com.itemis.maven.plugins.unleash.util.PomPropertyResolver;
import com.itemis.maven.plugins.unleash.util.ReleaseUtil;
import com.itemis.maven.plugins.unleash.util.functions.DependencyToCoordinates;
import com.itemis.maven.plugins.unleash.util.functions.PluginToCoordinates;
import com.itemis.maven.plugins.unleash.util.functions.ProjectToCoordinates;
import com.itemis.maven.plugins.unleash.util.functions.ProjectToString;
import com.itemis.maven.plugins.unleash.util.predicates.IsSnapshotDependency;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;

@ProcessingStep(id="checkPluginDependencies", description="Checks that the plugins used by the projects do not reference SNAPSHOT dependencies to avoid unreproducible release aritfacts.", requiresOnline=false)
public class CheckPluginDependencyVersions
implements CDIMojoProcessingStep {
    @Inject
    private Logger log;
    @Inject
    @Named(value="reactorProjects")
    private List<MavenProject> reactorProjects;
    @Inject
    private PluginDescriptor pluginDescriptor;
    @Inject
    @Named(value="profiles")
    private List<String> profiles;
    @Inject
    @Named(value="releaseArgs")
    private Properties releaseArgs;
    @Inject
    private Settings settings;

    public void execute(ExecutionContext context) throws MojoExecutionException, MojoFailureException {
        this.log.info((CharSequence)"Checking that none of the reactor project's plugins contains SNAPSHOT dependencies.");
        HashMap propertyResolvers = Maps.newHashMapWithExpectedSize((int)this.reactorProjects.size());
        HashMap snapshotsByProjectAndPlugin = Maps.newHashMapWithExpectedSize((int)this.reactorProjects.size());
        boolean hasSnapshots = false;
        for (MavenProject project : this.reactorProjects) {
            this.log.debug((CharSequence)("\tChecking plugin dependencies of reactor project '" + ProjectToString.INSTANCE.apply(project) + "':"));
            PomPropertyResolver propertyResolver = new PomPropertyResolver(project, this.settings, this.profiles, this.releaseArgs);
            propertyResolvers.put(project, propertyResolver);
            HashMultimap snapshots = HashMultimap.create();
            snapshots.putAll(this.getSnapshotsFromManagement(project, propertyResolver));
            snapshots.putAll(this.getSnapshots(project, propertyResolver));
            snapshots.putAll(this.getSnapshotsFromAllProfiles(project, propertyResolver));
            this.removeReactorProjectsOwnSnapshotDependencies((Multimap<ArtifactCoordinates, ArtifactCoordinates>)snapshots);
            this.removePluginForIntegrationTests((Multimap<ArtifactCoordinates, ArtifactCoordinates>)snapshots);
            snapshotsByProjectAndPlugin.put(project, snapshots);
            if (snapshots.isEmpty()) continue;
            hasSnapshots = true;
        }
        this.failIfSnapshotsAreReferenced(hasSnapshots, snapshotsByProjectAndPlugin, propertyResolvers);
    }

    private void failIfSnapshotsAreReferenced(boolean hasSnapshots, Map<MavenProject, Multimap<ArtifactCoordinates, ArtifactCoordinates>> snapshotsByProjectAndPlugin, Map<MavenProject, PomPropertyResolver> propertyResolvers) throws MojoFailureException {
        if (hasSnapshots) {
            this.log.error((CharSequence)"\tThere are plugins with SNAPSHOT dependencies! The following list contains all SNAPSHOT dependencies grouped by plugin and module:");
            for (MavenProject p : snapshotsByProjectAndPlugin.keySet()) {
                PomPropertyResolver propertyResolver = propertyResolvers.get(p);
                Multimap<ArtifactCoordinates, ArtifactCoordinates> snapshots = snapshotsByProjectAndPlugin.get(p);
                if (snapshots.isEmpty()) continue;
                this.log.error((CharSequence)("\t\t[PROJECT] " + ProjectToString.INSTANCE.apply(p)));
                for (ArtifactCoordinates plugin : snapshots.keySet()) {
                    this.log.error((CharSequence)("\t\t\t[PLUGIN] " + plugin));
                    for (ArtifactCoordinates dependency : snapshots.get((Object)plugin)) {
                        String resolvedVersion = propertyResolver.expandPropertyReferences(dependency.getVersion());
                        String coordinates = dependency.toString();
                        if (!Objects.equal((Object)resolvedVersion, (Object)dependency.getVersion())) {
                            coordinates = coordinates + " (resolves to " + resolvedVersion + ")";
                        }
                        this.log.error((CharSequence)("\t\t\t\t[DEPENDENCY] " + coordinates));
                    }
                }
            }
            throw new MojoFailureException("The project cannot be released due to one or more SNAPSHOT plugin-dependencies!");
        }
    }

    private Multimap<ArtifactCoordinates, ArtifactCoordinates> getSnapshotsFromManagement(MavenProject project, PomPropertyResolver propertyResolver) {
        PluginManagement pluginManagement;
        this.log.debug((CharSequence)"\t\tChecking managed plugins");
        HashMultimap result = HashMultimap.create();
        Build build = project.getBuild();
        if (build != null && (pluginManagement = build.getPluginManagement()) != null) {
            for (Plugin plugin : pluginManagement.getPlugins()) {
                Collection snapshots = Collections2.filter((Collection)plugin.getDependencies(), (Predicate)new IsSnapshotDependency(propertyResolver));
                if (snapshots.isEmpty()) continue;
                result.putAll((Object)PluginToCoordinates.INSTANCE.apply(plugin), (Iterable)Collections2.transform((Collection)snapshots, (Function)DependencyToCoordinates.INSTANCE));
            }
        }
        return result;
    }

    private Multimap<ArtifactCoordinates, ArtifactCoordinates> getSnapshots(MavenProject project, PomPropertyResolver propertyResolver) {
        this.log.debug((CharSequence)"\t\tChecking direct plugin references");
        HashMultimap result = HashMultimap.create();
        Build build = project.getBuild();
        if (build != null) {
            for (Plugin plugin : build.getPlugins()) {
                Collection snapshots = Collections2.filter((Collection)plugin.getDependencies(), (Predicate)new IsSnapshotDependency(propertyResolver));
                if (snapshots.isEmpty()) continue;
                result.putAll((Object)PluginToCoordinates.INSTANCE.apply(plugin), (Iterable)Collections2.transform((Collection)snapshots, (Function)DependencyToCoordinates.INSTANCE));
            }
        }
        return result;
    }

    private Multimap<ArtifactCoordinates, ArtifactCoordinates> getSnapshotsFromAllProfiles(MavenProject project, PomPropertyResolver propertyResolver) {
        HashMultimap result = HashMultimap.create();
        List profiles = project.getModel().getProfiles();
        if (profiles != null) {
            for (Profile profile : profiles) {
                result.putAll(this.getSnapshotsFromManagement(profile, propertyResolver));
                result.putAll(this.getSnapshots(profile, propertyResolver));
            }
        }
        return result;
    }

    private Multimap<ArtifactCoordinates, ArtifactCoordinates> getSnapshotsFromManagement(Profile profile, PomPropertyResolver propertyResolver) {
        PluginManagement pluginManagement;
        this.log.debug((CharSequence)("\t\tChecking managed plugins of profile '" + profile.getId() + "'"));
        HashMultimap result = HashMultimap.create();
        BuildBase build = profile.getBuild();
        if (build != null && (pluginManagement = build.getPluginManagement()) != null) {
            for (Plugin plugin : pluginManagement.getPlugins()) {
                Collection snapshots = Collections2.filter((Collection)plugin.getDependencies(), (Predicate)new IsSnapshotDependency(propertyResolver));
                if (snapshots.isEmpty()) continue;
                result.putAll((Object)PluginToCoordinates.INSTANCE.apply(plugin), (Iterable)Collections2.transform((Collection)snapshots, (Function)DependencyToCoordinates.INSTANCE));
            }
        }
        return result;
    }

    private Multimap<ArtifactCoordinates, ArtifactCoordinates> getSnapshots(Profile profile, PomPropertyResolver propertyResolver) {
        this.log.debug((CharSequence)("\t\tChecking direct plugin references of profile '" + profile.getId() + "'"));
        HashMultimap result = HashMultimap.create();
        BuildBase build = profile.getBuild();
        if (build != null) {
            for (Plugin plugin : build.getPlugins()) {
                Collection snapshots = Collections2.filter((Collection)plugin.getDependencies(), (Predicate)new IsSnapshotDependency(propertyResolver));
                if (snapshots.isEmpty()) continue;
                result.putAll((Object)PluginToCoordinates.INSTANCE.apply(plugin), (Iterable)Collections2.transform((Collection)snapshots, (Function)DependencyToCoordinates.INSTANCE));
            }
        }
        return result;
    }

    private void removePluginForIntegrationTests(Multimap<ArtifactCoordinates, ArtifactCoordinates> snapshots) {
        if (ReleaseUtil.isIntegrationtest()) {
            Iterator i = snapshots.entries().iterator();
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                if (!Objects.equal(entry.getKey(), (Object)PluginToCoordinates.INSTANCE.apply(this.pluginDescriptor.getPlugin()))) continue;
                i.remove();
            }
        }
    }

    private void removeReactorProjectsOwnSnapshotDependencies(Multimap<ArtifactCoordinates, ArtifactCoordinates> snapshots) {
        Collection projectCoordinates = Collections2.transform(this.reactorProjects, (Function)ProjectToCoordinates.INSTANCE);
        Iterator i = snapshots.entries().iterator();
        block0: while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            for (ArtifactCoordinates projectCoordinate : projectCoordinates) {
                if (!projectCoordinate.equalsGAV(entry.getValue())) continue;
                this.log.info((CharSequence)("\tThis reactor project's plugin dependency SNAPSHOT artifact is scheduled for release: " + entry.getValue()));
                i.remove();
                continue block0;
            }
        }
    }
}

