/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.steps.checks;

import com.google.common.base.Objects;
import com.itemis.maven.plugins.cdi.CDIMojoProcessingStep;
import com.itemis.maven.plugins.cdi.ExecutionContext;
import com.itemis.maven.plugins.cdi.annotations.ProcessingStep;
import com.itemis.maven.plugins.cdi.logging.Logger;
import com.itemis.maven.plugins.unleash.ReleaseMetadata;
import com.itemis.maven.plugins.unleash.scm.ScmProvider;
import com.itemis.maven.plugins.unleash.util.scm.ScmProviderRegistry;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

@ProcessingStep(id="checkForScmChanges", description="Checks the remote SCM repository for changes that would require stopping the release. This will only be executed if a commit was requested before tagging the repository.", requiresOnline=true)
public class CheckScmChanges
implements CDIMojoProcessingStep {
    @Inject
    private Logger log;
    @Inject
    private ScmProviderRegistry scmProviderRegistry;
    @Inject
    private ReleaseMetadata metadata;
    @Inject
    @Named(value="commitBeforeTagging")
    private boolean commitBeforeTagging;

    public void execute(ExecutionContext context) throws MojoExecutionException, MojoFailureException {
        this.log.info((CharSequence)("Checking remote SCM repository for changes. Initial revision was " + this.metadata.getInitialScmRevision()));
        if (!this.commitBeforeTagging) {
            this.log.debug((CharSequence)"\tNo commit before tagging requested. Checking for SCM changes at this point unnessecary!");
            return;
        }
        ScmProvider provider = this.scmProviderRegistry.getProvider();
        String latestRemoteRevision = provider.getLatestRemoteRevision();
        if (!Objects.equal((Object)latestRemoteRevision, (Object)this.metadata.getInitialScmRevision())) {
            throw new MojoFailureException("The local working copy which has been built is out of sync with the remote repository. [Local revision: " + this.metadata.getInitialScmRevision() + "] [Latest remote revision: " + latestRemoteRevision + "]");
        }
    }
}

