/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.util;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.itemis.maven.plugins.unleash.util.MavenVersionUtil;
import com.itemis.maven.plugins.unleash.util.VersionUpgradeStrategy;
import java.io.File;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

public final class ReleaseUtil {
    public static String getReleaseVersion(String version, Optional<String> defaultReleaseVersion, Optional<Prompter> prompter) {
        if (defaultReleaseVersion.isPresent()) {
            return (String)defaultReleaseVersion.get();
        }
        String releaseVersion = MavenVersionUtil.calculateReleaseVersion((String)version);
        if (prompter.isPresent()) {
            try {
                releaseVersion = ((Prompter)prompter.get()).prompt("Please specify the release version", releaseVersion);
            }
            catch (PrompterException prompterException) {
                // empty catch block
            }
        }
        return releaseVersion;
    }

    public static String getNextDevelopmentVersion(String version, Optional<String> defaultDevelopmentVersion, Optional<Prompter> prompter, VersionUpgradeStrategy upgradeStrategy) {
        if (defaultDevelopmentVersion.isPresent()) {
            return (String)defaultDevelopmentVersion.get();
        }
        String devVersion = MavenVersionUtil.calculateNextSnapshotVersion((String)version, (VersionUpgradeStrategy)upgradeStrategy);
        if (prompter.isPresent()) {
            try {
                devVersion = ((Prompter)prompter.get()).prompt("Please specify the next development version", devVersion);
            }
            catch (PrompterException prompterException) {
                // empty catch block
            }
        }
        return devVersion;
    }

    public static String getScmPatternResolved(String pattern, MavenProject project, PluginParameterExpressionEvaluator evaluator) {
        Preconditions.checkArgument((pattern != null ? 1 : 0) != 0, (Object)"Need a tag name pattern to calculate the tag name.");
        Preconditions.checkArgument((evaluator != null ? 1 : 0) != 0, (Object)"Need an expression evaluator to calculate the tag name.");
        try {
            StringBuilder sb = new StringBuilder(pattern);
            int start = -1;
            while ((start = sb.indexOf("@{")) > -1) {
                String resolved;
                int end = sb.indexOf("}");
                String var = sb.substring(start + 2, end);
                if (Objects.equal((Object)"project.version", (Object)var)) {
                    resolved = MavenVersionUtil.calculateReleaseVersion((String)project.getVersion());
                } else {
                    String expression = "${" + var + "}";
                    resolved = evaluator.evaluate(expression).toString();
                }
                sb.replace(start, end + 1, resolved);
            }
            return sb.toString();
        }
        catch (ExpressionEvaluationException e) {
            throw new RuntimeException("Could not resolve expressions in pattern: " + pattern, e);
        }
    }

    @Deprecated
    public static String getTagName(String pattern, MavenProject project, PluginParameterExpressionEvaluator evaluator) {
        return ReleaseUtil.getScmPatternResolved(pattern, project, evaluator);
    }

    public static boolean isIntegrationtest() {
        return Boolean.valueOf(System.getenv("UNLEASH_IT")) != false || Boolean.valueOf(System.getProperty("unleash.it")) != false;
    }

    public static File getMavenHome(Optional<String> userDefined) {
        String path = null;
        if (ReleaseUtil.isValidMavenHome((String)userDefined.orNull())) {
            path = (String)userDefined.orNull();
        } else {
            String sysProp = System.getProperty("maven.home");
            if (ReleaseUtil.isValidMavenHome(sysProp)) {
                path = sysProp;
            } else {
                String envVar = System.getenv("M2_HOME");
                if (ReleaseUtil.isValidMavenHome(envVar)) {
                    path = envVar;
                }
            }
        }
        if (path != null) {
            return new File(path);
        }
        return null;
    }

    private static boolean isValidMavenHome(String path) {
        if (path != null) {
            File homeFolder = new File(path);
            return homeFolder.exists() && homeFolder.isDirectory() && new File(homeFolder, "bin/mvn").exists();
        }
        return false;
    }
}

