/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.scm.results;

import com.google.common.base.Objects;
import com.google.common.base.Optional;

public class DiffObject {
    private ChangeType changeType = ChangeType.UNKNOWN;
    private String rawChangeType;
    private String oldPath;
    private String newPath;
    private String textualDiff;

    private DiffObject() {
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public String getOldPath() {
        return this.oldPath;
    }

    public String getNewPath() {
        return this.newPath;
    }

    public Optional<String> getTextualDiff() {
        return Optional.fromNullable((Object)this.textualDiff);
    }

    public Optional<String> getRawChangeType() {
        return Optional.fromNullable((Object)this.rawChangeType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.changeType, this.oldPath, this.newPath, this.textualDiff});
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        DiffObject otherDiff = (DiffObject)other;
        if (Objects.equal((Object)((Object)otherDiff.changeType), (Object)((Object)this.changeType)) && Objects.equal((Object)otherDiff.oldPath, (Object)this.oldPath) && Objects.equal((Object)otherDiff.newPath, (Object)this.newPath)) {
            return Objects.equal((Object)otherDiff.textualDiff, (Object)this.textualDiff);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.changeType.toString()).append(": ");
        switch (this.changeType) {
            case ADDED: {
                sb.append(this.newPath);
                break;
            }
            case COPIED: {
                sb.append(this.oldPath).append(" => ").append(this.newPath);
                break;
            }
            case DELETED: {
                sb.append(this.oldPath);
                break;
            }
            case MODIFIED: {
                sb.append(this.newPath);
                break;
            }
            case MOVED: {
                sb.append(this.oldPath).append(" => ").append(this.newPath);
                break;
            }
            case UNKNOWN: {
                if (this.rawChangeType != null) {
                    sb.insert(sb.length() - 2, "(" + this.rawChangeType + ")");
                }
                sb.append(this.oldPath).append(", ").append(this.newPath);
            }
        }
        return sb.toString();
    }

    public static enum ChangeType {
        ADDED,
        COPIED,
        DELETED,
        MODIFIED,
        MOVED,
        UNKNOWN;

    }

    public static class Builder {
        private DiffObject diff = new DiffObject();

        public Builder addition(String path) {
            this.diff.changeType = ChangeType.ADDED;
            this.diff.oldPath = null;
            this.diff.newPath = path;
            return this;
        }

        public Builder deletion(String path) {
            this.diff.changeType = ChangeType.DELETED;
            this.diff.oldPath = path;
            this.diff.newPath = null;
            return this;
        }

        public Builder changed(String path) {
            this.diff.changeType = ChangeType.MODIFIED;
            this.diff.oldPath = path;
            this.diff.newPath = path;
            return this;
        }

        public Builder moved(String oldPath, String newPath) {
            this.diff.changeType = ChangeType.MOVED;
            this.diff.oldPath = oldPath;
            this.diff.newPath = newPath;
            return this;
        }

        public Builder copied(String oldPath, String newPath) {
            this.diff.changeType = ChangeType.COPIED;
            this.diff.oldPath = oldPath;
            this.diff.newPath = newPath;
            return this;
        }

        public Builder unknown(String oldPath, String newPath, String rawType) {
            this.diff.changeType = ChangeType.UNKNOWN;
            this.diff.oldPath = oldPath;
            this.diff.newPath = newPath;
            this.diff.rawChangeType = rawType;
            return this;
        }

        public Builder addTextualDiff(String textualDiff) {
            this.diff.textualDiff = textualDiff;
            return this;
        }

        public DiffObject build() {
            return this.diff;
        }
    }
}

