/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.scm.requests;

import com.google.common.base.Optional;

public class DiffRequest {
    private String sourceRemoteRepositoryUrl;
    private String targetRemoteRepositoryUrl;
    private String sourceRevision;
    private String targetRevision;
    private DiffType type = DiffType.FULL;

    private DiffRequest() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<String> getSourceRemoteRepositoryUrl() {
        return Optional.fromNullable((Object)this.sourceRemoteRepositoryUrl);
    }

    public Optional<String> getTargetRemoteRepositoryUrl() {
        return Optional.fromNullable((Object)this.targetRemoteRepositoryUrl);
    }

    public Optional<String> getSourceRevision() {
        return Optional.fromNullable((Object)this.sourceRevision);
    }

    public Optional<String> getTargetRevision() {
        return Optional.fromNullable((Object)this.targetRevision);
    }

    public DiffType getType() {
        return this.type;
    }

    public static enum DiffType {
        STATUS_ONLY,
        FULL,
        CHANGES_ONLY;

    }

    public static class Builder {
        private DiffRequest request = new DiffRequest();

        public Builder sourceRemoteUrl(String sourceRemoteRepositoryUrl) {
            this.request.sourceRemoteRepositoryUrl = sourceRemoteRepositoryUrl;
            return this;
        }

        public Builder targetRemoteUrl(String targetRemoteRepositoryUrl) {
            this.request.targetRemoteRepositoryUrl = targetRemoteRepositoryUrl;
            return this;
        }

        public Builder sourceRevision(String sourceRevision) {
            this.request.sourceRevision = sourceRevision;
            return this;
        }

        public Builder targetRevision(String targetRevision) {
            this.request.targetRevision = targetRevision;
            return this;
        }

        public Builder statusOnly() {
            this.request.type = DiffType.STATUS_ONLY;
            return this;
        }

        public Builder fullDiff() {
            this.request.type = DiffType.FULL;
            return this;
        }

        public Builder changesOnly() {
            this.request.type = DiffType.CHANGES_ONLY;
            return this;
        }

        public DiffRequest build() {
            return this.request;
        }
    }
}

