/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.scm.requests;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.itemis.maven.plugins.unleash.scm.merge.MergeClient;
import com.itemis.maven.plugins.unleash.scm.merge.MergeStrategy;

public class PushRequest {
    private MergeStrategy mergeStrategy = MergeStrategy.DO_NOT_MERGE;
    private MergeClient mergeClient;

    private PushRequest() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public MergeStrategy getMergeStrategy() {
        return this.mergeStrategy;
    }

    public Optional<MergeClient> getMergeClient() {
        return Optional.fromNullable((Object)this.mergeClient);
    }

    public static class Builder {
        private PushRequest request = new PushRequest();

        public Builder mergeUseLocal() {
            this.request.mergeStrategy = MergeStrategy.USE_LOCAL;
            return this;
        }

        public Builder mergeUseRemote() {
            this.request.mergeStrategy = MergeStrategy.USE_REMOTE;
            return this;
        }

        public Builder merge() {
            this.request.mergeStrategy = MergeStrategy.FULL_MERGE;
            return this;
        }

        public Builder noMerge() {
            this.request.mergeStrategy = MergeStrategy.DO_NOT_MERGE;
            return this;
        }

        public Builder mergeStrategy(MergeStrategy mergeStrategy) {
            if (mergeStrategy != null) {
                this.request.mergeStrategy = mergeStrategy;
            } else {
                this.noMerge();
            }
            return this;
        }

        public Builder mergeClient(MergeClient mergeClient) {
            this.request.mergeClient = mergeClient;
            return this;
        }

        public PushRequest build() {
            if (MergeStrategy.FULL_MERGE == this.request.mergeStrategy) {
                Preconditions.checkState((this.request.mergeClient != null ? 1 : 0) != 0, (Object)("Merge strategy " + (Object)((Object)this.request.mergeStrategy) + " has been requested but no merge client is set!"));
            }
            return this.request;
        }
    }
}

