/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.scm.requests;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.itemis.maven.plugins.unleash.scm.merge.MergeClient;
import com.itemis.maven.plugins.unleash.scm.merge.MergeStrategy;

public class TagRequest {
    private String remoteRepositoryUrl;
    private String revision;
    private String message;
    private boolean push;
    private String tagName;
    private boolean commitBeforeTagging;
    private String scmMessagePrefix;
    private String preTagCommitMessage;
    private MergeStrategy mergeStrategy = MergeStrategy.DO_NOT_MERGE;
    private MergeClient mergeClient;
    private boolean includeUntrackedFiles;

    private TagRequest() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<String> getRemoteRepositoryUrl() {
        return Optional.fromNullable((Object)this.remoteRepositoryUrl);
    }

    public Optional<String> getRevision() {
        return Optional.fromNullable((Object)this.revision);
    }

    public String getMessage() {
        return this.message;
    }

    public boolean push() {
        return this.push;
    }

    public String getTagName() {
        return this.tagName;
    }

    public boolean commitBeforeTagging() {
        return this.commitBeforeTagging;
    }

    public Optional<String> getScmMessagePrefix() {
        return Optional.fromNullable((Object)this.scmMessagePrefix);
    }

    public Optional<String> getPreTagCommitMessage() {
        return Optional.fromNullable((Object)this.preTagCommitMessage);
    }

    public boolean tagFromWorkingCopy() {
        return this.remoteRepositoryUrl == null;
    }

    public MergeStrategy getMergeStrategy() {
        return this.mergeStrategy;
    }

    public Optional<MergeClient> getMergeClient() {
        return Optional.fromNullable((Object)this.mergeClient);
    }

    public boolean includeUntrackedFiles() {
        return this.includeUntrackedFiles;
    }

    public static class Builder {
        private TagRequest request = new TagRequest();

        public Builder from(String remoteRepositoryUrl) {
            this.request.remoteRepositoryUrl = remoteRepositoryUrl;
            return this;
        }

        public Builder revision(String revision) {
            this.request.revision = revision;
            return this;
        }

        public Builder message(String message) {
            this.request.message = message;
            return this;
        }

        public Builder push() {
            this.request.push = true;
            return this;
        }

        public Builder tagName(String tagName) {
            this.request.tagName = tagName;
            return this;
        }

        public Builder commitBeforeTagging() {
            this.request.commitBeforeTagging = true;
            return this;
        }

        public Builder scmMessagePrefix(String scmMessagePrefix) {
            this.request.scmMessagePrefix = scmMessagePrefix;
            return this;
        }

        public Builder preTagCommitMessage(String message) {
            this.request.preTagCommitMessage = message;
            return this;
        }

        public Builder mergeUseLocal() {
            this.request.mergeStrategy = MergeStrategy.USE_LOCAL;
            return this;
        }

        public Builder mergeUseRemote() {
            this.request.mergeStrategy = MergeStrategy.USE_REMOTE;
            return this;
        }

        public Builder merge() {
            this.request.mergeStrategy = MergeStrategy.FULL_MERGE;
            return this;
        }

        public Builder noMerge() {
            this.request.mergeStrategy = MergeStrategy.DO_NOT_MERGE;
            return this;
        }

        public Builder mergeStrategy(MergeStrategy mergeStrategy) {
            if (mergeStrategy != null) {
                this.request.mergeStrategy = mergeStrategy;
            } else {
                this.noMerge();
            }
            return this;
        }

        public Builder mergeClient(MergeClient mergeClient) {
            this.request.mergeClient = mergeClient;
            return this;
        }

        public Builder includeUntrackedFiles() {
            this.request.includeUntrackedFiles = true;
            return this;
        }

        public TagRequest build() {
            Preconditions.checkState((!Strings.isNullOrEmpty((String)this.request.tagName) ? 1 : 0) != 0, (Object)"No tag name specified!");
            Preconditions.checkState((this.request.message != null ? 1 : 0) != 0, (Object)"No log message specified!");
            if (this.request.commitBeforeTagging) {
                Preconditions.checkState((this.request.preTagCommitMessage != null ? 1 : 0) != 0, (Object)"Committing before tagging has been requested but no pre-tag commit message has been specified!");
            }
            if (MergeStrategy.FULL_MERGE == this.request.mergeStrategy) {
                Preconditions.checkState((this.request.mergeClient != null ? 1 : 0) != 0, (Object)("Merge strategy " + (Object)((Object)this.request.mergeStrategy) + " has been requested but no merge client is set!"));
            }
            return this.request;
        }
    }
}

