/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.scm.results;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class HistoryCommit {
    private String revision;
    private String message;
    private String author;
    private Date date;

    private HistoryCommit() {
    }

    public String getRevision() {
        return this.revision;
    }

    public String getMessage() {
        return this.message;
    }

    public String getAuthor() {
        return this.author;
    }

    public Date getDate() {
        return this.date;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.revision});
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        HistoryCommit otherCommit = (HistoryCommit)other;
        return otherCommit.getRevision() == this.revision;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.revision);
        sb.append("\n").append("Message: ").append(Strings.nullToEmpty((String)this.message));
        sb.append("\n").append("Author: ").append(Strings.nullToEmpty((String)this.author));
        sb.append("\n").append("Date: ").append(this.date == null ? "" : this.date.toString());
        return sb.toString();
    }

    public static class Builder {
        private HistoryCommit commit = new HistoryCommit();

        private Builder() {
        }

        public Builder setRevision(String revision) {
            this.commit.revision = revision;
            return this;
        }

        public Builder setMessage(String message) {
            this.commit.message = message;
            return this;
        }

        public Builder setAuthor(String author) {
            this.commit.author = author;
            return this;
        }

        public Builder setDate(Date date) {
            this.commit.date = date;
            return this;
        }

        public HistoryCommit build() {
            Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)this.commit.revision), (Object)"A commit cannot be created without a commit id (revision).");
            return this.commit;
        }
    }
}

