/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.scm.utils;

import com.google.common.base.Function;
import java.io.File;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class FileToRelativePath
implements Function<File, String> {
    private File workingDir;

    public FileToRelativePath(File workingDir) {
        this.workingDir = workingDir;
    }

    public String apply(File f) {
        URI workingDirURI = this.toURIWithNormalizedDriveLetterOnWindows(this.workingDir);
        URI fileURI = this.toURIWithNormalizedDriveLetterOnWindows(f);
        return workingDirURI.relativize(fileURI).toString();
    }

    private URI toURIWithNormalizedDriveLetterOnWindows(File file) {
        String absolutePath;
        int driveSeparatorIndex;
        if (SystemUtils.IS_OS_WINDOWS && (driveSeparatorIndex = (absolutePath = file.getAbsoluteFile().getPath()).indexOf(58)) > 0) {
            absolutePath = absolutePath.substring(0, driveSeparatorIndex).toLowerCase() + absolutePath.substring(driveSeparatorIndex);
            return new File(absolutePath).toURI();
        }
        return file.toURI();
    }

    public boolean isParentOfOrSame(File f) {
        return !StringUtils.startsWith((CharSequence)this.apply(f), (CharSequence)"file:");
    }
}

