/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.scm.providers;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.itemis.maven.plugins.unleash.scm.ScmException;
import com.itemis.maven.plugins.unleash.scm.ScmOperation;
import com.itemis.maven.plugins.unleash.scm.ScmProvider;
import com.itemis.maven.plugins.unleash.scm.ScmProviderInitialization;
import com.itemis.maven.plugins.unleash.scm.annotations.ScmProviderType;
import com.itemis.maven.plugins.unleash.scm.merge.MergeClient;
import com.itemis.maven.plugins.unleash.scm.providers.SVNMergeConflictResolver;
import com.itemis.maven.plugins.unleash.scm.providers.util.NullOutputStream;
import com.itemis.maven.plugins.unleash.scm.providers.util.SVNDirEntryNameChecker;
import com.itemis.maven.plugins.unleash.scm.providers.util.SVNHistoryLogEntryHandler;
import com.itemis.maven.plugins.unleash.scm.providers.util.SVNUrlUtils;
import com.itemis.maven.plugins.unleash.scm.providers.util.SVNUtil;
import com.itemis.maven.plugins.unleash.scm.providers.util.collection.FileToWCRelativePath;
import com.itemis.maven.plugins.unleash.scm.providers.util.collection.SVNDiffGenerator;
import com.itemis.maven.plugins.unleash.scm.providers.util.collection.SVNStatusToFile;
import com.itemis.maven.plugins.unleash.scm.providers.util.collection.WCRelativePathToFile;
import com.itemis.maven.plugins.unleash.scm.requests.BranchRequest;
import com.itemis.maven.plugins.unleash.scm.requests.CheckoutRequest;
import com.itemis.maven.plugins.unleash.scm.requests.CommitRequest;
import com.itemis.maven.plugins.unleash.scm.requests.DeleteBranchRequest;
import com.itemis.maven.plugins.unleash.scm.requests.DeleteTagRequest;
import com.itemis.maven.plugins.unleash.scm.requests.DiffRequest;
import com.itemis.maven.plugins.unleash.scm.requests.HistoryRequest;
import com.itemis.maven.plugins.unleash.scm.requests.PushRequest;
import com.itemis.maven.plugins.unleash.scm.requests.RevertCommitsRequest;
import com.itemis.maven.plugins.unleash.scm.requests.TagRequest;
import com.itemis.maven.plugins.unleash.scm.requests.UpdateRequest;
import com.itemis.maven.plugins.unleash.scm.results.DiffObject;
import com.itemis.maven.plugins.unleash.scm.results.DiffResult;
import com.itemis.maven.plugins.unleash.scm.results.HistoryResult;
import java.io.File;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.wc.ISVNConflictHandler;
import org.tmatesoft.svn.core.wc.ISVNDiffGenerator;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;

@ScmProviderType(value="svn")
public class ScmProviderSVN
implements ScmProvider {
    private static final String LOG_PREFIX = "SVN - ";
    private SVNClientManager clientManager;
    private File workingDir;
    private SVNUtil util;
    private Logger log;

    public void initialize(ScmProviderInitialization initialization) {
        this.disableKeyring();
        this.workingDir = initialization.getWorkingDirectory();
        if (this.workingDir.exists()) {
            Preconditions.checkArgument((boolean)this.workingDir.isDirectory(), (Object)"The configured working directory is not a directory!");
        }
        this.log = (Logger)initialization.getLogger().or((Object)Logger.getLogger(ScmProvider.class.getName()));
        this.clientManager = initialization.getUsername().isPresent() ? SVNClientManager.newInstance(null, (String)((String)initialization.getUsername().get()), (String)((String)initialization.getPassword().or((Object)""))) : SVNClientManager.newInstance();
        this.util = new SVNUtil(this.clientManager, this.workingDir);
    }

    private void disableKeyring() {
        System.setProperty("svnkit.library.gnome-keyring.enabled", "false");
    }

    public void close() {
        this.util = null;
        this.clientManager.dispose();
    }

    public void checkout(CheckoutRequest request) throws ScmException {
        SVNDepth checkoutDepth;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("SVN - Checking out from remote repository.");
        }
        String url = null;
        url = request.checkoutBranch() ? this.calculateBranchConnectionString(request.getRemoteRepositoryUrl(), (String)request.getBranch().get()) : (request.checkoutTag() ? this.calculateTagConnectionString(request.getRemoteRepositoryUrl(), (String)request.getTag().get()) : request.getRemoteRepositoryUrl());
        if (this.workingDir.exists() && this.workingDir.list().length > 0) {
            throw new ScmException(ScmOperation.CHECKOUT, "Unable to checkout remote repository '" + url + "'. Local working directory '" + this.workingDir.getAbsolutePath() + "' is not empty!");
        }
        SVNRevision revisionToCheckout = SVNUrlUtils.toSVNRevisionOrHEAD((Optional<String>)request.getRevision());
        SVNDepth sVNDepth = checkoutDepth = request.checkoutWholeRepository() ? SVNDepth.INFINITY : SVNDepth.EMPTY;
        if (this.log.isLoggable(Level.FINE)) {
            StringBuilder message = new StringBuilder("SVN - Checkout info:\n");
            message.append("\t- WORKING_DIR: ").append(this.workingDir.getAbsolutePath()).append('\n');
            message.append("\t- URL: ").append(url).append('\n');
            message.append("\t- REVISION: ").append(revisionToCheckout).append('\n');
            message.append("\t- DEPTH: ").append(checkoutDepth);
            if (!request.checkoutWholeRepository()) {
                message.append("\n\t- FILES: ").append(Joiner.on((char)',').join((Iterable)request.getPathsToCheckout()));
            }
            this.log.fine(message.toString());
        }
        try {
            SVNUpdateClient updateClient = this.clientManager.getUpdateClient();
            updateClient.setIgnoreExternals(false);
            updateClient.doCheckout(SVNUrlUtils.toSVNURL(url), this.workingDir, revisionToCheckout, revisionToCheckout, checkoutDepth, false);
            if (!request.checkoutWholeRepository()) {
                Collection filesToUpdate = Collections2.transform((Collection)request.getPathsToCheckout(), (Function)new WCRelativePathToFile(this.workingDir));
                updateClient.doUpdate(filesToUpdate.toArray(new File[filesToUpdate.size()]), revisionToCheckout, SVNDepth.INFINITY, false, false, true);
            }
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("SVN - Checkout finished successfully!");
            }
        }
        catch (SVNException e) {
            throw new ScmException(ScmOperation.CHECKOUT, "An error occurred during the checkout of the remote SVN repository: " + url, (Throwable)e);
        }
    }

    public String commit(CommitRequest request) throws ScmException {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("SVN - Committing to remote repository.");
        }
        try {
            Collection<File> filesToCommit = this.util.getFilesToCommit(request.includeUntrackedFiles(), request.getPathsToCommit());
            if (!filesToCommit.isEmpty()) {
                Collection<SVNStatus> outdatedFilesStati;
                Optional<UpdateRequest> updateRequest;
                if (this.log.isLoggable(Level.FINE)) {
                    StringBuilder message = new StringBuilder("SVN - Commit info:\n");
                    message.append("\t- WORKING_DIR: ").append(this.workingDir.getAbsolutePath()).append('\n');
                    message.append("\t- URL: ").append(this.util.getCurrentConnectionUrl()).append('\n');
                    message.append("\t- MERGE_STRATEGY: ").append(request.getMergeStrategy()).append('\n');
                    message.append("\t- FILES: ").append(Joiner.on((char)',').join((Iterable)Collections2.transform(filesToCommit, (Function)new FileToWCRelativePath(this.workingDir))));
                    this.log.fine(message.toString());
                }
                if ((updateRequest = this.util.createUpdateRequestForFiles(Collections2.transform(outdatedFilesStati = this.util.getOutdatedFiles(filesToCommit), (Function)SVNStatusToFile.INSTANCE), SVNRevision.HEAD, request.getMergeStrategy(), (Optional<MergeClient>)request.getMergeClient())).isPresent()) {
                    this.update((UpdateRequest)updateRequest.get());
                }
                SVNWCClient workingCopyClient = this.clientManager.getWCClient();
                for (File file : filesToCommit) {
                    if (file.exists()) continue;
                    workingCopyClient.doDelete(file, true, false);
                }
                SVNCommitClient commitClient = this.clientManager.getCommitClient();
                SVNCommitInfo info = commitClient.doCommit(filesToCommit.toArray(new File[filesToCommit.size()]), true, request.getMessage(), null, null, true, true, SVNDepth.INFINITY);
                long newRevision = info.getNewRevision();
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("SVN - Commit finished successfully. New remote revision is: " + newRevision);
                }
                return String.valueOf(newRevision);
            }
            String localRevision = this.getLocalRevision();
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("SVN - There was nothing to commit. Current revision is: " + localRevision);
            }
            return localRevision;
        }
        catch (SVNException e) {
            throw new ScmException(ScmOperation.COMMIT, "Could not commit changes to the remote SVN repository.", (Throwable)e);
        }
    }

    public String push(PushRequest request) throws ScmException {
        return this.getLatestRemoteRevision();
    }

    public String update(UpdateRequest request) throws ScmException {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("SVN - Updating local working copy.");
        }
        try {
            SVNUpdateClient updateClient = this.clientManager.getUpdateClient();
            DefaultSVNOptions options = (DefaultSVNOptions)updateClient.getOptions();
            options.setConflictHandler((ISVNConflictHandler)new SVNMergeConflictResolver(request.getMergeStrategy(), (Optional<MergeClient>)request.getMergeClient()));
            updateClient.setUpdateLocksOnDemand(true);
            SVNRevision revision = SVNUrlUtils.toSVNRevisionOrHEAD((Optional<String>)request.getTargetRevision());
            Collection filesToUpdate = Collections2.transform((Collection)request.getPathsToUpdate(), (Function)new WCRelativePathToFile(this.workingDir));
            if (this.log.isLoggable(Level.FINE)) {
                StringBuilder message = new StringBuilder("SVN - Update info:\n");
                message.append("\t- WORKING_DIR: ").append(this.workingDir.getAbsolutePath()).append('\n');
                message.append("\t- URL: ").append(this.util.getCurrentConnectionUrl()).append('\n');
                message.append("\t- MERGE_STRATEGY: ").append(request.getMergeStrategy());
                if (!filesToUpdate.isEmpty()) {
                    message.append("\n\t- FILES: ").append(Joiner.on((char)',').join((Iterable)request.getPathsToUpdate()));
                }
                this.log.fine(message.toString());
            }
            long newRevision = -1L;
            if (filesToUpdate.isEmpty()) {
                newRevision = updateClient.doUpdate(this.workingDir, revision, SVNDepth.INFINITY, true, false);
            } else {
                long[] newRevisions;
                for (long rev : newRevisions = updateClient.doUpdate(filesToUpdate.toArray(new File[filesToUpdate.size()]), revision, SVNDepth.INFINITY, true, false, true)) {
                    newRevision = Math.max(newRevision, rev);
                }
            }
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("SVN - Update of local working copy finished successfully. New revision is: " + newRevision);
            }
            return String.valueOf(newRevision);
        }
        catch (SVNException e) {
            throw new ScmException(ScmOperation.UPDATE, "Could not update local working copy with changes from remote SVN repository.", (Throwable)e);
        }
    }

    public String tag(TagRequest request) throws ScmException {
        SVNCopySource source;
        String url;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("SVN - Creating SVN tag '" + request.getTagName() + "'");
        }
        String string = url = request.tagFromWorkingCopy() ? this.util.getCurrentConnectionUrl() : (String)request.getRemoteRepositoryUrl().get();
        if (request.tagFromWorkingCopy()) {
            if (request.commitBeforeTagging()) {
                CommitRequest.Builder builder = CommitRequest.builder().message((String)request.getPreTagCommitMessage().or((Object)("Preparation for tag creation (Name: '" + request.getTagName() + "')."))).noMerge();
                if (request.includeUntrackedFiles()) {
                    builder.includeUntrackedFiles();
                }
                String newRevision = this.commit(builder.build());
                SVNRevision tagRevision = SVNUrlUtils.toSVNRevisionOrHEAD((Optional<String>)Optional.of((Object)newRevision));
                source = new SVNCopySource(tagRevision, tagRevision, SVNUrlUtils.toSVNURL(url));
            } else {
                this.util.getFilesToCommit(request.includeUntrackedFiles(), Collections.emptySet());
                source = new SVNCopySource(SVNRevision.WORKING, SVNRevision.WORKING, this.workingDir);
            }
        } else {
            SVNRevision revision = SVNUrlUtils.toSVNRevisionOrHEAD((Optional<String>)request.getRevision());
            source = new SVNCopySource(revision, revision, SVNUrlUtils.toSVNURL(url));
        }
        try {
            String tagUrl = this.calculateTagConnectionString(url, request.getTagName());
            if (this.log.isLoggable(Level.FINE)) {
                StringBuilder message = new StringBuilder("SVN - Tag info:\n");
                message.append("\t- TAG_NAME: ").append(request.getTagName()).append('\n');
                message.append("\t- TAG_URL: ").append(tagUrl).append('\n');
                if (request.tagFromWorkingCopy()) {
                    message.append("\t- TAG_SOURCE: WORKING_COPY (").append(url).append(")\n");
                    message.append("\t- COMMIT_BEFORE: ").append(request.commitBeforeTagging());
                } else {
                    message.append("\t- TAG_SOURCE: ").append(url).append('\n');
                    message.append("\t- REVISION: ").append(request.getRevision());
                }
                this.log.fine(message.toString());
            }
            SVNCopyClient copyClient = this.clientManager.getCopyClient();
            SVNCommitInfo info = copyClient.doCopy(new SVNCopySource[]{source}, SVNUrlUtils.toSVNURL(tagUrl), false, true, true, request.getMessage(), null);
            long newRevision = info.getNewRevision();
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("SVN - Tagging of remote repository finished successfully. New revision is: " + newRevision);
            }
            return String.valueOf(newRevision);
        }
        catch (SVNException e) {
            throw new ScmException(ScmOperation.TAG, "An error occurred during SVN tag creation.", (Throwable)e);
        }
    }

    public boolean hasTag(String tagName) {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("SVN - Searching SVN tag '" + tagName + "'");
        }
        SVNLogClient logClient = this.clientManager.getLogClient();
        String tagsUrl = SVNUrlUtils.getBaseTagsUrl(this.util.getCurrentConnectionUrl());
        try {
            if (this.log.isLoggable(Level.FINE)) {
                StringBuilder message = new StringBuilder("SVN - Query info:\n");
                message.append("\t- TAGS_FOLDER_URL: ").append(tagsUrl).append('\n');
                message.append("\t- TAG_NAME: ").append(tagName);
                this.log.fine(message.toString());
            }
            SVNDirEntryNameChecker nameChecker = new SVNDirEntryNameChecker(tagName);
            logClient.doList(SVNUrlUtils.toSVNURL(tagsUrl), SVNRevision.HEAD, SVNRevision.HEAD, false, false, (ISVNDirEntryHandler)nameChecker);
            return nameChecker.isPresent();
        }
        catch (SVNException e) {
            throw new ScmException(ScmOperation.TAG, "An error occurred while querying the remote SVN repository for tag '" + tagName + "'.", (Throwable)e);
        }
    }

    public String deleteTag(DeleteTagRequest request) throws ScmException {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("SVN - Deleting SVN tag");
        }
        SVNCommitClient commitClient = this.clientManager.getCommitClient();
        String tagUrl = this.calculateTagConnectionString(this.util.getCurrentConnectionUrl(), request.getTagName());
        try {
            if (this.log.isLoggable(Level.FINE)) {
                StringBuilder message = new StringBuilder("SVN - Tag info:\n");
                message.append("\t- TAG_NAME: ").append(request.getTagName()).append('\n');
                message.append("\t- TAG_URL: ").append(tagUrl);
                this.log.fine(message.toString());
            }
            SVNCommitInfo info = commitClient.doDelete(new SVNURL[]{SVNUrlUtils.toSVNURL(tagUrl)}, request.getMessage());
            return String.valueOf(info.getNewRevision());
        }
        catch (SVNException e) {
            throw new ScmException(ScmOperation.DELETE_TAG, "An error occurred during the deletion of the SVN tag '" + request.getTagName() + "'. SVN url: " + tagUrl, (Throwable)e);
        }
    }

    public String branch(BranchRequest request) throws ScmException {
        SVNCopySource source;
        String url;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("SVN - Creating SVN branch.");
        }
        String string = url = request.branchFromWorkingCopy() ? this.util.getCurrentConnectionUrl() : (String)request.getRemoteRepositoryUrl().get();
        if (request.branchFromWorkingCopy()) {
            if (request.commitBeforeBranching()) {
                CommitRequest cr = CommitRequest.builder().message(request.getPreBranchCommitMessage()).noMerge().build();
                String newRevision = this.commit(cr);
                SVNRevision branchRevision = SVNUrlUtils.toSVNRevisionOrHEAD((Optional<String>)Optional.of((Object)newRevision));
                source = new SVNCopySource(branchRevision, branchRevision, SVNUrlUtils.toSVNURL(url));
            } else {
                this.util.getFilesToCommit(true, Collections.emptySet());
                source = new SVNCopySource(SVNRevision.WORKING, SVNRevision.WORKING, this.workingDir);
            }
        } else {
            SVNRevision revision = SVNUrlUtils.toSVNRevisionOrHEAD((Optional<String>)request.getRevision());
            source = new SVNCopySource(revision, revision, SVNUrlUtils.toSVNURL(url));
        }
        try {
            String branchUrl = this.calculateBranchConnectionString(url, request.getBranchName());
            if (this.log.isLoggable(Level.FINE)) {
                StringBuilder message = new StringBuilder("SVN - Branch info:\n");
                message.append("\t- BRANCH_NAME: ").append(request.getBranchName()).append('\n');
                message.append("\t- BRANCH_URL: ").append(branchUrl).append('\n');
                if (request.branchFromWorkingCopy()) {
                    message.append("\t- BRANCH_SOURCE: WORKING_COPY (").append(url).append(")\n");
                    message.append("\t- COMMIT_BEFORE: ").append(request.commitBeforeBranching());
                } else {
                    message.append("\t- BRANCH_SOURCE: ").append(url).append('\n');
                    message.append("\t- REVISION: ").append(request.getRevision());
                }
                this.log.fine(message.toString());
            }
            SVNCopyClient copyClient = this.clientManager.getCopyClient();
            SVNCommitInfo info = copyClient.doCopy(new SVNCopySource[]{source}, SVNUrlUtils.toSVNURL(branchUrl), false, true, true, request.getMessage(), null);
            long newRevision = info.getNewRevision();
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("SVN - Branching of remote repository finished successfully. New revision is: " + newRevision);
            }
            return String.valueOf(newRevision);
        }
        catch (SVNException e) {
            throw new ScmException(ScmOperation.BRANCH, "An error occurred during SVN branch creation.", (Throwable)e);
        }
    }

    public boolean hasBranch(String branchName) throws ScmException {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("SVN - Searching SVN branch");
        }
        SVNLogClient logClient = this.clientManager.getLogClient();
        String branchesUrl = SVNUrlUtils.getBaseBranchesUrl(this.util.getCurrentConnectionUrl());
        try {
            if (this.log.isLoggable(Level.FINE)) {
                StringBuilder message = new StringBuilder("SVN - Query info:\n");
                message.append("\t- BRANCHES_FOLDER_URL: ").append(branchesUrl).append('\n');
                message.append("\t- BRANCH_NAME: ").append(branchName);
                this.log.fine(message.toString());
            }
            SVNDirEntryNameChecker nameChecker = new SVNDirEntryNameChecker(branchName);
            logClient.doList(SVNUrlUtils.toSVNURL(branchesUrl), SVNRevision.HEAD, SVNRevision.HEAD, false, false, (ISVNDirEntryHandler)nameChecker);
            return nameChecker.isPresent();
        }
        catch (SVNException e) {
            throw new ScmException(ScmOperation.BRANCH, "An error occurred while querying the remote SVN repository for branch '" + branchName + "'.", (Throwable)e);
        }
    }

    public String deleteBranch(DeleteBranchRequest request) throws ScmException {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("SVN - Deleting SVN branch");
        }
        SVNCommitClient commitClient = this.clientManager.getCommitClient();
        String branchUrl = this.calculateBranchConnectionString(this.util.getCurrentConnectionUrl(), request.getBranchName());
        try {
            if (this.log.isLoggable(Level.FINE)) {
                StringBuilder message = new StringBuilder("SVN - Branch info:\n");
                message.append("\t- BRANCH_NAME: ").append(request.getBranchName()).append('\n');
                message.append("\t- BRANCH_URL: ").append(branchUrl);
                this.log.fine(message.toString());
            }
            SVNCommitInfo info = commitClient.doDelete(new SVNURL[]{SVNUrlUtils.toSVNURL(branchUrl)}, request.getMessage());
            return String.valueOf(info.getNewRevision());
        }
        catch (SVNException e) {
            throw new ScmException(ScmOperation.DELETE_BRANCH, "An error occurred during the deletion of the SVN branch '" + request.getBranchName() + "'. SVN url: " + branchUrl, (Throwable)e);
        }
    }

    public String revertCommits(RevertCommitsRequest request) throws ScmException {
        String to;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("SVN - Reverting SVN commits");
        }
        String latestRemoteRevision = this.getLatestRemoteRevision();
        String from = request.getFromRevision();
        int revisionDiff = from.compareTo(to = request.getToRevision());
        if (revisionDiff == 0) {
            return latestRemoteRevision;
        }
        if (revisionDiff < 0) {
            throw new ScmException(ScmOperation.REVERT_COMMITS, "Error reverting commits in remote repository. \"FROM\" revision (" + from + ") is older than \"TO\" revision (" + to + ")");
        }
        if (latestRemoteRevision.compareTo(from) < 0 || latestRemoteRevision.compareTo(to) < 0) {
            throw new ScmException(ScmOperation.REVERT_COMMITS, "Error reverting commits in remote repository. \"FROM\" revision (" + from + ") or \"TO\" revision (" + to + ") is newer than the head revision (" + latestRemoteRevision + ")");
        }
        if (this.log.isLoggable(Level.FINE)) {
            StringBuilder message = new StringBuilder(LOG_PREFIX).append("Commit info:\n");
            message.append("\t- FROM: ").append(request.getFromRevision()).append('\n');
            message.append("\t- TO: ").append(request.getToRevision()).append('\n');
            message.append("\t- MERGE_STRATEGY: ").append(request.getMergeStrategy()).append('\n');
            this.log.fine(message.toString());
        }
        UpdateRequest updateRequest = UpdateRequest.builder().mergeStrategy(request.getMergeStrategy()).mergeClient((MergeClient)request.getMergeClient().orNull()).build();
        this.update(updateRequest);
        SVNURL url = SVNUrlUtils.toSVNURL(this.util.getCurrentConnectionUrl());
        SVNRevision toRevision = SVNUrlUtils.toSVNRevisionOrHEAD((Optional<String>)Optional.of((Object)to));
        SVNRevision fromRevision = SVNUrlUtils.toSVNRevisionOrHEAD((Optional<String>)Optional.of((Object)from));
        try {
            SVNDiffClient diffClient = this.clientManager.getDiffClient();
            DefaultSVNOptions options = (DefaultSVNOptions)diffClient.getOptions();
            options.setConflictHandler((ISVNConflictHandler)new SVNMergeConflictResolver(request.getMergeStrategy(), (Optional<MergeClient>)request.getMergeClient()));
            diffClient.doMerge(url, fromRevision, url, toRevision, this.workingDir, SVNDepth.INFINITY, false, true, false, false);
        }
        catch (Exception e) {
            throw new ScmException(ScmOperation.REVERT_COMMITS, "An error occurred during the reversion of some SVN commits.", (Throwable)e);
        }
        CommitRequest commitRequest = CommitRequest.builder().merge().mergeClient((MergeClient)request.getMergeClient().orNull()).message(request.getMessage()).build();
        String newRevision = this.commit(commitRequest);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("SVN - Revert finished successfully. New revision is: " + newRevision);
        }
        return newRevision;
    }

    public String getLocalRevision() {
        try {
            SVNStatus status = this.clientManager.getStatusClient().doStatus(this.workingDir, false);
            return String.valueOf(status != null ? status.getRevision().getNumber() : -1L);
        }
        catch (SVNException e) {
            throw new IllegalStateException("Could not retrieve local SVN revision", e);
        }
    }

    public String getLatestRemoteRevision() {
        try {
            SVNStatus status = this.clientManager.getStatusClient().doStatus(this.workingDir, true);
            return String.valueOf(status != null ? Math.max(status.getRemoteRevision().getNumber(), status.getRevision().getNumber()) : -1L);
        }
        catch (SVNException e) {
            throw new IllegalStateException("Could not retrieve remote SVN revision", e);
        }
    }

    public String calculateTagConnectionString(String currentConnectionString, String tagName) {
        return SVNUrlUtils.getBaseTagsUrl(currentConnectionString) + "/" + tagName + SVNUrlUtils.getUrlSubPath(currentConnectionString);
    }

    public String calculateBranchConnectionString(String currentConnectionString, String branchName) {
        String baseUrl = Objects.equal((Object)"trunk", (Object)branchName) ? SVNUrlUtils.getBaseUrl(currentConnectionString) : SVNUrlUtils.getBaseBranchesUrl(currentConnectionString);
        return baseUrl + "/" + branchName + SVNUrlUtils.getUrlSubPath(currentConnectionString);
    }

    public boolean isTagInfoIncludedInConnection() {
        return true;
    }

    public HistoryResult getHistory(HistoryRequest request) throws ScmException {
        String connectionUrl = null;
        connectionUrl = request.getRemoteRepositoryUrl().isPresent() ? (String)request.getRemoteRepositoryUrl().get() : this.util.getCurrentConnectionUrl();
        SVNURL url = SVNUrlUtils.toSVNURL(connectionUrl);
        SVNRevision startRevision = this.getTagRevisionOrDefault(connectionUrl, (Optional<String>)request.getStartTag(), (String)request.getStartRevision().or((Object)"0"));
        SVNRevision endRevision = this.getTagRevisionOrDefault(connectionUrl, (Optional<String>)request.getEndTag(), (String)request.getEndRevision().or((Object)SVNRevision.HEAD.getName()));
        try {
            SVNHistoryLogEntryHandler handler = new SVNHistoryLogEntryHandler(request.getMessageFilters(), request.getMaxResults());
            String[] paths = request.getPathFilters().toArray(new String[request.getPathFilters().size()]);
            if (request.getMessageFilters().isEmpty()) {
                this.clientManager.getLogClient().doLog(url, paths, null, startRevision, endRevision, false, false, request.getMaxResults(), (ISVNLogEntryHandler)handler);
            } else {
                this.clientManager.getLogClient().doLog(url, paths, null, startRevision, endRevision, false, false, -1L, (ISVNLogEntryHandler)handler);
            }
            return handler.getHistory();
        }
        catch (SVNException e) {
            throw new ScmException(ScmOperation.INFO, "Unable to retrieve the SVN log history.", (Throwable)e);
        }
    }

    private SVNRevision getTagRevisionOrDefault(String connectionUrl, Optional<String> tag, String defaultRevision) {
        String revision = defaultRevision;
        if (tag.isPresent()) {
            String tagConnectionString = this.calculateTagConnectionString(connectionUrl, (String)tag.get());
            try {
                SVNInfo info = this.clientManager.getWCClient().doInfo(SVNUrlUtils.toSVNURL(tagConnectionString), null, SVNRevision.HEAD);
                revision = Long.toString(info.getCommittedRevision().getNumber());
            }
            catch (Exception e) {
                throw new ScmException(ScmOperation.INFO, "Unable to get revision of the following URL: " + tagConnectionString, (Throwable)e);
            }
        }
        SVNRevision startRevision = SVNRevision.parse((String)revision);
        return startRevision;
    }

    public DiffResult getDiff(DiffRequest request) throws ScmException {
        SVNRevision targetRevision;
        SVNURL sourceUrl = SVNUrlUtils.toSVNURL((String)request.getSourceRemoteRepositoryUrl().or((Object)this.util.getCurrentConnectionUrl()));
        SVNURL targetUrl = SVNUrlUtils.toSVNURL((String)request.getTargetRemoteRepositoryUrl().or((Object)this.util.getCurrentConnectionUrl()));
        SVNRevision sourceRevision = SVNUrlUtils.toSVNRevisionOrHEAD((Optional<String>)request.getSourceRevision());
        if (Objects.equal((Object)SVNRevision.HEAD, (Object)sourceRevision)) {
            try {
                long rev = this.util.getRemoteRevision(sourceUrl);
                sourceRevision = SVNRevision.parse((String)String.valueOf(rev));
            }
            catch (SVNException e) {
                this.log.fine("Could not determine remote revision of SVN URL '" + sourceUrl.toDecodedString() + "'. Using 'HEAD' instead to calculate the diff.");
            }
        }
        if (Objects.equal((Object)SVNRevision.HEAD, (Object)(targetRevision = SVNUrlUtils.toSVNRevisionOrHEAD((Optional<String>)request.getTargetRevision())))) {
            try {
                long rev = this.util.getRemoteRevision(targetUrl);
                targetRevision = SVNRevision.parse((String)String.valueOf(rev));
            }
            catch (SVNException e) {
                this.log.fine("Could not determine remote revision of SVN URL '" + targetUrl.toDecodedString() + "'. Using 'HEAD' instead to calculate the diff.");
            }
        }
        DiffResult.Builder resultBuilder = DiffResult.builder();
        try {
            SVNDiffClient diffClient = this.clientManager.getDiffClient();
            SVNDiffGenerator diffGenerator = new SVNDiffGenerator(request.getType());
            diffClient.setDiffGenerator((ISVNDiffGenerator)diffGenerator);
            diffClient.doDiff(sourceUrl, sourceRevision, targetUrl, targetRevision, SVNDepth.INFINITY, true, (OutputStream)new NullOutputStream());
            for (DiffObject diff : diffGenerator.getDiffs()) {
                resultBuilder.addDiff(diff);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return resultBuilder.build();
    }
}

