/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.scm.providers.util.collection;

import com.google.common.base.Function;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.SystemUtils;

public class FileToWCRelativePath
implements Function<File, String> {
    private File workingDir;

    public FileToWCRelativePath(File workingDir) {
        this.workingDir = workingDir;
    }

    public String apply(File f) {
        URI workingDirURI = this.workingDir.toURI();
        URI fileURI = f.toURI();
        if (SystemUtils.IS_OS_WINDOWS) {
            String lcURIString = "";
            try {
                lcURIString = workingDirURI.toString().toLowerCase();
                workingDirURI = new URI(lcURIString);
                lcURIString = fileURI.toString().toLowerCase();
                fileURI = new URI(lcURIString);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Failed to create URI for path: " + lcURIString, e);
            }
        }
        return workingDirURI.relativize(fileURI).toString();
    }
}

