/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.scm.providers;

import com.google.common.base.Optional;
import com.google.common.io.Closeables;
import com.itemis.maven.plugins.unleash.scm.merge.MergeClient;
import com.itemis.maven.plugins.unleash.scm.merge.MergeStrategy;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNConflictHandler;
import org.tmatesoft.svn.core.wc.SVNConflictChoice;
import org.tmatesoft.svn.core.wc.SVNConflictDescription;
import org.tmatesoft.svn.core.wc.SVNConflictResult;
import org.tmatesoft.svn.core.wc.SVNMergeFileSet;

public class SVNMergeConflictResolver
implements ISVNConflictHandler {
    private MergeStrategy strategy;
    private Optional<MergeClient> mergeClient;

    public SVNMergeConflictResolver(MergeStrategy strategy, Optional<MergeClient> mergeClient) {
        this.strategy = strategy;
        this.mergeClient = mergeClient;
    }

    public SVNConflictResult handleConflict(SVNConflictDescription conflictDescription) throws SVNException {
        SVNMergeFileSet mergeFiles = conflictDescription.getMergeFiles();
        SVNConflictChoice choice = null;
        FileOutputStream fos = null;
        try {
            File mergedFile;
            fos = new FileOutputStream(mergeFiles.getResultFile());
            switch (this.strategy) {
                case USE_LOCAL: {
                    choice = SVNConflictChoice.MINE_CONFLICT;
                    mergedFile = mergeFiles.getResultFile();
                    break;
                }
                case USE_REMOTE: {
                    choice = SVNConflictChoice.THEIRS_CONFLICT;
                    mergedFile = mergeFiles.getResultFile();
                    break;
                }
                case FULL_MERGE: {
                    if (conflictDescription.isPropertyConflict()) {
                        throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"Merging SVN property conflicts is not yet supported!"));
                    }
                    if (conflictDescription.isTreeConflict()) {
                        throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"Merging SVN tree conflicts is not yet supported!"));
                    }
                    if (conflictDescription.isTextConflict()) {
                        if (!this.mergeClient.isPresent()) {
                            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"Unable to merge remote and local changes due to missing merge client."));
                        }
                        FileInputStream local = new FileInputStream(mergeFiles.getLocalFile());
                        FileInputStream remote = new FileInputStream(mergeFiles.getRepositoryFile());
                        FileInputStream base = new FileInputStream(mergeFiles.getBaseFile());
                        ((MergeClient)this.mergeClient.get()).merge((InputStream)local, (InputStream)remote, (InputStream)base, (OutputStream)fos);
                    }
                    choice = SVNConflictChoice.MERGED;
                    mergedFile = mergeFiles.getResultFile();
                    break;
                }
                default: {
                    choice = SVNConflictChoice.POSTPONE;
                    mergedFile = null;
                }
            }
            SVNConflictResult sVNConflictResult = new SVNConflictResult(choice, mergedFile);
            return sVNConflictResult;
        }
        catch (FileNotFoundException e) {
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_WRITE_ERROR, (String)"Could not write to result file while merging."), (Throwable)e);
        }
        finally {
            try {
                Closeables.close((Closeable)fos, (boolean)true);
            }
            catch (IOException iOException) {}
        }
    }
}

