/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.scm.providers.util;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.itemis.maven.plugins.unleash.scm.ScmException;
import java.util.List;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SVNUrlUtils {
    private static final String PATH_SEGMENT_BRANCHES = "branches";
    private static final String PATH_SEGMENT_TAGS = "tags";
    private static final String PATH_SEGMENT_TRUNK = "trunk";
    private static final String PATH_SEPARATOR = "/";
    private static final String SUBPATH_BRANCHES = "/branches";
    private static final String SUBPATH_TAGS = "/tags";
    private static final String SUBPATH_TRUNK = "/trunk";

    public static String getBaseTagsUrl(String currentUrl) throws ScmException {
        Preconditions.checkArgument((currentUrl != null ? 1 : 0) != 0);
        Preconditions.checkArgument((!currentUrl.isEmpty() ? 1 : 0) != 0);
        return SVNUrlUtils.getBaseUrl(currentUrl) + SUBPATH_TAGS;
    }

    public static String getBaseBranchesUrl(String currentUrl) throws ScmException {
        Preconditions.checkArgument((currentUrl != null ? 1 : 0) != 0);
        Preconditions.checkArgument((!currentUrl.isEmpty() ? 1 : 0) != 0);
        return SVNUrlUtils.getBaseUrl(currentUrl) + SUBPATH_BRANCHES;
    }

    public static String getBaseUrl(String currentUrl) throws ScmException {
        Preconditions.checkArgument((currentUrl != null ? 1 : 0) != 0);
        Preconditions.checkArgument((!currentUrl.isEmpty() ? 1 : 0) != 0);
        int trunkPos = currentUrl.indexOf(SUBPATH_TRUNK);
        int branchesPos = currentUrl.indexOf(SUBPATH_BRANCHES);
        int tagsPos = currentUrl.indexOf(SUBPATH_TAGS);
        if (trunkPos > -1) {
            return currentUrl.substring(0, trunkPos);
        }
        if (branchesPos > -1) {
            return currentUrl.substring(0, branchesPos);
        }
        if (tagsPos > -1) {
            return currentUrl.substring(0, tagsPos);
        }
        return currentUrl;
    }

    public static String getUrlSubPath(String currentUrl) {
        if (!(currentUrl.contains(SUBPATH_BRANCHES) || currentUrl.contains(SUBPATH_TAGS) || currentUrl.contains(SUBPATH_TRUNK))) {
            return "";
        }
        List split = Splitter.on((String)PATH_SEPARATOR).splitToList((CharSequence)currentUrl);
        int startIndex = -1;
        for (int i = split.size() - 1; i >= 0; --i) {
            String segment = (String)split.get(i);
            if (PATH_SEGMENT_TRUNK.equals(segment)) {
                startIndex = i + 1;
                break;
            }
            if (!PATH_SEGMENT_BRANCHES.equals(segment) && !PATH_SEGMENT_TAGS.equals(segment)) continue;
            startIndex = i + 2;
            break;
        }
        if (startIndex == -1 || startIndex >= split.size()) {
            return "";
        }
        return PATH_SEPARATOR + Joiner.on((char)'/').join(split.subList(startIndex, split.size()));
    }

    public static SVNURL toSVNURL(String urlString) throws ScmException, IllegalArgumentException {
        Preconditions.checkArgument((urlString != null ? 1 : 0) != 0);
        Preconditions.checkArgument((!urlString.isEmpty() ? 1 : 0) != 0);
        try {
            return SVNURL.parseURIEncoded((String)urlString);
        }
        catch (SVNException e) {
            throw new ScmException("Unable to parse the following SVN connection URL: " + urlString);
        }
    }

    public static SVNRevision toSVNRevisionOrHEAD(Optional<String> revision) {
        return SVNRevision.parse((String)((String)revision.or((Object)SVNRevision.HEAD.getName())));
    }
}

