/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.scm.providers.util.collection;

import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.itemis.maven.plugins.unleash.scm.requests.DiffRequest;
import com.itemis.maven.plugins.unleash.scm.results.DiffObject;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.DefaultSVNDiffGenerator;
import org.tmatesoft.svn.core.wc.ISVNDiffGenerator;

public class SVNDiffGenerator
extends DefaultSVNDiffGenerator
implements ISVNDiffGenerator {
    private Set<DiffObject> diffs = Sets.newHashSet();
    private DiffRequest.DiffType type;

    public SVNDiffGenerator(DiffRequest.DiffType type) {
        this.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayFileDiff(String path, File file1, File file2, String rev1, String rev2, String mimeType1, String mimeType2, OutputStream result) throws SVNException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            boolean addTextualDiff;
            super.displayFileDiff(path, file1, file2, rev1, rev2, mimeType1, mimeType2, (OutputStream)os);
            DiffObject.Builder builder = DiffObject.builder();
            boolean bl = addTextualDiff = this.type == DiffRequest.DiffType.FULL;
            if (file1 == null) {
                builder.addition(path);
            } else if (file2 == null) {
                builder.deletion(path);
            } else {
                builder.changed(path);
                addTextualDiff |= this.type == DiffRequest.DiffType.CHANGES_ONLY;
            }
            if (addTextualDiff) {
                builder.addTextualDiff(new String(os.toByteArray()));
            }
            this.diffs.add(builder.build());
        }
        finally {
            try {
                Closeables.close((Closeable)os, (boolean)true);
            }
            catch (IOException iOException) {}
        }
    }

    public void displayDeletedDirectory(String path, String rev1, String rev2) throws SVNException {
        super.displayDeletedDirectory(path, rev1, rev2);
        DiffObject.Builder builder = DiffObject.builder();
        builder.deletion(path);
        this.diffs.add(builder.build());
    }

    public void displayAddedDirectory(String path, String rev1, String rev2) throws SVNException {
        super.displayAddedDirectory(path, rev1, rev2);
        DiffObject.Builder builder = DiffObject.builder();
        builder.addition(path);
        this.diffs.add(builder.build());
    }

    public Set<DiffObject> getDiffs() {
        return this.diffs;
    }
}

