/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.util;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.itemis.maven.plugins.unleash.util.VersionUpgradeStrategy;
import java.util.Iterator;
import java.util.List;

class Version {
    private static final char SEPARATOR_DASH = '-';
    private static final char SEPARATOR_DOT = '.';
    private List<String> segments = Lists.newArrayList();
    private List<Character> separators = Lists.newArrayList();

    private Version() {
    }

    protected static Version parse(String versionString) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)versionString) ? 1 : 0) != 0, (Object)"Please provide a version String!");
        Version version = new Version();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < versionString.length(); ++i) {
            char c = versionString.charAt(i);
            if ('-' == c || '.' == c) {
                version.segments.add(sb.toString());
                version.separators.add(Character.valueOf(c));
                sb.setLength(0);
                continue;
            }
            sb.append(c);
        }
        version.segments.add(sb.toString());
        return version;
    }

    public void increase(VersionUpgradeStrategy strategy) {
        if (strategy == VersionUpgradeStrategy.DEFAULT) {
            this.increaseLowestPossibleSegment();
        } else {
            this.increaseSpecificSegment(strategy.getVersionSegmentIndex());
        }
    }

    private void increaseLowestPossibleSegment() {
        for (int i = this.segments.size() - 1; i >= 0; --i) {
            String increasedSegment;
            String segment = this.segments.get(i);
            if (Objects.equal((Object)segment, (Object)(increasedSegment = this.increaseSegment(segment)))) continue;
            this.segments.set(i, increasedSegment);
            break;
        }
    }

    private void increaseSpecificSegment(short index) {
        for (short increasableIndex = index; increasableIndex < this.segments.size() && increasableIndex >= 0; increasableIndex = (short)(increasableIndex + 1)) {
            String increasedSegment;
            String segment = this.segments.get(increasableIndex);
            if (Objects.equal((Object)segment, (Object)(increasedSegment = this.increaseSegment(segment)))) continue;
            this.segments.set(increasableIndex, increasedSegment);
            return;
        }
        this.increaseLowestPossibleSegment();
    }

    private String increaseSegment(String segment) {
        StringBuilder sb = new StringBuilder(segment);
        int start = -1;
        int end = -1;
        for (int i = sb.length() - 1; i >= 0; --i) {
            try {
                Integer.parseInt(sb.substring(i, i + 1));
                if (end != -1) continue;
                end = i;
                continue;
            }
            catch (NumberFormatException e) {
                if (end <= 0 || start != -1) continue;
                start = i + 1;
                break;
            }
        }
        if (end >= 0) {
            if (start == -1) {
                start = 0;
            }
            int lengthForLeadingZeroes = 0;
            String sNumber = sb.substring(start, end + 1);
            if (sNumber.startsWith("0")) {
                lengthForLeadingZeroes = sNumber.length();
            }
            int increasedNumber = Integer.parseInt(sNumber) + 1;
            sNumber = String.format(lengthForLeadingZeroes > 0 ? "%0" + lengthForLeadingZeroes + "d" : "%d", increasedNumber);
            sb.replace(start, end + 1, sNumber);
        }
        return sb.toString();
    }

    public String toString() {
        if (this.segments.isEmpty()) {
            return "";
        }
        Iterator<String> segmentsIterator = this.segments.iterator();
        StringBuilder sb = new StringBuilder(segmentsIterator.next());
        for (Character separator : this.separators) {
            sb.append(separator);
            sb.append(segmentsIterator.next());
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        Version v = Version.parse("1.0.7-12-SNAPSHOT");
        v.increase(VersionUpgradeStrategy.DEFAULT);
        System.out.println(v);
    }
}

