/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.android.service;

import android.annotation.SuppressLint;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.PowerManager;
import android.util.Log;
import org.eclipse.paho.android.service.MqttService;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttPingSender;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;

class AlarmPingSender
implements MqttPingSender {
    private static final String TAG = "AlarmPingSender";
    private ClientComms comms;
    private MqttService service;
    private BroadcastReceiver alarmReceiver;
    private AlarmPingSender that;
    private PendingIntent pendingIntent;
    private volatile boolean hasStarted = false;

    public AlarmPingSender(MqttService service) {
        if (service == null) {
            throw new IllegalArgumentException("Neither service nor client can be null.");
        }
        this.service = service;
        this.that = this;
    }

    public void init(ClientComms comms) {
        this.comms = comms;
        this.alarmReceiver = new AlarmReceiver();
    }

    public void start() {
        String action = "MqttService.pingSender." + this.comms.getClient().getClientId();
        Log.d((String)TAG, (String)("Register alarmreceiver to MqttService" + action));
        IntentFilter filter = new IntentFilter(action);
        if (Build.VERSION.SDK_INT >= 33) {
            this.service.registerReceiver(this.alarmReceiver, filter, 2);
        } else {
            this.service.registerReceiver(this.alarmReceiver, filter);
        }
        this.pendingIntent = Build.VERSION.SDK_INT >= 31 ? PendingIntent.getBroadcast((Context)this.service, (int)0, (Intent)new Intent(action), (int)0x4000000) : PendingIntent.getBroadcast((Context)this.service, (int)0, (Intent)new Intent(action), (int)0x8000000);
        this.schedule(this.comms.getKeepAlive());
        this.hasStarted = true;
    }

    public void stop() {
        Log.d((String)TAG, (String)("Unregister alarmreceiver to MqttService" + this.comms.getClient().getClientId()));
        if (this.hasStarted) {
            if (this.pendingIntent != null) {
                AlarmManager alarmManager = (AlarmManager)this.service.getSystemService("alarm");
                alarmManager.cancel(this.pendingIntent);
            }
            this.hasStarted = false;
            try {
                this.service.unregisterReceiver(this.alarmReceiver);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void schedule(long delayInMilliseconds) {
        long nextAlarmInMilliseconds = System.currentTimeMillis() + delayInMilliseconds;
        Log.d((String)TAG, (String)("Schedule next alarm at " + nextAlarmInMilliseconds));
        AlarmManager alarmManager = (AlarmManager)this.service.getSystemService("alarm");
        if (Build.VERSION.SDK_INT >= 23) {
            Log.d((String)TAG, (String)("Alarm scheule using setExactAndAllowWhileIdle, next: " + delayInMilliseconds));
            alarmManager.setExactAndAllowWhileIdle(0, nextAlarmInMilliseconds, this.pendingIntent);
        } else if (Build.VERSION.SDK_INT >= 19) {
            Log.d((String)TAG, (String)("Alarm scheule using setExact, delay: " + delayInMilliseconds));
            alarmManager.setExact(0, nextAlarmInMilliseconds, this.pendingIntent);
        } else {
            alarmManager.set(0, nextAlarmInMilliseconds, this.pendingIntent);
        }
    }

    class AlarmReceiver
    extends BroadcastReceiver {
        private PowerManager.WakeLock wakelock;
        private final String wakeLockTag;

        AlarmReceiver() {
            this.wakeLockTag = "MqttService.client." + AlarmPingSender.this.that.comms.getClient().getClientId();
        }

        @SuppressLint(value={"Wakelock"})
        public void onReceive(Context context, Intent intent) {
            Log.d((String)AlarmPingSender.TAG, (String)("Sending Ping at:" + System.currentTimeMillis()));
            PowerManager pm = (PowerManager)AlarmPingSender.this.service.getSystemService("power");
            this.wakelock = pm.newWakeLock(1, this.wakeLockTag);
            this.wakelock.acquire();
            MqttToken token = AlarmPingSender.this.comms.checkForActivity(new IMqttActionListener(){

                public void onSuccess(IMqttToken asyncActionToken) {
                    Log.d((String)AlarmPingSender.TAG, (String)("Success. Release lock(" + AlarmReceiver.this.wakeLockTag + "):" + System.currentTimeMillis()));
                    AlarmReceiver.this.wakelock.release();
                }

                public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
                    Log.d((String)AlarmPingSender.TAG, (String)("Failure. Release lock(" + AlarmReceiver.this.wakeLockTag + "):" + System.currentTimeMillis()));
                    AlarmReceiver.this.wakelock.release();
                }
            });
            if (token == null && this.wakelock.isHeld()) {
                this.wakelock.release();
            }
        }
    }
}

