/*
 * Decompiled with CFR 0.152.
 */
package io.github.mbenincasa.javaopenweathermapclient.utils;

import io.github.mbenincasa.javaopenweathermapclient.exception.OpenWeatherMapException;
import io.github.mbenincasa.javarestclient.client.DefaultRestClient;
import io.github.mbenincasa.javarestclient.client.RestClient;
import io.github.mbenincasa.javarestclient.exception.RestClientException;
import io.github.mbenincasa.javarestclient.http.HttpStatus;
import io.github.mbenincasa.javarestclient.support.UriBuilder;
import java.util.List;
import java.util.Map;

public class HttpRequestExecutor {
    private static final RestClient restClient = new DefaultRestClient();

    public static <T> T executeGetSingle(String baseUrl, Map<String, Object> query, Class<T> responseType) throws RestClientException {
        RestClient.RestClientResponseSpec responseSpec = restClient.get().uri(HttpRequestExecutor.buildUri(baseUrl, query, Map.of()).build()).retrieve();
        HttpRequestExecutor.handleErrorRequest(responseSpec);
        return (T)responseSpec.getBody(responseType);
    }

    public static <T, R> List<T> executePostList(String baseUrl, Map<String, Object> query, R bodyRequest, Class<T> responseType) throws RestClientException {
        RestClient.RestClientResponseSpec responseSpec = ((RestClient.RestClientRequestBodySpec)restClient.post().uri(HttpRequestExecutor.buildUri(baseUrl, query, Map.of()).build())).body(bodyRequest).retrieve();
        HttpRequestExecutor.handleErrorRequest(responseSpec);
        return responseSpec.getBodyAsList(responseType);
    }

    public static <T> List<T> executeGetList(String baseUrl, Map<String, Object> query, Class<T> responseType) throws RestClientException {
        RestClient.RestClientResponseSpec responseSpec = restClient.get().uri(HttpRequestExecutor.buildUri(baseUrl, query, Map.of()).build()).retrieve();
        HttpRequestExecutor.handleErrorRequest(responseSpec);
        return responseSpec.getBodyAsList(responseType);
    }

    public static byte[] executeGetRaw(String baseUrl, Map<String, Object> query, Map<String, Object> pathVar) throws RestClientException {
        RestClient.RestClientResponseSpec responseSpec = restClient.get().uri(HttpRequestExecutor.buildUri(baseUrl, query, pathVar).build()).retrieve();
        HttpRequestExecutor.handleErrorRequest(responseSpec);
        return responseSpec.getBodyAsRaw();
    }

    private static UriBuilder buildUri(String baseUrl, Map<String, Object> query, Map<String, Object> pathVar) {
        UriBuilder uriBuilder = UriBuilder.create().uri(baseUrl);
        query.forEach((x$0, xva$1) -> uriBuilder.queryParam(x$0, new Object[]{xva$1}));
        pathVar.forEach((arg_0, arg_1) -> ((UriBuilder)uriBuilder).pathVariable(arg_0, arg_1));
        return uriBuilder;
    }

    private static void handleErrorRequest(RestClient.RestClientResponseSpec responseSpec) throws RestClientException {
        HttpStatus responseStatus = responseSpec.getStatus();
        if (responseStatus.getValue() >= 400 && responseStatus.getValue() < 500) {
            String responseError = responseSpec.getBodyAsString();
            throw new OpenWeatherMapException(responseError);
        }
        if (responseStatus.getValue() >= 500) {
            throw new OpenWeatherMapException("Contact OpenWeatherMap Support. Response status: " + responseStatus.getValue());
        }
    }
}

