/*
 * Decompiled with CFR 0.152.
 */
package com.meetsl.scardview;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import com.meetsl.scardview.R;
import com.meetsl.scardview.SCardViewDelegate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u0015\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 b2\u00020\u0001:\u0002bcBU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\r\u0012\u0006\u0010\u0010\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u00100\u001a\u00020-2\u0006\u00101\u001a\u00020\tH\u0002J\b\u00102\u001a\u00020\u0017H\u0002J,\u00103\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0+\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0+0+H\u0002J\u0010\u00104\u001a\u00020-2\u0006\u00105\u001a\u000206H\u0016J\u0018\u00107\u001a\u00020-2\u0006\u00105\u001a\u0002062\u0006\u00101\u001a\u00020\tH\u0002J\u0018\u00108\u001a\u00020-2\u0006\u00105\u001a\u0002062\u0006\u00101\u001a\u00020\tH\u0002J\u0018\u00109\u001a\u00020-2\u0006\u00105\u001a\u0002062\u0006\u00101\u001a\u00020\tH\u0002J\u0018\u0010:\u001a\u00020-2\u0006\u00105\u001a\u0002062\u0006\u00101\u001a\u00020\tH\u0002J\u0010\u0010;\u001a\u00020-2\u0006\u00105\u001a\u000206H\u0002J\u0006\u0010<\u001a\u00020\u0017J\b\u0010=\u001a\u0004\u0018\u00010\u0007J\u0006\u0010>\u001a\u00020\tJ\u000e\u0010?\u001a\u00020-2\u0006\u0010@\u001a\u00020/J\u0006\u0010A\u001a\u00020\tJ\u0006\u0010B\u001a\u00020\tJ\u0006\u0010C\u001a\u00020\tJ\u0014\u0010D\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010+J\b\u0010E\u001a\u00020\rH\u0016J\u0010\u0010F\u001a\u00020\u00132\u0006\u0010G\u001a\u00020/H\u0016J\u0006\u0010H\u001a\u00020\tJ\b\u0010I\u001a\u00020\u0013H\u0016J\u0010\u0010J\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0014J\u0010\u0010K\u001a\u00020\u00132\u0006\u0010L\u001a\u00020MH\u0014J\u000e\u0010N\u001a\u00020-2\u0006\u0010O\u001a\u00020\u0013J\u0010\u0010P\u001a\u00020-2\u0006\u0010Q\u001a\u00020\rH\u0016J\u0012\u0010R\u001a\u00020-2\b\u0010S\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010T\u001a\u00020-2\b\u0010S\u001a\u0004\u0018\u00010\u0007J\u0012\u0010U\u001a\u00020-2\b\u0010V\u001a\u0004\u0018\u00010WH\u0016J\u001e\u0010X\u001a\u00020-2\u0006\u0010\u0006\u001a\u00020\r2\u0006\u0010Y\u001a\u00020\r2\u0006\u0010Z\u001a\u00020\rJ\u000e\u0010[\u001a\u00020-2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\\\u001a\u00020-2\u0006\u0010]\u001a\u00020\tJ\u0016\u0010^\u001a\u00020-2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rJ\u000e\u0010_\u001a\u00020-2\u0006\u0010]\u001a\u00020\tJ\u0018\u0010_\u001a\u00020-2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0002J\u0010\u0010`\u001a\u00020\r2\u0006\u0010a\u001a\u00020\tH\u0002R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R4\u0010*\u001a(\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0+\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0+\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006d"}, d2={"Lcom/meetsl/scardview/SRoundRectDrawableWithShadow;", "Landroid/graphics/drawable/Drawable;", "cardViewDelegate", "Lcom/meetsl/scardview/SCardViewDelegate;", "resources", "Landroid/content/res/Resources;", "backgroundColor", "Landroid/content/res/ColorStateList;", "radius", "", "shadowSize", "maxShadowSize", "direction", "", "cornerVisibility", "startColor", "endColor", "(Lcom/meetsl/scardview/SCardViewDelegate;Landroid/content/res/Resources;Landroid/content/res/ColorStateList;FFFIIII)V", "isFirst", "", "mAddPaddingForCorners", "mBackground", "mCardBounds", "Landroid/graphics/RectF;", "mCardDelegate", "mCornerRadius", "mCornerShadowPaint", "Landroid/graphics/Paint;", "mCornerShadowPath", "Landroid/graphics/Path;", "mCornerVisibility", "mDirty", "mEdgeShadowPaint", "mInsetShadow", "mLightDirection", "mPaint", "mPrintedShadowClipWarning", "mRawMaxShadowSize", "mRawShadowSize", "mShadowEndColor", "mShadowSize", "mShadowStartColor", "mTranslatePos", "Lkotlin/Pair;", "buildComponents", "", "bounds", "Landroid/graphics/Rect;", "buildShadowCorners", "cornerRadius", "calculateCornerVisibility", "calculateShadowDirection", "draw", "canvas", "Landroid/graphics/Canvas;", "drawLBCorner", "drawLTCorner", "drawRBCorner", "drawRTCorner", "drawShadow", "getCardRectSize", "getColor", "getCornerRadius", "getMaxShadowAndCornerPadding", "into", "getMaxShadowSize", "getMinHeight", "getMinWidth", "getMoveDistance", "getOpacity", "getPadding", "padding", "getShadowSize", "isStateful", "onBoundsChange", "onStateChange", "stateSet", "", "setAddPaddingForCorners", "addPaddingForCorners", "setAlpha", "alpha", "setBackground", "color", "setColor", "setColorFilter", "cf", "Landroid/graphics/ColorFilter;", "setColors", "shadowStartColor", "shadowEndColor", "setCornerRadius", "setMaxShadowSize", "size", "setShadowColor", "setShadowSize", "toEven", "value", "Companion", "RoundRectHelper", "SCardView_release"})
public final class SRoundRectDrawableWithShadow
extends Drawable {
    private int mInsetShadow;
    private Paint mPaint;
    private Paint mCornerShadowPaint;
    private Paint mEdgeShadowPaint;
    private RectF mCardBounds;
    private float mCornerRadius;
    private Path mCornerShadowPath;
    private float mRawMaxShadowSize;
    private float mShadowSize;
    private float mRawShadowSize;
    private ColorStateList mBackground;
    private boolean mDirty;
    private int mShadowStartColor;
    private int mShadowEndColor;
    private boolean mAddPaddingForCorners;
    private boolean mPrintedShadowClipWarning;
    private int mLightDirection;
    private int mCornerVisibility;
    private SCardViewDelegate mCardDelegate;
    private Pair<Pair<Float, Float>, Pair<Float, Float>> mTranslatePos;
    private boolean isFirst;
    private static final double COS_45;
    @Nullable
    private static RoundRectHelper sRoundRectHelper;
    public static final float SHADOW_MULTIPLIER = 1.5f;
    public static final Companion Companion;

    private final void setBackground(ColorStateList color2) {
        ColorStateList colorStateList = color2;
        if (colorStateList == null) {
            colorStateList = ColorStateList.valueOf((int)0);
        }
        ColorStateList colorStateList2 = this.mBackground = colorStateList;
        if (colorStateList2 == null) {
            Intrinsics.throwNpe();
        }
        int[] nArray = this.getState();
        ColorStateList colorStateList3 = this.mBackground;
        if (colorStateList3 == null) {
            Intrinsics.throwNpe();
        }
        this.mPaint.setColor(colorStateList2.getColorForState(nArray, colorStateList3.getDefaultColor()));
    }

    private final int toEven(float value) {
        int i = (int)(value + 0.5f);
        return i % 2 == 1 ? i - 1 : i;
    }

    public final void setAddPaddingForCorners(boolean addPaddingForCorners) {
        this.mAddPaddingForCorners = addPaddingForCorners;
        this.invalidateSelf();
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
        this.mCornerShadowPaint.setAlpha(alpha);
        this.mEdgeShadowPaint.setAlpha(alpha);
    }

    protected void onBoundsChange(@NotNull Rect bounds) {
        Intrinsics.checkParameterIsNotNull((Object)bounds, (String)"bounds");
        super.onBoundsChange(bounds);
        this.mDirty = true;
    }

    private final void setShadowSize(float shadowSize, float maxShadowSize) {
        float updateShadowSize = shadowSize;
        float updateMaxShadowSize = maxShadowSize;
        if (updateShadowSize < 0.0f) {
            throw (Throwable)new IllegalArgumentException("Invalid shadow size " + updateShadowSize + ". Must be >= 0");
        }
        if (updateMaxShadowSize < 0.0f) {
            throw (Throwable)new IllegalArgumentException("Invalid max shadow size " + updateMaxShadowSize + ". Must be >= 0");
        }
        if ((updateShadowSize = (float)this.toEven(updateShadowSize)) > (updateMaxShadowSize = (float)this.toEven(updateMaxShadowSize))) {
            updateShadowSize = updateMaxShadowSize;
            if (!this.mPrintedShadowClipWarning) {
                this.mPrintedShadowClipWarning = true;
            }
        }
        if (this.mRawShadowSize == updateShadowSize && this.mRawMaxShadowSize == updateMaxShadowSize) {
            return;
        }
        this.mRawShadowSize = updateShadowSize;
        this.mRawMaxShadowSize = updateMaxShadowSize;
        this.mShadowSize = (int)(updateShadowSize * 1.5f + (float)this.mInsetShadow + 0.5f);
        this.mDirty = true;
        this.invalidateSelf();
    }

    public boolean getPadding(@NotNull Rect padding) {
        Intrinsics.checkParameterIsNotNull((Object)padding, (String)"padding");
        double d = Companion.calculateVerticalPadding(this.mRawMaxShadowSize, this.mCornerRadius, this.mAddPaddingForCorners);
        boolean bl = false;
        int vOffset = (int)Math.ceil(d);
        double d2 = Companion.calculateHorizontalPadding(this.mRawMaxShadowSize, this.mCornerRadius, this.mAddPaddingForCorners);
        boolean bl2 = false;
        int hOffset = (int)Math.ceil(d2);
        padding.set(hOffset, vOffset, hOffset, vOffset);
        return true;
    }

    protected boolean onStateChange(@NotNull int[] stateSet) {
        Intrinsics.checkParameterIsNotNull((Object)stateSet, (String)"stateSet");
        ColorStateList colorStateList = this.mBackground;
        if (colorStateList == null) {
            Intrinsics.throwNpe();
        }
        ColorStateList colorStateList2 = this.mBackground;
        if (colorStateList2 == null) {
            Intrinsics.throwNpe();
        }
        int newColor = colorStateList.getColorForState(stateSet, colorStateList2.getDefaultColor());
        if (this.mPaint.getColor() == newColor) {
            return false;
        }
        this.mPaint.setColor(newColor);
        this.mDirty = true;
        this.invalidateSelf();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isStateful() {
        if (this.mBackground != null) {
            ColorStateList colorStateList = this.mBackground;
            if (colorStateList == null) {
                Intrinsics.throwNpe();
            }
            if (colorStateList.isStateful()) return true;
        }
        if (!super.isStateful()) return false;
        return true;
    }

    public void setColorFilter(@Nullable ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -3;
    }

    public final void setCornerRadius(float radius) {
        float updateRadius = radius;
        if (updateRadius < 0.0f) {
            throw (Throwable)new IllegalArgumentException("Invalid radius " + updateRadius + ". Must be >= 0");
        }
        if (this.mCornerRadius == (updateRadius = (float)((int)(updateRadius + 0.5f)))) {
            return;
        }
        this.mCornerRadius = updateRadius;
        this.mDirty = true;
        this.invalidateSelf();
    }

    public void draw(@NotNull Canvas canvas) {
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
            if (this.mDirty) {
                Rect rect = this.getBounds();
                Intrinsics.checkExpressionValueIsNotNull((Object)rect, (String)"bounds");
                this.buildComponents(rect);
                this.mDirty = false;
            }
            Pair<Pair<Float, Float>, Pair<Float, Float>> pair = this.mTranslatePos = this.calculateShadowDirection();
            if (pair == null) break block3;
            Pair<Pair<Float, Float>, Pair<Float, Float>> pair2 = pair;
            boolean bl = false;
            boolean bl2 = false;
            Pair<Pair<Float, Float>, Pair<Float, Float>> it = pair2;
            boolean bl3 = false;
            canvas.translate(((Number)((Pair)it.getFirst()).getFirst()).floatValue(), ((Number)((Pair)it.getFirst()).getSecond()).floatValue());
            this.drawShadow(canvas);
            canvas.translate(((Number)((Pair)it.getSecond()).getFirst()).floatValue(), ((Number)((Pair)it.getSecond()).getSecond()).floatValue());
            RoundRectHelper roundRectHelper = sRoundRectHelper;
            if (roundRectHelper != null) {
                roundRectHelper.drawRoundRect(canvas, this.mCardBounds, this.mCornerRadius, this.mCornerVisibility, this.mPaint);
            }
            if (this.isFirst) {
                this.mCardDelegate.getCardView().requestLayout();
                this.isFirst = false;
            }
        }
    }

    private final Pair<Pair<Float, Float>, Pair<Float, Float>> calculateShadowDirection() {
        Pair pair;
        float moveDistance = this.mRawShadowSize / (float)2;
        switch (this.mLightDirection) {
            case 9: {
                Pair shadowPos = new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
                Pair rectPos = new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
                pair = new Pair((Object)shadowPos, (Object)rectPos);
                break;
            }
            case 1: {
                Pair shadowPos = new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
                Pair rectPos = new Pair((Object)Float.valueOf(-moveDistance), (Object)Float.valueOf(0.0f));
                pair = new Pair((Object)shadowPos, (Object)rectPos);
                break;
            }
            case 2: {
                Pair shadowPos = new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
                Pair rectPos = new Pair((Object)Float.valueOf(moveDistance), (Object)Float.valueOf(0.0f));
                pair = new Pair((Object)shadowPos, (Object)rectPos);
                break;
            }
            case 3: {
                Pair shadowPos = new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
                Pair rectPos = new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(-moveDistance));
                pair = new Pair((Object)shadowPos, (Object)rectPos);
                break;
            }
            case 4: {
                Pair shadowPos = new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
                Pair rectPos = new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(moveDistance));
                pair = new Pair((Object)shadowPos, (Object)rectPos);
                break;
            }
            case 5: {
                Pair shadowPos = new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(moveDistance));
                Pair rectPos = new Pair((Object)Float.valueOf(-moveDistance), (Object)Float.valueOf(-moveDistance));
                pair = new Pair((Object)shadowPos, (Object)rectPos);
                break;
            }
            case 6: {
                Pair shadowPos = new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(moveDistance));
                Pair rectPos = new Pair((Object)Float.valueOf(moveDistance), (Object)Float.valueOf(-moveDistance));
                pair = new Pair((Object)shadowPos, (Object)rectPos);
                break;
            }
            case 7: {
                Pair shadowPos = new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(-moveDistance));
                Pair rectPos = new Pair((Object)Float.valueOf(-moveDistance), (Object)Float.valueOf(moveDistance));
                pair = new Pair((Object)shadowPos, (Object)rectPos);
                break;
            }
            case 8: {
                Pair shadowPos = new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(-moveDistance));
                Pair rectPos = new Pair((Object)Float.valueOf(moveDistance), (Object)Float.valueOf(moveDistance));
                pair = new Pair((Object)shadowPos, (Object)rectPos);
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("invalid light direction exception");
            }
        }
        return pair;
    }

    private final void drawShadow(Canvas canvas) {
        RectF visibility = this.calculateCornerVisibility();
        int saved = canvas.save();
        this.drawLTCorner(canvas, visibility.left);
        canvas.restoreToCount(saved);
        saved = canvas.save();
        this.drawRBCorner(canvas, visibility.right);
        canvas.restoreToCount(saved);
        saved = canvas.save();
        this.drawLBCorner(canvas, visibility.bottom);
        canvas.restoreToCount(saved);
        saved = canvas.save();
        this.drawRTCorner(canvas, visibility.top);
        canvas.restoreToCount(saved);
    }

    private final RectF calculateCornerVisibility() {
        RectF rectF;
        switch (this.mCornerVisibility) {
            case 1: {
                rectF = new RectF(0.0f, this.mCornerRadius, this.mCornerRadius, 0.0f);
                break;
            }
            case 2: {
                rectF = new RectF(this.mCornerRadius, 0.0f, 0.0f, this.mCornerRadius);
                break;
            }
            case 3: {
                rectF = new RectF(0.0f, 0.0f, this.mCornerRadius, this.mCornerRadius);
                break;
            }
            case 4: {
                rectF = new RectF(this.mCornerRadius, this.mCornerRadius, 0.0f, 0.0f);
                break;
            }
            case 5: {
                rectF = new RectF(0.0f, this.mCornerRadius, 0.0f, this.mCornerRadius);
                break;
            }
            case 6: {
                rectF = new RectF(this.mCornerRadius, 0.0f, this.mCornerRadius, 0.0f);
                break;
            }
            default: {
                rectF = new RectF(this.mCornerRadius, this.mCornerRadius, this.mCornerRadius, this.mCornerRadius);
            }
        }
        return rectF;
    }

    private final void drawRTCorner(Canvas canvas, float cornerRadius) {
        float edgeShadowTop = -cornerRadius - this.mShadowSize;
        float inset = cornerRadius + (float)this.mInsetShadow + this.mRawShadowSize / (float)2;
        float right = this.mCardBounds.height() - (float)2 * inset;
        boolean drawVerticalEdges = right > 0.0f;
        this.buildShadowCorners(cornerRadius);
        canvas.translate(this.mCardBounds.right - inset, this.mCardBounds.top + inset);
        canvas.rotate(90.0f);
        Path path = this.mCornerShadowPath;
        if (path == null) {
            Intrinsics.throwNpe();
        }
        canvas.drawPath(path, this.mCornerShadowPaint);
        if (drawVerticalEdges) {
            if (this.mCornerVisibility == 3 || this.mCornerVisibility == 6) {
                right -= this.mCornerRadius;
            }
            if (this.mCornerVisibility == 4 || this.mCornerVisibility == 5) {
                right += this.mCornerRadius;
            }
            canvas.drawRect(0.0f, edgeShadowTop, right, -cornerRadius, this.mEdgeShadowPaint);
        }
    }

    private final void drawRBCorner(Canvas canvas, float cornerRadius) {
        float edgeShadowTop = -cornerRadius - this.mShadowSize;
        float inset = cornerRadius + (float)this.mInsetShadow + this.mRawShadowSize / (float)2;
        boolean drawHorizontalEdges = this.mCardBounds.width() - (float)2 * inset > 0.0f;
        this.buildShadowCorners(cornerRadius);
        canvas.translate(this.mCardBounds.right - inset, this.mCardBounds.bottom - inset);
        canvas.rotate(180.0f);
        Path path = this.mCornerShadowPath;
        if (path == null) {
            Intrinsics.throwNpe();
        }
        canvas.drawPath(path, this.mCornerShadowPaint);
        if (drawHorizontalEdges) {
            float right = this.mCardBounds.width() - (float)2 * inset;
            if (this.mCornerVisibility == 1 || this.mCornerVisibility == 6) {
                right += this.mCornerRadius;
            }
            if (this.mCornerVisibility == 2 || this.mCornerVisibility == 5) {
                right -= this.mCornerRadius;
            }
            canvas.drawRect(0.0f, edgeShadowTop, right, -cornerRadius, this.mEdgeShadowPaint);
        }
    }

    private final void drawLBCorner(Canvas canvas, float cornerRadius) {
        this.buildShadowCorners(cornerRadius);
        float edgeShadowTop = -cornerRadius - this.mShadowSize;
        float inset = cornerRadius + (float)this.mInsetShadow + this.mRawShadowSize / (float)2;
        float right = this.mCardBounds.height() - (float)2 * inset;
        boolean drawVerticalEdges = right > 0.0f;
        canvas.translate(this.mCardBounds.left + inset, this.mCardBounds.bottom - inset);
        canvas.rotate(270.0f);
        Path path = this.mCornerShadowPath;
        if (path == null) {
            Intrinsics.throwNpe();
        }
        canvas.drawPath(path, this.mCornerShadowPaint);
        if (drawVerticalEdges) {
            if (this.mCornerVisibility == 3 || this.mCornerVisibility == 5) {
                right += this.mCornerRadius;
            }
            if (this.mCornerVisibility == 4 || this.mCornerVisibility == 6) {
                right -= this.mCornerRadius;
            }
            canvas.drawRect(0.0f, edgeShadowTop, right, -cornerRadius, this.mEdgeShadowPaint);
        }
    }

    private final void drawLTCorner(Canvas canvas, float cornerRadius) {
        float edgeShadowTop = -cornerRadius - this.mShadowSize;
        float inset = cornerRadius + (float)this.mInsetShadow + this.mRawShadowSize / (float)2;
        boolean drawHorizontalEdges = this.mCardBounds.width() - (float)2 * inset > 0.0f;
        this.buildShadowCorners(cornerRadius);
        canvas.translate(this.mCardBounds.left + inset, this.mCardBounds.top + inset);
        Path path = this.mCornerShadowPath;
        if (path == null) {
            Intrinsics.throwNpe();
        }
        canvas.drawPath(path, this.mCornerShadowPaint);
        if (drawHorizontalEdges) {
            float right = this.mCardBounds.width() - (float)2 * inset;
            if (this.mCornerVisibility == 2 || this.mCornerVisibility == 6) {
                right += this.mCornerRadius;
            }
            if (this.mCornerVisibility == 1 || this.mCornerVisibility == 5) {
                right -= this.mCornerRadius;
            }
            canvas.drawRect(0.0f, edgeShadowTop, right, -cornerRadius, this.mEdgeShadowPaint);
        }
    }

    private final void buildShadowCorners(float cornerRadius) {
        RectF innerBounds = new RectF(-cornerRadius, -cornerRadius, cornerRadius, cornerRadius);
        RectF outerBounds = new RectF(innerBounds);
        outerBounds.inset(-this.mShadowSize, -this.mShadowSize);
        if (this.mCornerShadowPath == null) {
            this.mCornerShadowPath = new Path();
        } else {
            Path path = this.mCornerShadowPath;
            if (path == null) {
                Intrinsics.throwNpe();
            }
            path.reset();
        }
        Path path = this.mCornerShadowPath;
        if (path == null) {
            Intrinsics.throwNpe();
        }
        path.setFillType(Path.FillType.EVEN_ODD);
        Path path2 = this.mCornerShadowPath;
        if (path2 == null) {
            Intrinsics.throwNpe();
        }
        path2.moveTo(-cornerRadius, 0.0f);
        Path path3 = this.mCornerShadowPath;
        if (path3 == null) {
            Intrinsics.throwNpe();
        }
        path3.rLineTo(-this.mShadowSize, 0.0f);
        Path path4 = this.mCornerShadowPath;
        if (path4 == null) {
            Intrinsics.throwNpe();
        }
        path4.arcTo(outerBounds, 180.0f, 90.0f, false);
        Path path5 = this.mCornerShadowPath;
        if (path5 == null) {
            Intrinsics.throwNpe();
        }
        path5.arcTo(innerBounds, 270.0f, -90.0f, false);
        Path path6 = this.mCornerShadowPath;
        if (path6 == null) {
            Intrinsics.throwNpe();
        }
        path6.close();
        float startRatio = cornerRadius / (cornerRadius + this.mShadowSize);
        this.mCornerShadowPaint.setShader((Shader)new RadialGradient(0.0f, 0.0f, cornerRadius + this.mShadowSize, new int[]{this.mShadowStartColor, this.mShadowStartColor, this.mShadowEndColor}, new float[]{0.0f, startRatio, 1.0f}, Shader.TileMode.CLAMP));
        this.mEdgeShadowPaint.setShader((Shader)new LinearGradient(0.0f, -cornerRadius + this.mShadowSize, 0.0f, -cornerRadius - this.mShadowSize, new int[]{this.mShadowStartColor, this.mShadowStartColor, this.mShadowEndColor}, new float[]{0.0f, 0.5f, 1.0f}, Shader.TileMode.CLAMP));
        this.mEdgeShadowPaint.setAntiAlias(false);
    }

    private final void buildComponents(Rect bounds) {
        float verticalOffset = this.mRawMaxShadowSize * 1.5f;
        this.mCardBounds.set((float)bounds.left + this.mRawMaxShadowSize, (float)bounds.top + verticalOffset, (float)bounds.right - this.mRawMaxShadowSize, (float)bounds.bottom - verticalOffset);
        this.buildShadowCorners(this.mCornerRadius);
    }

    public final float getCornerRadius() {
        return this.mCornerRadius;
    }

    public final void getMaxShadowAndCornerPadding(@NotNull Rect into) {
        Intrinsics.checkParameterIsNotNull((Object)into, (String)"into");
        this.getPadding(into);
    }

    public final void setShadowSize(float size) {
        this.setShadowSize(size, this.mRawMaxShadowSize);
    }

    public final void setMaxShadowSize(float size) {
        this.setShadowSize(this.mRawShadowSize, size);
    }

    public final float getShadowSize() {
        return this.mRawShadowSize;
    }

    public final float getMaxShadowSize() {
        return this.mRawMaxShadowSize;
    }

    public final float getMinWidth() {
        float content = (float)2 * Math.max(this.mRawMaxShadowSize, this.mCornerRadius + (float)this.mInsetShadow + this.mRawMaxShadowSize / (float)2);
        return content + (this.mRawMaxShadowSize + (float)this.mInsetShadow) * (float)2;
    }

    public final float getMinHeight() {
        float content = (float)2 * Math.max(this.mRawMaxShadowSize, this.mCornerRadius + (float)this.mInsetShadow + this.mRawMaxShadowSize * 1.5f / (float)2);
        return content + (this.mRawMaxShadowSize * 1.5f + (float)this.mInsetShadow) * (float)2;
    }

    public final void setColor(@Nullable ColorStateList color2) {
        this.setBackground(color2);
        this.invalidateSelf();
    }

    @Nullable
    public final ColorStateList getColor() {
        return this.mBackground;
    }

    @NotNull
    public final RectF getCardRectSize() {
        return this.mCardBounds;
    }

    @Nullable
    public final Pair<Float, Float> getMoveDistance() {
        Pair<Pair<Float, Float>, Pair<Float, Float>> pair = this.mTranslatePos;
        if (pair != null) {
            Pair<Pair<Float, Float>, Pair<Float, Float>> pair2 = pair;
            boolean bl = false;
            boolean bl2 = false;
            Pair<Pair<Float, Float>, Pair<Float, Float>> it = pair2;
            boolean bl3 = false;
            float x = ((Number)((Pair)it.getFirst()).getFirst()).floatValue() + ((Number)((Pair)it.getSecond()).getFirst()).floatValue();
            float y = ((Number)((Pair)it.getFirst()).getSecond()).floatValue() + ((Number)((Pair)it.getSecond()).getSecond()).floatValue();
            return new Pair((Object)Float.valueOf(x), (Object)Float.valueOf(y));
        }
        return null;
    }

    public final void setShadowColor(int startColor, int endColor) {
        this.mShadowStartColor = startColor;
        this.mShadowEndColor = endColor;
        this.invalidateSelf();
    }

    public final void setColors(int backgroundColor, int shadowStartColor, int shadowEndColor) {
        ColorStateList colorStateList = this.mBackground = ColorStateList.valueOf((int)backgroundColor);
        if (colorStateList == null) {
            Intrinsics.throwNpe();
        }
        int[] nArray = this.getState();
        ColorStateList colorStateList2 = this.mBackground;
        if (colorStateList2 == null) {
            Intrinsics.throwNpe();
        }
        this.mPaint.setColor(colorStateList.getColorForState(nArray, colorStateList2.getDefaultColor()));
        this.mShadowStartColor = shadowStartColor;
        this.mShadowEndColor = shadowEndColor;
        this.invalidateSelf();
    }

    public SRoundRectDrawableWithShadow(@NotNull SCardViewDelegate cardViewDelegate, @NotNull Resources resources, @NotNull ColorStateList backgroundColor, float radius, float shadowSize, float maxShadowSize, int direction, int cornerVisibility, int startColor, int endColor) {
        Intrinsics.checkParameterIsNotNull((Object)cardViewDelegate, (String)"cardViewDelegate");
        Intrinsics.checkParameterIsNotNull((Object)resources, (String)"resources");
        Intrinsics.checkParameterIsNotNull((Object)backgroundColor, (String)"backgroundColor");
        this.mDirty = true;
        this.mAddPaddingForCorners = true;
        this.mLightDirection = 3;
        this.mCornerVisibility = 7;
        this.mShadowStartColor = startColor == -1 ? resources.getColor(R.color.sl_cardview_shadow_start_color) : startColor;
        this.mShadowEndColor = endColor == -1 ? resources.getColor(R.color.sl_cardview_shadow_end_color) : endColor;
        this.mInsetShadow = resources.getDimensionPixelSize(R.dimen.cardview_compat_inset_shadow);
        this.mPaint = new Paint(5);
        this.setBackground(backgroundColor);
        this.mCornerShadowPaint = new Paint(5);
        this.mCornerShadowPaint.setStyle(Paint.Style.FILL);
        this.mCornerRadius = (int)(radius + 0.5f);
        this.mCardBounds = new RectF();
        this.mEdgeShadowPaint = new Paint(this.mCornerShadowPaint);
        this.mEdgeShadowPaint.setAntiAlias(false);
        this.mLightDirection = direction;
        this.mCornerVisibility = cornerVisibility;
        this.mCardDelegate = cardViewDelegate;
        this.setShadowSize(shadowSize, maxShadowSize);
        this.isFirst = true;
    }

    static {
        Companion = new Companion(null);
        double d = Math.toRadians(45.0);
        boolean bl = false;
        COS_45 = Math.cos(d);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J0\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&\u00a8\u0006\u000e"}, d2={"Lcom/meetsl/scardview/SRoundRectDrawableWithShadow$RoundRectHelper;", "", "drawRoundRect", "", "canvas", "Landroid/graphics/Canvas;", "bounds", "Landroid/graphics/RectF;", "cornerRadius", "", "cornerVisibility", "", "paint", "Landroid/graphics/Paint;", "SCardView_release"})
    public static interface RoundRectHelper {
        public void drawRoundRect(@NotNull Canvas var1, @NotNull RectF var2, float var3, int var4, @NotNull Paint var5);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/meetsl/scardview/SRoundRectDrawableWithShadow$Companion;", "", "()V", "COS_45", "", "SHADOW_MULTIPLIER", "", "sRoundRectHelper", "Lcom/meetsl/scardview/SRoundRectDrawableWithShadow$RoundRectHelper;", "getSRoundRectHelper", "()Lcom/meetsl/scardview/SRoundRectDrawableWithShadow$RoundRectHelper;", "setSRoundRectHelper", "(Lcom/meetsl/scardview/SRoundRectDrawableWithShadow$RoundRectHelper;)V", "calculateHorizontalPadding", "maxShadowSize", "cornerRadius", "addPaddingForCorners", "", "calculateVerticalPadding", "SCardView_release"})
    public static final class Companion {
        @Nullable
        public final RoundRectHelper getSRoundRectHelper() {
            return sRoundRectHelper;
        }

        public final void setSRoundRectHelper(@Nullable RoundRectHelper roundRectHelper) {
            sRoundRectHelper = roundRectHelper;
        }

        public final float calculateVerticalPadding(float maxShadowSize, float cornerRadius, boolean addPaddingForCorners) {
            return addPaddingForCorners ? (float)((double)(maxShadowSize * 1.5f) + (1.0 - COS_45) * (double)cornerRadius) : maxShadowSize * 1.5f;
        }

        public final float calculateHorizontalPadding(float maxShadowSize, float cornerRadius, boolean addPaddingForCorners) {
            return addPaddingForCorners ? (float)((double)maxShadowSize + (1.0 - COS_45) * (double)cornerRadius) : maxShadowSize;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

