/*
 * Decompiled with CFR 0.152.
 */
package com.github.melin.superior.sql.parser.antlr4;

import com.github.melin.superior.sql.parser.antlr4.Origin;
import org.apache.commons.lang3.StringUtils;

public class ParseException
extends RuntimeException {
    private String command;
    private String message;
    private Origin start;
    private Origin stop;

    public ParseException(String message, Origin start, Origin stop) {
        this.message = message;
        this.start = start;
        this.stop = stop;
    }

    public ParseException(String command, String message, Origin start, Origin stop) {
        this.command = command;
        this.message = message;
        this.start = start;
        this.stop = stop;
    }

    @Override
    public String getMessage() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n").append(this.message);
        if (this.start != null) {
            builder.append("(line " + this.start.getLine() + ", pos " + this.start.getStartPosition() + ")\n");
            if (StringUtils.isNotBlank((CharSequence)this.command)) {
                int i;
                String[] lines = this.command.split("\n");
                builder.append("\n== SQL ==\n");
                for (i = 0; i < this.start.getLine(); ++i) {
                    builder.append(lines[i]).append("\n");
                }
                for (i = 0; i < this.start.getStartPosition(); ++i) {
                    builder.append("-");
                }
                builder.append("^^^\n");
                for (i = this.start.getLine(); i < lines.length; ++i) {
                    builder.append(lines[i]).append("\n");
                }
            }
        } else {
            builder.append("\n== SQL ==\n").append(this.command);
        }
        return StringUtils.trim((String)builder.toString());
    }

    public ParseException withCommand(String cmd) {
        return new ParseException(cmd, this.message, this.start, this.stop);
    }

    public String getCommand() {
        return this.command;
    }

    public Origin getStart() {
        return this.start;
    }

    public Origin getStop() {
        return this.stop;
    }
}

