/*
 * Decompiled with CFR 0.152.
 */
package com.github.melin.superior.sql.parser.antlr4;

import com.github.melin.superior.sql.parser.antlr4.Origin;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.TerminalNode;

public class ParserUtils {
    public static String getString(Token token) {
        return ParserUtils.unescapeSQLString(token.getText());
    }

    public static String getString(TerminalNode token) {
        return ParserUtils.unescapeSQLString(token.getText());
    }

    public static int getInt(Token token) {
        return Integer.parseInt(token.getText());
    }

    public static String command(ParserRuleContext ctx) {
        CharStream stream = ctx.getStart().getInputStream();
        return stream.getText(Interval.of((int)0, (int)stream.size()));
    }

    public static Origin position(Token token) {
        return new Origin(token.getLine(), token.getCharPositionInLine());
    }

    private static void appendEscapedChar(StringBuilder sb, char n) {
        switch (n) {
            case '0': {
                sb.append("\u0000");
            }
            case '\'': {
                sb.append("'");
            }
            case '\"': {
                sb.append("\"");
            }
            case 'b': {
                sb.append("\b");
            }
            case 'n': {
                sb.append("\n");
            }
            case 'r': {
                sb.append("\r");
            }
            case 't': {
                sb.append("\t");
            }
            case 'Z': {
                sb.append("\u001a");
            }
            case '\\': {
                sb.append("\\");
            }
            case '%': {
                sb.append("\\%");
            }
            case '_': {
                sb.append("\\_");
            }
        }
        sb.append(n);
    }

    private static String unescapeSQLString(String b) {
        Character enclosure = null;
        StringBuilder sb = new StringBuilder(b.length());
        int strLength = b.length();
        for (int i = 0; i < strLength; ++i) {
            char currentChar = b.charAt(i);
            if (enclosure == null) {
                if (currentChar != '\'' && currentChar != '\"') continue;
                enclosure = Character.valueOf(currentChar);
                continue;
            }
            if (enclosure.charValue() == currentChar) {
                enclosure = null;
                continue;
            }
            if (currentChar == '\\') {
                if (i + 6 < strLength && b.charAt(i + 1) == 'u') {
                    int code = 0;
                    int base = i + 2;
                    for (int h = 0; h < 4; ++h) {
                        int digit = Character.digit(b.charAt(h + base), 16);
                        code = (code << 4) + digit;
                    }
                    sb.append((char)code);
                    i += 5;
                    continue;
                }
                if (i + 4 < strLength) {
                    char i1 = b.charAt(i + 1);
                    char i2 = b.charAt(i + 2);
                    char i3 = b.charAt(i + 3);
                    if (i1 >= '0' && i1 <= '1' && i2 >= '0' && i2 <= '7' && i3 >= '0' && i3 <= '7') {
                        char tmp = (char)(i3 - 48 + (i2 - 48 << 3) + (i1 - 48 << 6));
                        sb.append(tmp);
                        i += 3;
                        continue;
                    }
                    ParserUtils.appendEscapedChar(sb, i1);
                    ++i;
                    continue;
                }
                if (i + 2 >= strLength) continue;
                char n = b.charAt(i + 1);
                ParserUtils.appendEscapedChar(sb, n);
                ++i;
                continue;
            }
            sb.append(currentChar);
        }
        return sb.toString();
    }
}

