/*
 * Decompiled with CFR 0.152.
 */
package com.github.melin.superior.sql.parser.job;

import com.github.melin.superior.sql.parser.StatementType;
import com.github.melin.superior.sql.parser.antlr4.job.JobTaskParser;
import com.github.melin.superior.sql.parser.antlr4.job.JobTaskParserBaseVisitor;
import com.github.melin.superior.sql.parser.model.JobData;
import com.github.melin.superior.sql.parser.model.SetData;
import com.github.melin.superior.sql.parser.model.StatementData;
import com.github.melin.superior.sql.parser.model.UnSetData;
import com.github.melin.superior.sql.parser.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0007j\b\u0012\u0004\u0012\u00020\u0002`\bJ\u0014\u0010\n\u001a\u0004\u0018\u00010\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005H\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0005J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0016H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0007j\b\u0012\u0004\u0012\u00020\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/github/melin/superior/sql/parser/job/JobTaskAntlr4Visitor;", "Lcom/github/melin/superior/sql/parser/antlr4/job/JobTaskParserBaseVisitor;", "Lcom/github/melin/superior/sql/parser/model/StatementData;", "()V", "command", "", "tableDatas", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getTableDatas", "replaceWhitespace", "str", "setCommand", "", "visitJobStatement", "ctx", "Lcom/github/melin/superior/sql/parser/antlr4/job/JobTaskParser$JobStatementContext;", "visitJobTask", "Lcom/github/melin/superior/sql/parser/antlr4/job/JobTaskParser$JobTaskContext;", "visitSetStatement", "Lcom/github/melin/superior/sql/parser/antlr4/job/JobTaskParser$SetStatementContext;", "visitUnsetStatement", "Lcom/github/melin/superior/sql/parser/antlr4/job/JobTaskParser$UnsetStatementContext;", "superior-sql-parser"})
public final class JobTaskAntlr4Visitor
extends JobTaskParserBaseVisitor<StatementData> {
    @Nullable
    private String command;
    @NotNull
    private final ArrayList<StatementData> tableDatas = new ArrayList();

    @Override
    @NotNull
    public StatementData visitJobTask(@NotNull JobTaskParser.JobTaskContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        StatementData tableData = (StatementData)super.visitJobTask(ctx);
        this.tableDatas.add(tableData);
        Intrinsics.checkNotNullExpressionValue((Object)tableData, (String)"tableData");
        return tableData;
    }

    @Override
    @NotNull
    public StatementData visitJobStatement(@NotNull JobTaskParser.JobStatementContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        String resourceName = ctx.resourceNameExpr().getText();
        String className = ctx.classNameExpr().getText();
        ArrayList<String> params = null;
        params = new ArrayList<String>();
        if (ctx.paramsExpr() != null) {
            List list = ctx.paramsExpr().children;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ctx.paramsExpr().children");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ParseTree item = (ParseTree)element$iv;
                boolean bl = false;
                ParseTree parseTree = item;
                if (parseTree == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.github.melin.superior.sql.parser.antlr4.job.JobTaskParser.ParamExprContext");
                }
                JobTaskParser.ParamExprContext param = (JobTaskParser.ParamExprContext)parseTree;
                String value = StringUtils.substring((String)this.command, (int)param.start.getStartIndex(), (int)(param.stop.getStopIndex() + 1));
                if (StringUtils.startsWith((CharSequence)value, (CharSequence)"/")) {
                    value = this.replaceWhitespace(value);
                    Collection collection = params;
                    String[] stringArray = StringUtils.split((String)value, (String)" ");
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"split(value, \" \")");
                    CollectionsKt.addAll((Collection)collection, (Object[])stringArray);
                    continue;
                }
                String string = value;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value");
                value = StringUtil.INSTANCE.cleanQuote(string);
                params.add(value);
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)resourceName, (String)"resourceName");
        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"className");
        JobData jobData = new JobData(resourceName, className, (List<String>)params);
        return new StatementData(StatementType.JOB, jobData, null, null, 12, null);
    }

    @Override
    @NotNull
    public StatementData visitSetStatement(@NotNull JobTaskParser.SetStatementContext ctx) {
        String value;
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        String key = ctx.keyExpr().getText();
        String string = value = StringUtils.substring((String)this.command, (int)ctx.value.start.getStartIndex(), (int)(ctx.value.stop.getStopIndex() + 1));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value");
        value = StringUtil.INSTANCE.cleanQuote(string);
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
        SetData data = new SetData(key, value);
        return new StatementData(StatementType.SET, data, null, null, 12, null);
    }

    @Override
    @NotNull
    public StatementData visitUnsetStatement(@NotNull JobTaskParser.UnsetStatementContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        String key = ctx.keyExpr().getText();
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
        UnSetData data = new UnSetData(key);
        return new StatementData(StatementType.UNSET, data, null, null, 12, null);
    }

    private final String replaceWhitespace(String str) {
        int len;
        if (str != null && (len = str.length()) > 0) {
            char[] dest = new char[len];
            int destPos = 0;
            for (int i = 0; i < len; ++i) {
                int c = str.charAt(i);
                dest[destPos++] = !Character.isWhitespace((char)c) ? c : 32;
            }
            return new String(dest, 0, destPos);
        }
        return str;
    }

    @NotNull
    public final ArrayList<StatementData> getTableDatas() {
        return this.tableDatas;
    }

    public final void setCommand(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this.command = command;
    }
}

