/*
 * Decompiled with CFR 0.152.
 */
package com.github.melin.superior.sql.parser.job;

import com.github.melin.superior.sql.parser.antlr4.ParseErrorListener;
import com.github.melin.superior.sql.parser.antlr4.ParseException;
import com.github.melin.superior.sql.parser.antlr4.PostProcessor;
import com.github.melin.superior.sql.parser.antlr4.UpperCaseCharStream;
import com.github.melin.superior.sql.parser.antlr4.job.JobTaskLexer;
import com.github.melin.superior.sql.parser.antlr4.job.JobTaskParser;
import com.github.melin.superior.sql.parser.job.JobTaskAntlr4Visitor;
import com.github.melin.superior.sql.parser.model.StatementData;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lcom/github/melin/superior/sql/parser/job/JobTaskHelper;", "", "()V", "getStatementData", "Ljava/util/ArrayList;", "Lcom/github/melin/superior/sql/parser/model/StatementData;", "Lkotlin/collections/ArrayList;", "command", "", "superior-sql-parser"})
public final class JobTaskHelper {
    @NotNull
    public static final JobTaskHelper INSTANCE = new JobTaskHelper();

    private JobTaskHelper() {
    }

    @JvmStatic
    @NotNull
    public static final ArrayList<StatementData> getStatementData(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        String trimCmd = StringUtils.trim((String)command);
        UpperCaseCharStream charStream = new UpperCaseCharStream(CharStreams.fromString((String)trimCmd));
        JobTaskLexer lexer = new JobTaskLexer(charStream);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)new ParseErrorListener());
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        JobTaskParser parser = new JobTaskParser((TokenStream)tokenStream);
        parser.addParseListener(new PostProcessor());
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new ParseErrorListener());
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        JobTaskAntlr4Visitor cmdVisitor = new JobTaskAntlr4Visitor();
        Intrinsics.checkNotNullExpressionValue((Object)trimCmd, (String)"trimCmd");
        cmdVisitor.setCommand(trimCmd);
        try {
            try {
                cmdVisitor.visit((ParseTree)parser.jobTasks());
                return cmdVisitor.getTableDatas();
            }
            catch (ParseCancellationException e) {
                tokenStream.seek(0);
                parser.reset();
                ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
                cmdVisitor.visit((ParseTree)parser.jobTasks());
                return cmdVisitor.getTableDatas();
            }
        }
        catch (ParseException e) {
            if (StringUtils.isNotBlank((CharSequence)e.getCommand())) {
                throw e;
            }
            ParseException parseException = e.withCommand(trimCmd);
            Intrinsics.checkNotNullExpressionValue((Object)parseException, (String)"e.withCommand(trimCmd)");
            throw (Throwable)parseException;
        }
    }
}

