/*
 * Decompiled with CFR 0.152.
 */
package com.github.melin.superior.sql.parser.mysql;

import com.github.melin.superior.sql.parser.SQLParserException;
import com.github.melin.superior.sql.parser.StatementType;
import com.github.melin.superior.sql.parser.antlr4.mysql.MySQLParser;
import com.github.melin.superior.sql.parser.antlr4.mysql.MySQLParserBaseVisitor;
import com.github.melin.superior.sql.parser.model.DcColumn;
import com.github.melin.superior.sql.parser.model.DcDatabase;
import com.github.melin.superior.sql.parser.model.DcRenameTable;
import com.github.melin.superior.sql.parser.model.DcTable;
import com.github.melin.superior.sql.parser.model.DeleteTable;
import com.github.melin.superior.sql.parser.model.StatementData;
import com.github.melin.superior.sql.parser.model.TableData;
import com.github.melin.superior.sql.parser.model.TableSource;
import com.github.melin.superior.sql.parser.model.TidbCreateTable;
import com.github.melin.superior.sql.parser.model.UpdateTable;
import com.github.melin.superior.sql.parser.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNodeImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0011\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\u000b0\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u001bH\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020)H\u0016J\u0012\u0010*\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020+H\u0016J\u0012\u0010,\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020/H\u0016J\u0012\u00100\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u000205H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/github/melin/superior/sql/parser/mysql/MySQLAntlr4Visitor;", "Lcom/github/melin/superior/sql/parser/antlr4/mysql/MySQLParserBaseVisitor;", "Lcom/github/melin/superior/sql/parser/model/StatementData;", "()V", "currentOptType", "Lcom/github/melin/superior/sql/parser/StatementType;", "limit", "", "Ljava/lang/Integer;", "primaries", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "statementData", "Lcom/github/melin/superior/sql/parser/model/TableData;", "tableSource", "Lcom/github/melin/superior/sql/parser/model/TableSource;", "parseFullId", "Lkotlin/Pair;", "fullId", "Lcom/github/melin/superior/sql/parser/antlr4/mysql/MySQLParser$FullIdContext;", "visitAlterByAddIndex", "ctx", "Lcom/github/melin/superior/sql/parser/antlr4/mysql/MySQLParser$AlterByAddIndexContext;", "visitAlterByAddUniqueKey", "Lcom/github/melin/superior/sql/parser/antlr4/mysql/MySQLParser$AlterByAddUniqueKeyContext;", "visitAlterByDropIndex", "Lcom/github/melin/superior/sql/parser/antlr4/mysql/MySQLParser$AlterByDropIndexContext;", "visitAlterTable", "Lcom/github/melin/superior/sql/parser/antlr4/mysql/MySQLParser$AlterTableContext;", "visitAnalyzeTable", "Lcom/github/melin/superior/sql/parser/antlr4/mysql/MySQLParser$AnalyzeTableContext;", "visitColumnCreateTable", "Lcom/github/melin/superior/sql/parser/antlr4/mysql/MySQLParser$ColumnCreateTableContext;", "visitCreateDatabase", "Lcom/github/melin/superior/sql/parser/antlr4/mysql/MySQLParser$CreateDatabaseContext;", "visitDmlStatement", "Lcom/github/melin/superior/sql/parser/antlr4/mysql/MySQLParser$DmlStatementContext;", "visitDropDatabase", "Lcom/github/melin/superior/sql/parser/antlr4/mysql/MySQLParser$DropDatabaseContext;", "visitDropTable", "Lcom/github/melin/superior/sql/parser/antlr4/mysql/MySQLParser$DropTableContext;", "visitLimitClause", "Lcom/github/melin/superior/sql/parser/antlr4/mysql/MySQLParser$LimitClauseContext;", "visitPrimaryKeyTableConstraint", "Lcom/github/melin/superior/sql/parser/antlr4/mysql/MySQLParser$PrimaryKeyTableConstraintContext;", "visitRenameTable", "Lcom/github/melin/superior/sql/parser/antlr4/mysql/MySQLParser$RenameTableContext;", "visitTableName", "Lcom/github/melin/superior/sql/parser/antlr4/mysql/MySQLParser$TableNameContext;", "visitTruncateTable", "Lcom/github/melin/superior/sql/parser/antlr4/mysql/MySQLParser$TruncateTableContext;", "visitUseStatement", "Lcom/github/melin/superior/sql/parser/antlr4/mysql/MySQLParser$UseStatementContext;", "superior-sql-parser"})
public final class MySQLAntlr4Visitor
extends MySQLParserBaseVisitor<StatementData> {
    @NotNull
    private StatementType currentOptType = StatementType.UNKOWN;
    @NotNull
    private final TableData statementData = new TableData(null, null, null, null, null, null, 63, null);
    @Nullable
    private TableSource tableSource;
    @Nullable
    private Integer limit;
    @NotNull
    private final ArrayList<String> primaries = new ArrayList();

    @Override
    @NotNull
    public StatementData visitCreateDatabase(@NotNull MySQLParser.CreateDatabaseContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        String databaseName = ctx.uid().getText();
        Intrinsics.checkNotNullExpressionValue((Object)databaseName, (String)"databaseName");
        DcDatabase sqlData = new DcDatabase(databaseName);
        return new StatementData(StatementType.CREATE_DATABASE, sqlData, null, null, 12, null);
    }

    @Override
    @NotNull
    public StatementData visitDropDatabase(@NotNull MySQLParser.DropDatabaseContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        String databaseName = ctx.uid().getText();
        Intrinsics.checkNotNullExpressionValue((Object)databaseName, (String)"databaseName");
        DcDatabase sqlData = new DcDatabase(databaseName);
        return new StatementData(StatementType.DROP_DATABASE, sqlData, null, null, 12, null);
    }

    @Override
    @NotNull
    public StatementData visitColumnCreateTable(@NotNull MySQLParser.ColumnCreateTableContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        MySQLParser.FullIdContext fullIdContext = ctx.tableName().fullId();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)fullIdContext), (String)"ctx.tableName().fullId()");
        Pair<String, String> pair = this.parseFullId(fullIdContext);
        String databaseName = (String)pair.component1();
        String tableName = (String)pair.component2();
        String comment = null;
        List<MySQLParser.TableOptionContext> list = ctx.tableOption();
        Intrinsics.checkNotNullExpressionValue(list, (String)"ctx.tableOption()");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MySQLParser.TableOptionContext it = (MySQLParser.TableOptionContext)((Object)element$iv);
            boolean bl = false;
            if (!(it instanceof MySQLParser.TableOptionCommentContext)) continue;
            String string = ((MySQLParser.TableOptionCommentContext)it).STRING_LITERAL().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.STRING_LITERAL().text");
            comment = StringUtil.INSTANCE.cleanQuote(string);
        }
        ArrayList<DcColumn> columns = new ArrayList<DcColumn>();
        ArrayList uniques = new ArrayList();
        HashMap properties = new HashMap();
        List list2 = ctx.createDefinitions().children;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"ctx.createDefinitions().children");
        Iterable $this$forEach$iv2 = list2;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            ParseTree column = (ParseTree)element$iv;
            boolean bl = false;
            if (column instanceof MySQLParser.ColumnDeclarationContext) {
                String dataType;
                ParseTree item;
                String name = StringUtil.INSTANCE.cleanBackQuote(((MySQLParser.ColumnDeclarationContext)column).uid().getText());
                String string = ((MySQLParser.ColumnDeclarationContext)column).columnDefinition().dataType().getChild(0).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"column.columnDefinition(\u2026taType().getChild(0).text");
                Intrinsics.checkNotNullExpressionValue((Object)string.toLowerCase(), (String)"this as java.lang.String).toLowerCase()");
                int count = ((MySQLParser.ColumnDeclarationContext)column).columnDefinition().dataType().getChildCount();
                if (count > 1 && ((item = ((MySQLParser.ColumnDeclarationContext)column).columnDefinition().dataType().getChild(1)) instanceof MySQLParser.LengthOneDimensionContext || item instanceof MySQLParser.LengthTwoDimensionContext || item instanceof MySQLParser.LengthTwoOptionalDimensionContext)) {
                    dataType = dataType + item.getText();
                }
                String colComment = null;
                List<MySQLParser.ColumnConstraintContext> list3 = ((MySQLParser.ColumnDeclarationContext)column).columnDefinition().columnConstraint();
                Intrinsics.checkNotNullExpressionValue(list3, (String)"column.columnDefinition().columnConstraint()");
                Iterable $this$forEach$iv3 = list3;
                boolean $i$f$forEach3 = false;
                for (Object element$iv2 : $this$forEach$iv3) {
                    MySQLParser.ColumnConstraintContext it = (MySQLParser.ColumnConstraintContext)((Object)element$iv2);
                    boolean bl2 = false;
                    if (!(it instanceof MySQLParser.CommentColumnConstraintContext)) continue;
                    String string2 = ((MySQLParser.CommentColumnConstraintContext)it).STRING_LITERAL().getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.STRING_LITERAL().text");
                    colComment = StringUtil.INSTANCE.cleanQuote(string2);
                }
                columns.add(new DcColumn(name, dataType, colComment));
                continue;
            }
            if (!(column instanceof MySQLParser.ConstraintDeclarationContext)) continue;
        }
        boolean ifNotExists = ctx.ifNotExists() != null;
        TidbCreateTable sqlData = new TidbCreateTable(databaseName, tableName, comment, (List<DcColumn>)columns, (List<String>)this.primaries, uniques, properties, ifNotExists);
        super.visitColumnCreateTable(ctx);
        return new StatementData(StatementType.CREATE_TABLE, sqlData, null, null, 12, null);
    }

    @Override
    @Nullable
    public StatementData visitPrimaryKeyTableConstraint(@NotNull MySQLParser.PrimaryKeyTableConstraintContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        int count = ctx.indexColumnNames().getChildCount();
        int i = 1;
        int n = count - 2;
        if (i <= n) {
            while (true) {
                String column = ctx.indexColumnNames().getChild(i).getText();
                column = StringUtil.INSTANCE.cleanBackQuote(column);
                this.primaries.add(column);
                if (i == n) break;
                ++i;
            }
        }
        return null;
    }

    @Override
    @NotNull
    public StatementData visitDropTable(@NotNull MySQLParser.DropTableContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        if (ctx.tables().tableName().size() > 1) {
            throw new SQLParserException("\u4e0d\u652f\u6301drop\u591a\u4e2a\u8868");
        }
        MySQLParser.FullIdContext fullIdContext = ctx.tables().tableName(0).fullId();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)fullIdContext), (String)"ctx.tables().tableName(0).fullId()");
        Pair<String, String> pair = this.parseFullId(fullIdContext);
        String databaseName = (String)pair.component1();
        String tableName = (String)pair.component2();
        DcTable dcTable = new DcTable(null, databaseName, tableName);
        dcTable.setIfExists(ctx.ifExists() != null);
        return new StatementData(StatementType.DROP_TABLE_TIDB, dcTable, null, null, 12, null);
    }

    @Override
    @NotNull
    public StatementData visitTruncateTable(@NotNull MySQLParser.TruncateTableContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        MySQLParser.FullIdContext fullIdContext = ctx.tableName().fullId();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)fullIdContext), (String)"ctx.tableName().fullId()");
        Pair<String, String> pair = this.parseFullId(fullIdContext);
        String databaseName = (String)pair.component1();
        String tableName = (String)pair.component2();
        DcTable dcTable = new DcTable(null, databaseName, tableName);
        return new StatementData(StatementType.TRUNCATE_TABLE, dcTable, null, null, 12, null);
    }

    @Override
    @NotNull
    public StatementData visitRenameTable(@NotNull MySQLParser.RenameTableContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        MySQLParser.FullIdContext fullIdContext = ctx.renameTableClause().get(0).tableName(0).fullId();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)fullIdContext), (String)"ctx.renameTableClause().\u2026(0).tableName(0).fullId()");
        Pair<String, String> pair = this.parseFullId(fullIdContext);
        String databaseName = (String)pair.component1();
        String oldTableName = (String)pair.component2();
        MySQLParser.FullIdContext fullIdContext2 = ctx.renameTableClause().get(0).tableName(1).fullId();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)fullIdContext2), (String)"ctx.renameTableClause().\u2026(0).tableName(1).fullId()");
        String newTableName = (String)this.parseFullId(fullIdContext2).component2();
        DcRenameTable renameTable = new DcRenameTable(null, databaseName, oldTableName, newTableName);
        return new StatementData(StatementType.RENAME_TABLE, renameTable, null, null, 12, null);
    }

    @Override
    @NotNull
    public StatementData visitUseStatement(@NotNull MySQLParser.UseStatementContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        String databaseName = ctx.uid().getText();
        Intrinsics.checkNotNullExpressionValue((Object)databaseName, (String)"databaseName");
        DcDatabase data = new DcDatabase(databaseName);
        return new StatementData(StatementType.USE, data, null, null, 12, null);
    }

    @Override
    @Nullable
    public StatementData visitAlterTable(@NotNull MySQLParser.AlterTableContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        if (ctx.getChildCount() > 4) {
            throw new SQLParserException("\u4e0d\u5141\u8bb8\u540c\u65f6\u6267\u884c\u591a\u4e2aalter");
        }
        ParseTree statement = ctx.getChild(3);
        if (statement instanceof MySQLParser.AlterByChangeColumnContext) {
            MySQLParser.FullIdContext fullIdContext = ctx.tableName().fullId();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)fullIdContext), (String)"ctx.tableName().fullId()");
            Pair<String, String> pair = this.parseFullId(fullIdContext);
            String databaseName = (String)pair.component1();
            String tableName = (String)pair.component2();
            TableSource tableSource = new TableSource(databaseName, tableName);
            String oldColumn = StringUtil.INSTANCE.cleanBackQuote(((MySQLParser.AlterByChangeColumnContext)statement).oldColumn.getText());
            String newColumn = StringUtil.INSTANCE.cleanBackQuote(((MySQLParser.AlterByChangeColumnContext)statement).newColumn.getText());
            String dataType = ((MySQLParser.AlterByChangeColumnContext)statement).columnDefinition().dataType().getText();
            String comment = null;
            List list = ((MySQLParser.AlterByChangeColumnContext)statement).columnDefinition().children;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"statement.columnDefinition().children");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ParseTree it = (ParseTree)element$iv;
                boolean bl = false;
                if (!(it instanceof MySQLParser.CommentColumnConstraintContext)) continue;
                String string = ((MySQLParser.CommentColumnConstraintContext)it).STRING_LITERAL().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.STRING_LITERAL().text");
                comment = StringUtil.INSTANCE.cleanQuote(string);
            }
            DcColumn column = new DcColumn(newColumn, dataType, comment, oldColumn, null, null, 48, null);
            tableSource.setColumn(column);
            return new StatementData(StatementType.ALTER_TABLE_CHANGE_COL, tableSource, null, null, 12, null);
        }
        if (statement instanceof MySQLParser.AlterByAddColumnContext) {
            MySQLParser.FullIdContext fullIdContext = ctx.tableName().fullId();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)fullIdContext), (String)"ctx.tableName().fullId()");
            Pair<String, String> pair = this.parseFullId(fullIdContext);
            String databaseName = (String)pair.component1();
            String tableName = (String)pair.component2();
            TableSource tableSource = new TableSource(databaseName, tableName);
            String name = StringUtil.INSTANCE.cleanBackQuote(((MySQLParser.AlterByAddColumnContext)statement).uid().get(0).getText());
            String dataType = ((MySQLParser.AlterByAddColumnContext)statement).columnDefinition().dataType().getText();
            String comment = null;
            List list = ((MySQLParser.AlterByAddColumnContext)statement).columnDefinition().children;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"statement.columnDefinition().children");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ParseTree it = (ParseTree)element$iv;
                boolean bl = false;
                if (!(it instanceof MySQLParser.CommentColumnConstraintContext)) continue;
                String string = ((MySQLParser.CommentColumnConstraintContext)it).STRING_LITERAL().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.STRING_LITERAL().text");
                comment = StringUtil.INSTANCE.cleanQuote(string);
            }
            DcColumn column = new DcColumn(name, dataType, comment);
            tableSource.setColumn(column);
            return new StatementData(StatementType.ALTER_TABLE_ADD_COL, tableSource, null, null, 12, null);
        }
        if (statement instanceof MySQLParser.AlterByDropColumnContext) {
            MySQLParser.FullIdContext fullIdContext = ctx.tableName().fullId();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)fullIdContext), (String)"ctx.tableName().fullId()");
            Pair<String, String> pair = this.parseFullId(fullIdContext);
            String databaseName = (String)pair.component1();
            String tableName = (String)pair.component2();
            TableSource tableSource = new TableSource(databaseName, tableName);
            String name = StringUtil.INSTANCE.cleanBackQuote(((MySQLParser.AlterByDropColumnContext)statement).uid().getText());
            DcColumn column = new DcColumn(name, null, null, null, null, null, 62, null);
            tableSource.setColumn(column);
            return new StatementData(StatementType.ALTER_TABLE_DROP_COL, tableSource, null, null, 12, null);
        }
        if (statement instanceof MySQLParser.AlterByModifyColumnContext) {
            MySQLParser.FullIdContext fullIdContext = ctx.tableName().fullId();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)fullIdContext), (String)"ctx.tableName().fullId()");
            Pair<String, String> pair = this.parseFullId(fullIdContext);
            String databaseName = (String)pair.component1();
            String tableName = (String)pair.component2();
            TableSource tableSource = new TableSource(databaseName, tableName);
            String name = StringUtil.INSTANCE.cleanBackQuote(((MySQLParser.AlterByModifyColumnContext)statement).uid().get(0).getText());
            String dataType = ((MySQLParser.AlterByModifyColumnContext)statement).columnDefinition().dataType().getText();
            DcColumn column = new DcColumn(name, dataType, null, null, null, null, 60, null);
            tableSource.setColumn(column);
            return new StatementData(StatementType.ALTER_TABLE_MODIFY_COL, tableSource, null, null, 12, null);
        }
        return (StatementData)super.visitAlterTable(ctx);
    }

    @Override
    @NotNull
    public StatementData visitAlterByAddIndex(@NotNull MySQLParser.AlterByAddIndexContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        this.currentOptType = StatementType.ALTER_TABLE_ADD_INDEX;
        super.visitAlterByAddIndex(ctx);
        return new StatementData(this.currentOptType, this.tableSource, null, null, 12, null);
    }

    @Override
    @NotNull
    public StatementData visitAlterByDropIndex(@NotNull MySQLParser.AlterByDropIndexContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        this.currentOptType = StatementType.ALTER_TABLE_DROP_INDEX;
        super.visitAlterByDropIndex(ctx);
        return new StatementData(this.currentOptType, this.tableSource, null, null, 12, null);
    }

    @Override
    @NotNull
    public StatementData visitAlterByAddUniqueKey(@NotNull MySQLParser.AlterByAddUniqueKeyContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        this.currentOptType = StatementType.ALTER_TABLE_ADD_UNIQUE_KEY;
        super.visitAlterByAddUniqueKey(ctx);
        return new StatementData(this.currentOptType, this.tableSource, null, null, 12, null);
    }

    @Override
    @NotNull
    public StatementData visitAnalyzeTable(@NotNull MySQLParser.AnalyzeTableContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        ArrayList<TableSource> tables = new ArrayList<TableSource>();
        List<MySQLParser.TableNameContext> list = ctx.tables().tableName();
        Intrinsics.checkNotNullExpressionValue(list, (String)"ctx.tables().tableName()");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MySQLParser.TableNameContext context = (MySQLParser.TableNameContext)((Object)element$iv);
            boolean bl = false;
            MySQLParser.FullIdContext fullIdContext = context.fullId();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)fullIdContext), (String)"context.fullId()");
            Pair<String, String> pair = this.parseFullId(fullIdContext);
            String databaseName = (String)pair.component1();
            String tableName = (String)pair.component2();
            tables.add(new TableSource(databaseName, tableName));
        }
        return new StatementData(StatementType.ANALYZE_TABLE, new TableData(tables, null, null, null, null, null, 62, null), null, null, 12, null);
    }

    @Override
    @NotNull
    public StatementData visitDmlStatement(@NotNull MySQLParser.DmlStatementContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        if (ctx.selectStatement() != null) {
            this.currentOptType = StatementType.SELECT;
            super.visitDmlStatement(ctx);
            this.statementData.setLimit(this.limit);
            return new StatementData(StatementType.SELECT, this.statementData, null, null, 12, null);
        }
        if (ctx.insertStatement() != null) {
            MySQLParser.InsertStatementContext statement = ctx.insertStatement();
            MySQLParser.FullIdContext fullIdContext = statement.tableName().fullId();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)fullIdContext), (String)"statement.tableName().fullId()");
            Pair<String, String> pair = this.parseFullId(fullIdContext);
            String databaseName = (String)pair.component1();
            String tableName = (String)pair.component2();
            TableSource tableSource = new TableSource(databaseName, tableName);
            this.statementData.getOutpuTables().add(tableSource);
            if (statement.insertStatementValue().selectStatement() != null) {
                this.currentOptType = StatementType.INSERT_SELECT;
                super.visit((ParseTree)ctx.insertStatement().insertStatementValue().selectStatement());
                return new StatementData(StatementType.INSERT_SELECT, this.statementData, null, null, 12, null);
            }
            this.currentOptType = StatementType.INSERT_VALUES;
            return new StatementData(StatementType.INSERT_VALUES, this.statementData, null, null, 12, null);
        }
        if (ctx.updateStatement() != null) {
            MySQLParser.UpdateStatementContext statement = ctx.updateStatement();
            if (statement.multipleUpdateStatement() != null) {
                throw new SQLParserException("\u4e0d\u652f\u6301\u66f4\u65b0\u591a\u4e2a\u8868");
            }
            MySQLParser.FullIdContext fullIdContext = ctx.updateStatement().singleUpdateStatement().tableName().fullId();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)fullIdContext), (String)"ctx.updateStatement().si\u2026nt().tableName().fullId()");
            Pair<String, String> pair = this.parseFullId(fullIdContext);
            String databaseName = (String)pair.component1();
            String tableName = (String)pair.component2();
            UpdateTable tableSource = new UpdateTable(null, databaseName, tableName, null, null, 24, null);
            return new StatementData(StatementType.UPDATE, tableSource, null, null, 12, null);
        }
        if (ctx.deleteStatement() != null) {
            MySQLParser.DeleteStatementContext statement = ctx.deleteStatement();
            if (statement.multipleDeleteStatement() != null) {
                throw new SQLParserException("\u4e0d\u652f\u6301\u5220\u9664\u591a\u4e2a\u8868");
            }
            MySQLParser.FullIdContext fullIdContext = ctx.deleteStatement().singleDeleteStatement().tableName().fullId();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)fullIdContext), (String)"ctx.deleteStatement().si\u2026nt().tableName().fullId()");
            Pair<String, String> pair = this.parseFullId(fullIdContext);
            String databaseName = (String)pair.component1();
            String tableName = (String)pair.component2();
            DeleteTable tableSource = new DeleteTable(null, databaseName, tableName, null, 8, null);
            return new StatementData(StatementType.DELETE, tableSource, null, null, 12, null);
        }
        throw new SQLParserException("\u4e0d\u652f\u6301\u7684DML");
    }

    @Override
    @Nullable
    public StatementData visitTableName(@NotNull MySQLParser.TableNameContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        if (StatementType.SELECT == this.currentOptType || StatementType.INSERT_SELECT == this.currentOptType || this.currentOptType == StatementType.ALTER_TABLE_RENAME) {
            MySQLParser.FullIdContext fullIdContext = ctx.fullId();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)fullIdContext), (String)"ctx.fullId()");
            Pair<String, String> pair = this.parseFullId(fullIdContext);
            String databaseName = (String)pair.component1();
            String tableName = (String)pair.component2();
            TableSource tableSource = new TableSource(databaseName, tableName);
            this.statementData.getInputTables().add(tableSource);
        } else if (StatementType.ALTER_TABLE_ADD_INDEX == this.currentOptType || StatementType.ALTER_TABLE_DROP_INDEX == this.currentOptType || StatementType.ALTER_TABLE_ADD_UNIQUE_KEY == this.currentOptType || StatementType.ALTER_TABLE_ADD_PRIMARY_KEY == this.currentOptType) {
            MySQLParser.FullIdContext fullIdContext = ctx.fullId();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)fullIdContext), (String)"ctx.fullId()");
            Pair<String, String> pair = this.parseFullId(fullIdContext);
            String databaseName = (String)pair.component1();
            String tableName = (String)pair.component2();
            this.tableSource = new TableSource(databaseName, tableName);
        }
        return null;
    }

    @Override
    @Nullable
    public StatementData visitLimitClause(@NotNull MySQLParser.LimitClauseContext ctx) {
        TableData _sqlData;
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        if (this.currentOptType == StatementType.SELECT && (_sqlData = this.statementData) instanceof TableData) {
            String string = ctx.limit.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ctx.limit.text");
            this.limit = Integer.parseInt(string);
        }
        return null;
    }

    private final Pair<String, String> parseFullId(MySQLParser.FullIdContext fullId) {
        String databaseName = null;
        String tableName = "";
        if (fullId.getChildCount() == 2) {
            databaseName = fullId.uid().get(0).getText();
            ParseTree parseTree = fullId.getChild(1);
            if (parseTree == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.antlr.v4.runtime.tree.TerminalNodeImpl");
            }
            String string = ((TerminalNodeImpl)parseTree).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fullId.getChild(1) as TerminalNodeImpl).text");
            String string2 = string;
            int n = 1;
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            tableName = string3;
        } else if (fullId.getChildCount() == 3) {
            databaseName = StringUtil.INSTANCE.cleanBackQuote(fullId.uid().get(0).getText());
            ParseTree parseTree = fullId.getChild(2);
            if (parseTree == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.github.melin.superior.sql.parser.antlr4.mysql.MySQLParser.UidContext");
            }
            tableName = StringUtil.INSTANCE.cleanBackQuote(((MySQLParser.UidContext)parseTree).getText());
        } else {
            String string = fullId.uid().get(0).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fullId.uid().get(0).text");
            tableName = string;
        }
        if (databaseName != null) {
            databaseName = StringUtil.INSTANCE.cleanBackQuote(databaseName);
        }
        if (tableName != null) {
            tableName = StringUtil.INSTANCE.cleanBackQuote(tableName);
        }
        return new Pair((Object)databaseName, (Object)tableName);
    }
}

