/*
 * Decompiled with CFR 0.152.
 */
package com.github.melin.superior.sql.parser.mysql;

import com.github.melin.superior.sql.parser.StatementType;
import com.github.melin.superior.sql.parser.antlr4.ParseErrorListener;
import com.github.melin.superior.sql.parser.antlr4.ParseException;
import com.github.melin.superior.sql.parser.antlr4.UpperCaseCharStream;
import com.github.melin.superior.sql.parser.antlr4.mysql.MySQLLexer;
import com.github.melin.superior.sql.parser.antlr4.mysql.MySQLParser;
import com.github.melin.superior.sql.parser.model.StatementData;
import com.github.melin.superior.sql.parser.mysql.MySQLAntlr4Visitor;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNodeImpl;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\r\u001a\u00020\nH\u0007\u00a8\u0006\u000e"}, d2={"Lcom/github/melin/superior/sql/parser/mysql/MySQLHelper;", "", "()V", "checkSupportedSQL", "", "statementType", "Lcom/github/melin/superior/sql/parser/StatementType;", "getStatementData", "Lcom/github/melin/superior/sql/parser/model/StatementData;", "command", "", "splitAlterSql", "", "sql", "superior-sql-parser"})
public final class MySQLHelper {
    @NotNull
    public static final MySQLHelper INSTANCE = new MySQLHelper();

    private MySQLHelper() {
    }

    @JvmStatic
    public static final boolean checkSupportedSQL(@Nullable StatementType statementType) {
        boolean bl;
        StatementType statementType2 = statementType;
        switch (statementType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[statementType2.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @JvmStatic
    @NotNull
    public static final StatementData getStatementData(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        String trimCmd = StringUtils.trim((String)command);
        if (StringUtils.startsWithIgnoreCase((CharSequence)trimCmd, (CharSequence)"show")) {
            return new StatementData(StatementType.SHOW, null, null, null, 12, null);
        }
        UpperCaseCharStream charStream = new UpperCaseCharStream(CharStreams.fromString((String)trimCmd));
        MySQLLexer lexer = new MySQLLexer(charStream);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)new ParseErrorListener());
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        MySQLParser parser = new MySQLParser((TokenStream)tokenStream);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new ParseErrorListener());
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
        MySQLAntlr4Visitor sqlVisitor = new MySQLAntlr4Visitor();
        try {
            try {
                StatementData data = (StatementData)sqlVisitor.visit((ParseTree)parser.sqlStatement());
                if (data == null) {
                    return new StatementData(StatementType.UNKOWN);
                }
                return data;
            }
            catch (ParseCancellationException e) {
                tokenStream.seek(0);
                parser.reset();
                ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
                StatementData data = (StatementData)sqlVisitor.visit((ParseTree)parser.sqlStatement());
                if (data == null) {
                    return new StatementData(StatementType.UNKOWN);
                }
                return data;
            }
        }
        catch (ParseException e) {
            if (StringUtils.isNotBlank((CharSequence)e.getCommand())) {
                throw e;
            }
            ParseException parseException = e.withCommand(trimCmd);
            Intrinsics.checkNotNullExpressionValue((Object)parseException, (String)"e.withCommand(trimCmd)");
            throw (Throwable)parseException;
        }
    }

    @JvmStatic
    @NotNull
    public static final List<String> splitAlterSql(@NotNull String sql) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        List _items = new ArrayList();
        UpperCaseCharStream charStream = new UpperCaseCharStream(CharStreams.fromString((String)sql));
        MySQLLexer lexer = new MySQLLexer(charStream);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)new ParseErrorListener());
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        MySQLParser parser = new MySQLParser((TokenStream)tokens);
        ParseTree statement = parser.sqlStatement().getChild(0).getChild(0);
        if (statement instanceof MySQLParser.AlterTableContext) {
            ParseTree parseTree = statement.getChild(2);
            if (parseTree == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.github.melin.superior.sql.parser.antlr4.mysql.MySQLParser.TableNameContext");
            }
            MySQLParser.TableNameContext tableNameContext = (MySQLParser.TableNameContext)parseTree;
            int stopIndex = tableNameContext.stop.getStopIndex();
            String alterSqlPrefix = StringUtils.substring((String)sql, (int)0, (int)(stopIndex + 1));
            ParseTree childStat = statement.getChild(3);
            if (childStat instanceof MySQLParser.AlterByAddColumnsContext) {
                TerminalNodeImpl node;
                int n;
                ParseTree child = childStat.getChild(2);
                if (child instanceof MySQLParser.UidContext) {
                    ParseTree rightNode = child.getChild(0);
                    if (rightNode instanceof TerminalNodeImpl) {
                        n = ((TerminalNodeImpl)rightNode).symbol.getStartIndex();
                    } else {
                        ParseTree childNode = rightNode.getChild(0);
                        if (childNode instanceof MySQLParser.EngineNameContext) {
                            n = ((MySQLParser.EngineNameContext)childNode).start.getStartIndex();
                        } else {
                            ParseTree parseTree2 = rightNode.getChild(0);
                            if (parseTree2 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.antlr.v4.runtime.tree.TerminalNodeImpl");
                            }
                            node = (TerminalNodeImpl)parseTree2;
                            n = node.symbol.getStartIndex();
                        }
                    }
                } else {
                    ParseTree parseTree3 = child;
                    if (parseTree3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.antlr.v4.runtime.tree.TerminalNodeImpl");
                    }
                    TerminalNodeImpl right = (TerminalNodeImpl)parseTree3;
                    n = right.symbol.getStartIndex() + 1;
                }
                int startIndex = n;
                int i = 3;
                int childNode = ((MySQLParser.AlterByAddColumnsContext)childStat).getChildCount();
                if (i <= childNode) {
                    while (true) {
                        if ((node = childStat.getChild(i)) instanceof TerminalNodeImpl && Intrinsics.areEqual((Object)",", (Object)node.getText())) {
                            String alterSql = StringUtils.substring((String)sql, (int)startIndex, (int)node.symbol.getStartIndex());
                            _items.add(alterSqlPrefix + " ADD COLUMN " + alterSql);
                            startIndex = node.symbol.getStartIndex() + 1;
                        }
                        if (i == childNode) break;
                        ++i;
                    }
                }
                String alterSql = StringUtils.substring((String)sql, (int)startIndex);
                alterSql = StringUtils.substringBeforeLast((String)alterSql, (String)")");
                _items.add(alterSqlPrefix + " ADD COLUMN " + alterSql);
            } else {
                int childCount = ((MySQLParser.AlterTableContext)statement).getChildCount();
                for (int index = 3; index < childCount; ++index) {
                    TerminalNodeImpl terminalNodeImpl;
                    ParseTree parseTree4 = statement.getChild(index);
                    if (parseTree4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.antlr.v4.runtime.ParserRuleContext");
                    }
                    ParserRuleContext startContext = (ParserRuleContext)parseTree4;
                    if (++index < childCount) {
                        ParseTree parseTree5 = statement.getChild(index);
                        if (parseTree5 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.antlr.v4.runtime.tree.TerminalNodeImpl");
                        }
                        terminalNodeImpl = (TerminalNodeImpl)parseTree5;
                    } else {
                        terminalNodeImpl = null;
                    }
                    TerminalNodeImpl stopContext = terminalNodeImpl;
                    int startIndex = startContext.start.getStartIndex();
                    TerminalNodeImpl terminalNodeImpl2 = stopContext;
                    int stopIndex2 = terminalNodeImpl2 != null ? terminalNodeImpl2.symbol.getStartIndex() : -1;
                    String sql2 = stopIndex2 > 0 ? StringUtils.substring((String)sql, (int)startIndex, (int)stopIndex2) : StringUtils.substring((String)sql, (int)startIndex);
                    sql2 = StringUtils.trim((String)sql2);
                    if (StringUtils.endsWith((CharSequence)sql2, (CharSequence)";")) {
                        sql2 = StringUtils.substring((String)sql2, (int)0, (int)-1);
                    }
                    _items.add(alterSqlPrefix + ' ' + sql2);
                }
            }
        }
        return CollectionsKt.toList((Iterable)_items);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StatementType.values().length];
            nArray[StatementType.CREATE_TABLE.ordinal()] = 1;
            nArray[StatementType.DROP_TABLE_TIDB.ordinal()] = 2;
            nArray[StatementType.TRUNCATE_TABLE.ordinal()] = 3;
            nArray[StatementType.RENAME_TABLE.ordinal()] = 4;
            nArray[StatementType.ALTER_TABLE_CHANGE_COL.ordinal()] = 5;
            nArray[StatementType.ALTER_TABLE_MODIFY_COL.ordinal()] = 6;
            nArray[StatementType.ALTER_TABLE_ADD_COL.ordinal()] = 7;
            nArray[StatementType.ALTER_TABLE_DROP_COL.ordinal()] = 8;
            nArray[StatementType.ALTER_TABLE_ADD_INDEX.ordinal()] = 9;
            nArray[StatementType.ALTER_TABLE_DROP_INDEX.ordinal()] = 10;
            nArray[StatementType.ALTER_TABLE_ADD_UNIQUE_KEY.ordinal()] = 11;
            nArray[StatementType.INSERT_SELECT.ordinal()] = 12;
            nArray[StatementType.INSERT_VALUES.ordinal()] = 13;
            nArray[StatementType.SELECT.ordinal()] = 14;
            nArray[StatementType.DELETE.ordinal()] = 15;
            nArray[StatementType.UPDATE.ordinal()] = 16;
            nArray[StatementType.ANALYZE_TABLE.ordinal()] = 17;
            nArray[StatementType.SHOW.ordinal()] = 18;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

