/*
 * Decompiled with CFR 0.152.
 */
package com.github.melin.superior.sql.parser.presto;

import com.github.melin.superior.sql.parser.SQLParserException;
import com.github.melin.superior.sql.parser.StatementType;
import com.github.melin.superior.sql.parser.antlr4.presto.PrestoSqlBaseBaseVisitor;
import com.github.melin.superior.sql.parser.antlr4.presto.PrestoSqlBaseParser;
import com.github.melin.superior.sql.parser.model.CommonToken;
import com.github.melin.superior.sql.parser.model.DcTable;
import com.github.melin.superior.sql.parser.model.StatementData;
import com.github.melin.superior.sql.parser.model.TableData;
import com.github.melin.superior.sql.parser.model.TableSource;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u0005J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00022\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\u001cH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\u001eH\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020!H\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020#H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/github/melin/superior/sql/parser/presto/PrestoSQLAntlr4Visitor;", "Lcom/github/melin/superior/sql/parser/antlr4/presto/PrestoSqlBaseBaseVisitor;", "Lcom/github/melin/superior/sql/parser/model/StatementData;", "()V", "command", "", "currentOptType", "Lcom/github/melin/superior/sql/parser/StatementType;", "data", "limit", "", "Ljava/lang/Integer;", "statementData", "Lcom/github/melin/superior/sql/parser/model/TableData;", "table", "Lcom/github/melin/superior/sql/parser/model/DcTable;", "createTableSource", "Lcom/github/melin/superior/sql/parser/model/TableSource;", "ctx", "Lcom/github/melin/superior/sql/parser/antlr4/presto/PrestoSqlBaseParser$QualifiedNameContext;", "setCommand", "", "visit", "tree", "Lorg/antlr/v4/runtime/tree/ParseTree;", "visitCreateTableAsSelect", "Lcom/github/melin/superior/sql/parser/antlr4/presto/PrestoSqlBaseParser$CreateTableAsSelectContext;", "visitDropTable", "Lcom/github/melin/superior/sql/parser/antlr4/presto/PrestoSqlBaseParser$DropTableContext;", "visitExplain", "Lcom/github/melin/superior/sql/parser/antlr4/presto/PrestoSqlBaseParser$ExplainContext;", "visitQualifiedName", "visitShowCreateTable", "Lcom/github/melin/superior/sql/parser/antlr4/presto/PrestoSqlBaseParser$ShowCreateTableContext;", "visitStatementDefault", "Lcom/github/melin/superior/sql/parser/antlr4/presto/PrestoSqlBaseParser$StatementDefaultContext;", "superior-sql-parser"})
public final class PrestoSQLAntlr4Visitor
extends PrestoSqlBaseBaseVisitor<StatementData> {
    @NotNull
    private StatementType currentOptType = StatementType.UNKOWN;
    @NotNull
    private final TableData statementData = new TableData(null, null, null, null, null, null, 63, null);
    @Nullable
    private DcTable table;
    @Nullable
    private Integer limit;
    @Nullable
    private String command;
    @Nullable
    private StatementData data;

    public final void setCommand(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this.command = command;
    }

    @Nullable
    public StatementData visit(@Nullable ParseTree tree) {
        super.visit(tree);
        if (this.data == null) {
            throw new SQLParserException("\u4e0d\u652f\u6301\u7684SQL");
        }
        return this.data;
    }

    @Override
    @Nullable
    public StatementData visitStatementDefault(@NotNull PrestoSqlBaseParser.StatementDefaultContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        if (StringUtils.equalsIgnoreCase((CharSequence)"select", (CharSequence)ctx.start.getText())) {
            this.currentOptType = StatementType.SELECT;
            super.visitQuery(ctx.query());
            Object object = ctx.query();
            this.statementData.setLimit(object != null && (object = object.queryNoWith()) != null && (object = object.limit) != null && (object = object.getText()) != null ? Integer.valueOf(Integer.parseInt((String)object)) : null);
            this.data = new StatementData(StatementType.SELECT, this.statementData, null, null, 12, null);
            return this.data;
        }
        return null;
    }

    @Override
    @Nullable
    public StatementData visitShowCreateTable(@NotNull PrestoSqlBaseParser.ShowCreateTableContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        PrestoSqlBaseParser.QualifiedNameContext qualifiedNameContext = ctx.qualifiedName();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)qualifiedNameContext), (String)"ctx.qualifiedName()");
        TableSource tableSource = this.createTableSource(qualifiedNameContext);
        DcTable dcTable = new DcTable(tableSource.getCatalogName(), tableSource.getDatabaseName(), tableSource.getTableName());
        this.data = new StatementData(StatementType.SHOW_CREATE_TABLE, dcTable, null, null, 12, null);
        return this.data;
    }

    @Override
    @Nullable
    public StatementData visitCreateTableAsSelect(@NotNull PrestoSqlBaseParser.CreateTableAsSelectContext ctx) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        this.currentOptType = StatementType.CREATE_TABLE_AS_SELECT;
        PrestoSqlBaseParser.QualifiedNameContext qualifiedNameContext = ctx.qualifiedName();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)qualifiedNameContext), (String)"ctx.qualifiedName()");
        TableSource tableSource = this.createTableSource(qualifiedNameContext);
        this.table = new DcTable(tableSource.getCatalogName(), tableSource.getDatabaseName(), tableSource.getTableName());
        String querySql = StringUtils.substring((String)this.command, (int)ctx.query().start.getStartIndex());
        if (StringUtils.startsWith((CharSequence)querySql, (CharSequence)"(") && StringUtils.endsWith((CharSequence)querySql, (CharSequence)")")) {
            querySql = StringUtils.substringBetween((String)querySql, (String)"(", (String)")");
        }
        DcTable dcTable = this.table;
        if (dcTable != null) {
            dcTable.setLifeCycle(7);
        }
        DcTable dcTable2 = this.table;
        if (dcTable2 != null) {
            dcTable2.setQuerySql(querySql);
        }
        this.statementData.setLimit((object = ctx.query()) != null && (object = object.queryNoWith()) != null && (object = object.limit) != null && (object = object.getText()) != null ? Integer.valueOf(Integer.parseInt((String)object)) : null);
        super.visitQuery(ctx.query());
        DcTable dcTable3 = this.table;
        if (dcTable3 != null) {
            dcTable3.setTableData(this.statementData);
        }
        this.data = new StatementData(StatementType.CREATE_TABLE_AS_SELECT, this.table, null, null, 12, null);
        return this.data;
    }

    @Override
    @Nullable
    public StatementData visitDropTable(@NotNull PrestoSqlBaseParser.DropTableContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        PrestoSqlBaseParser.QualifiedNameContext qualifiedNameContext = ctx.qualifiedName();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)qualifiedNameContext), (String)"ctx.qualifiedName()");
        TableSource tableSource = this.createTableSource(qualifiedNameContext);
        DcTable dcTable = new DcTable(tableSource.getCatalogName(), tableSource.getDatabaseName(), tableSource.getTableName());
        CommonToken token = new CommonToken(ctx.qualifiedName().start.getStartIndex(), ctx.qualifiedName().stop.getStopIndex());
        dcTable.setIfExists(ctx.EXISTS() != null);
        dcTable.setToken(token);
        this.data = new StatementData(StatementType.DROP_TABLE, dcTable, null, null, 12, null);
        return this.data;
    }

    @Override
    @Nullable
    public StatementData visitExplain(@NotNull PrestoSqlBaseParser.ExplainContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        this.data = new StatementData(StatementType.EXPLAIN);
        return this.data;
    }

    @Override
    @Nullable
    public StatementData visitQualifiedName(@NotNull PrestoSqlBaseParser.QualifiedNameContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        if (!(ctx.parent instanceof PrestoSqlBaseParser.TableNameContext)) {
            return null;
        }
        if (this.currentOptType == StatementType.SELECT) {
            TableSource tableSource = this.createTableSource(ctx);
            this.statementData.getInputTables().add(tableSource);
        } else if (this.currentOptType == StatementType.CREATE_TABLE_AS_SELECT) {
            TableSource tableSource = this.createTableSource(ctx);
            this.statementData.getInputTables().add(tableSource);
        }
        return null;
    }

    private final TableSource createTableSource(PrestoSqlBaseParser.QualifiedNameContext ctx) {
        String string;
        List<PrestoSqlBaseParser.IdentifierContext> list = ctx.identifier();
        String catalogName = null;
        String databaseName = null;
        if (list.size() == 1) {
            string = ctx.getText();
        } else if (list.size() == 2) {
            int index = StringUtils.lastIndexOf((CharSequence)ctx.getText(), (CharSequence)".");
            databaseName = StringUtils.substring((String)ctx.getText(), (int)0, (int)index);
            string = StringUtils.substring((String)ctx.getText(), (int)(index + 1));
        } else {
            String[] items = StringUtils.split((String)ctx.getText(), (String)".");
            catalogName = items[0];
            databaseName = items[1];
            string = items[2];
        }
        String tableName = string;
        Intrinsics.checkNotNullExpressionValue((Object)tableName, (String)"tableName");
        return new TableSource(catalogName, databaseName, tableName);
    }
}

