/*
 * Decompiled with CFR 0.152.
 */
package com.github.melin.superior.sql.parser.spark;

import com.github.melin.superior.sql.parser.StatementType;
import com.github.melin.superior.sql.parser.antlr4.ParseErrorListener;
import com.github.melin.superior.sql.parser.antlr4.ParseException;
import com.github.melin.superior.sql.parser.antlr4.PostProcessor;
import com.github.melin.superior.sql.parser.antlr4.UpperCaseCharStream;
import com.github.melin.superior.sql.parser.antlr4.spark.SparkSqlBaseLexer;
import com.github.melin.superior.sql.parser.antlr4.spark.SparkSqlBaseParser;
import com.github.melin.superior.sql.parser.model.CommonToken;
import com.github.melin.superior.sql.parser.model.DcAlterColumn;
import com.github.melin.superior.sql.parser.model.DcRenameTable;
import com.github.melin.superior.sql.parser.model.DcTable;
import com.github.melin.superior.sql.parser.model.Statement;
import com.github.melin.superior.sql.parser.model.StatementData;
import com.github.melin.superior.sql.parser.model.TableData;
import com.github.melin.superior.sql.parser.model.TableSource;
import com.github.melin.superior.sql.parser.spark.SparkSQLAntlr4Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J.\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\n2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0010H\u0002J \u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0007J$\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\b2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0010H\u0007J \u0010\u0011\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0007J$\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0010H\u0007\u00a8\u0006\u0015"}, d2={"Lcom/github/melin/superior/sql/parser/spark/SparkSQLHelper;", "", "()V", "checkSupportedSQL", "", "statementType", "Lcom/github/melin/superior/sql/parser/StatementType;", "getStatementData", "Lcom/github/melin/superior/sql/parser/model/StatementData;", "command", "", "innerReplaceSql", "token", "Lcom/github/melin/superior/sql/parser/model/CommonToken;", "sql", "tables", "", "replaceSql", "statementData", "oldTable", "newTable", "superior-sql-parser"})
public final class SparkSQLHelper {
    @NotNull
    public static final SparkSQLHelper INSTANCE = new SparkSQLHelper();

    private SparkSQLHelper() {
    }

    @JvmStatic
    public static final boolean checkSupportedSQL(@NotNull StatementType statementType) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)statementType, (String)"statementType");
        switch (WhenMappings.$EnumSwitchMapping$0[statementType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @JvmStatic
    @NotNull
    public static final StatementData getStatementData(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        String trimCmd = StringUtils.trim((String)command);
        UpperCaseCharStream charStream = new UpperCaseCharStream(CharStreams.fromString((String)trimCmd));
        SparkSqlBaseLexer lexer = new SparkSqlBaseLexer(charStream);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)new ParseErrorListener());
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        SparkSqlBaseParser parser = new SparkSqlBaseParser((TokenStream)tokenStream);
        parser.addParseListener(new PostProcessor());
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new ParseErrorListener());
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        SparkSQLAntlr4Visitor sqlVisitor = new SparkSQLAntlr4Visitor();
        Intrinsics.checkNotNullExpressionValue((Object)trimCmd, (String)"trimCmd");
        sqlVisitor.setCommand(trimCmd);
        try {
            try {
                Object object = sqlVisitor.visit((ParseTree)parser.singleStatement());
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sqlVisitor.visit(parser.singleStatement())");
                return (StatementData)object;
            }
            catch (ParseCancellationException e) {
                tokenStream.seek(0);
                parser.reset();
                ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
                Object object = sqlVisitor.visit((ParseTree)parser.statement());
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sqlVisitor.visit(parser.statement())");
                return (StatementData)object;
            }
        }
        catch (ParseException e) {
            if (StringUtils.isNotBlank((CharSequence)e.getCommand())) {
                throw e;
            }
            ParseException parseException = e.withCommand(trimCmd);
            Intrinsics.checkNotNullExpressionValue((Object)parseException, (String)"e.withCommand(trimCmd)");
            throw (Throwable)parseException;
        }
    }

    @JvmStatic
    @NotNull
    public static final String replaceSql(@NotNull String sql, @NotNull String oldTable, @NotNull String newTable) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        Intrinsics.checkNotNullParameter((Object)oldTable, (String)"oldTable");
        Intrinsics.checkNotNullParameter((Object)newTable, (String)"newTable");
        StatementData statementData = SparkSQLHelper.getStatementData(sql);
        statementData.setQuerySql(sql);
        return SparkSQLHelper.replaceSql(statementData, (Map<String, String>)MapsKt.mapOf((Pair)TuplesKt.to((Object)oldTable, (Object)newTable)));
    }

    @JvmStatic
    @NotNull
    public static final String replaceSql(@NotNull StatementData statementData, @NotNull String oldTable, @NotNull String newTable) {
        Intrinsics.checkNotNullParameter((Object)statementData, (String)"statementData");
        Intrinsics.checkNotNullParameter((Object)oldTable, (String)"oldTable");
        Intrinsics.checkNotNullParameter((Object)newTable, (String)"newTable");
        return SparkSQLHelper.replaceSql(statementData, (Map<String, String>)MapsKt.mapOf((Pair)TuplesKt.to((Object)oldTable, (Object)newTable)));
    }

    @JvmStatic
    @NotNull
    public static final String replaceSql(@NotNull String sql, @NotNull Map<String, String> tables) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        Intrinsics.checkNotNullParameter(tables, (String)"tables");
        StatementData statementData = SparkSQLHelper.getStatementData(sql);
        statementData.setQuerySql(sql);
        return SparkSQLHelper.replaceSql(statementData, tables);
    }

    @JvmStatic
    @NotNull
    public static final String replaceSql(@NotNull StatementData statementData, @NotNull Map<String, String> tables) {
        Intrinsics.checkNotNullParameter((Object)statementData, (String)"statementData");
        Intrinsics.checkNotNullParameter(tables, (String)"tables");
        Statement statement = statementData.getStatement();
        StatementType sqlType = statementData.getType();
        String string = statementData.getQuerySql();
        if (string == null) {
            return "";
        }
        String sql = string;
        if (statement instanceof TableData && (StatementType.SELECT == sqlType || StatementType.INSERT_VALUES == sqlType || StatementType.INSERT_SELECT == sqlType)) {
            ArrayList tokens = new ArrayList();
            for (TableSource tableSource : CollectionsKt.plus((Collection)((TableData)statement).getOutpuTables(), (Iterable)((TableData)statement).getInputTables())) {
                if (!tables.containsKey(tableSource.getFullTableName())) continue;
                tokens.addAll(tableSource.getTokens());
            }
            List $this$sortBy$iv = tokens;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        CommonToken it = (CommonToken)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getStart());
                        it = (CommonToken)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStart()));
                    }
                });
            }
            CollectionsKt.reverse((List)tokens);
            for (CommonToken token : tokens) {
                sql = INSTANCE.innerReplaceSql(token, sql, tables);
            }
            return sql;
        }
        if (statement instanceof DcTable && StatementType.CREATE_TABLE_AS_SELECT == sqlType) {
            ArrayList tokens = new ArrayList();
            TableData tableData = ((DcTable)statement).getTableData();
            if (tableData != null) {
                for (TableSource tableSource : tableData.getInputTables()) {
                    if (!tables.containsKey(tableSource.getFullTableName())) continue;
                    tokens.addAll(tableSource.getTokens());
                }
                List $this$sortBy$iv = tokens;
                boolean $i$f$sortBy = false;
                if ($this$sortBy$iv.size() > 1) {
                    CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            CommonToken it = (CommonToken)a;
                            boolean bl = false;
                            Comparable comparable = Integer.valueOf(it.getStart());
                            it = (CommonToken)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStart()));
                        }
                    });
                }
                CollectionsKt.reverse((List)tokens);
                for (CommonToken token : tokens) {
                    sql = INSTANCE.innerReplaceSql(token, sql, tables);
                }
            }
            return sql;
        }
        if (statement instanceof DcTable && (StatementType.DROP_TABLE == sqlType || StatementType.ALTER_TABLE_ADD_COLS == sqlType || StatementType.ALTER_TABLE_ADD_COL == sqlType)) {
            CommonToken token = ((DcTable)statement).getToken();
            sql = INSTANCE.innerReplaceSql(token, sql, tables);
            return sql;
        }
        if (statement instanceof DcAlterColumn && (StatementType.ALTER_TABLE_RENAME_COL == sqlType || StatementType.ALTER_TABLE_CHANGE_COL == sqlType || StatementType.ALTER_TABLE_DROP_COL == sqlType)) {
            CommonToken token = ((DcAlterColumn)statement).getToken();
            sql = INSTANCE.innerReplaceSql(token, sql, tables);
            return sql;
        }
        if (statement instanceof DcRenameTable && StatementType.DROP_TABLE == sqlType) {
            CommonToken token = ((DcRenameTable)statement).getNewToken();
            sql = INSTANCE.innerReplaceSql(token, sql, tables);
            token = ((DcRenameTable)statement).getOldToken();
            sql = INSTANCE.innerReplaceSql(token, sql, tables);
            return sql;
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301sql \u7c7b\u578b: " + statementData.getType());
    }

    private final String innerReplaceSql(CommonToken token, String sql, Map<String, String> tables) {
        String newsql = sql;
        if (token != null) {
            String tableName = StringUtils.substring((String)sql, (int)token.getStart(), (int)(token.getStop() + 1));
            newsql = StringUtils.substring((String)sql, (int)0, (int)token.getStart()) + tables.get(tableName) + StringUtils.substring((String)sql, (int)(token.getStop() + 1));
        }
        return newsql;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StatementType.values().length];
            nArray[StatementType.DESC_DATABASE.ordinal()] = 1;
            nArray[StatementType.CREATE_TABLE.ordinal()] = 2;
            nArray[StatementType.CREATE_TABLE_AS_SELECT.ordinal()] = 3;
            nArray[StatementType.CREATE_TABLE_AS_LIKE.ordinal()] = 4;
            nArray[StatementType.DROP_TABLE.ordinal()] = 5;
            nArray[StatementType.TRUNCATE_TABLE.ordinal()] = 6;
            nArray[StatementType.MERGE_TABLE.ordinal()] = 7;
            nArray[StatementType.REFRESH_TABLE.ordinal()] = 8;
            nArray[StatementType.LOAD_TEMP_TABLE.ordinal()] = 9;
            nArray[StatementType.EXPORT_TABLE.ordinal()] = 10;
            nArray[StatementType.ANALYZE_TABLE.ordinal()] = 11;
            nArray[StatementType.ALTER_TABLE_RENAME.ordinal()] = 12;
            nArray[StatementType.ALTER_TABLE_ADD_COLS.ordinal()] = 13;
            nArray[StatementType.ALTER_TABLE_PROPERTIES.ordinal()] = 14;
            nArray[StatementType.ALTER_TABLE_RENAME_COL.ordinal()] = 15;
            nArray[StatementType.ALTER_TABLE_DROP_PARTS.ordinal()] = 16;
            nArray[StatementType.ALTER_TABLE_ADD_PARTS.ordinal()] = 17;
            nArray[StatementType.ALTER_TABLE_RENAME_PART.ordinal()] = 18;
            nArray[StatementType.ALTER_TABLE_SET_LOCATION.ordinal()] = 19;
            nArray[StatementType.DESC_TABLE.ordinal()] = 20;
            nArray[StatementType.MSCK_TABLE.ordinal()] = 21;
            nArray[StatementType.ALTER_TABLE_TOUCH.ordinal()] = 22;
            nArray[StatementType.SELECT.ordinal()] = 23;
            nArray[StatementType.INSERT_VALUES.ordinal()] = 24;
            nArray[StatementType.INSERT_SELECT.ordinal()] = 25;
            nArray[StatementType.MULTI_INSERT.ordinal()] = 26;
            nArray[StatementType.CREATE_VIEW.ordinal()] = 27;
            nArray[StatementType.DROP_VIEW.ordinal()] = 28;
            nArray[StatementType.ALTER_VIEW_QUERY.ordinal()] = 29;
            nArray[StatementType.ALTER_VIEW_RENAME.ordinal()] = 30;
            nArray[StatementType.ALTER_VIEW_PROPERTIES.ordinal()] = 31;
            nArray[StatementType.SHOW.ordinal()] = 32;
            nArray[StatementType.SHOW_COLUMNS.ordinal()] = 33;
            nArray[StatementType.SHOW_PARTITIONS.ordinal()] = 34;
            nArray[StatementType.SHOW_TABLES.ordinal()] = 35;
            nArray[StatementType.SHOW_VIEWS.ordinal()] = 36;
            nArray[StatementType.SHOW_TABLE_EXTENDED.ordinal()] = 37;
            nArray[StatementType.SHOW_TABLE_PROPERTIES.ordinal()] = 38;
            nArray[StatementType.SHOW_CREATE_TABLE.ordinal()] = 39;
            nArray[StatementType.SHOW_FUNCTIONS.ordinal()] = 40;
            nArray[StatementType.DESC_FUNCTION.ordinal()] = 41;
            nArray[StatementType.CACHE.ordinal()] = 42;
            nArray[StatementType.UNCACHE.ordinal()] = 43;
            nArray[StatementType.CLEAR_CACHE.ordinal()] = 44;
            nArray[StatementType.DTUNNEL.ordinal()] = 45;
            nArray[StatementType.CALL.ordinal()] = 46;
            nArray[StatementType.DELETE.ordinal()] = 47;
            nArray[StatementType.UPDATE.ordinal()] = 48;
            nArray[StatementType.MERGE_INTO_TABLE.ordinal()] = 49;
            nArray[StatementType.EXPLAIN.ordinal()] = 50;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

